;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1999, Alias|Wavefront, Inc.                       ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias|Wavefront, Inc.  and are   ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias|Wavefront,  Inc.   ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Paint menu
;

(ui-symbol "sid_paint"                (ui-symbol-reference "CML_MAIN"))

; 
; New Image plane menu item
;

(ui-string "mp_imagetools_str"          "Paint")
(ui-string "mp_imagetools_attr_str"     "Paint")

(ui-string "mp_newcanvas_str"          "New Canvas...")
(ui-string "mp_newcanvas_attr_str"     "nwcvs")
(ui-function "m_menu_newcanvas"
        (list 'command                  "NewCanvas")
        (list 'label_string             'mp_newcanvas_str)
        (list 'attribute_string         'mp_newcanvas_attr_str)
        (list 'symbols
              'pa_new_canvas_orientation
              'pa_canvas_type
			  'pa_paper_location
              'pa_new_canvas_background
              'pa_new_canvas_screenscapture
			  'pa_new_canvas_createbookmark
              'pa_new_paper_size_type
              'pa_new_paper_unit_type
              'pa_new_canvas_width_pixels
              'pa_new_canvas_height_pixels
              'pa_new_canvas_width_unit
              'pa_new_canvas_height_unit
			  'pa_new_canvas_dpunit_ui
			  'pa_paper_orientation
       )
)

(ui-string "mp_newoverlay_str" "New Overlay Canvas..." )
(ui-string "mp_newoverlay_attr_str" "nwovr" )
(ui-function "m_menu_newoverlay"
        (list 'command                  "NewOverlay")
        (list 'label_string             'mp_newoverlay_str)
        (list 'attribute_string         'mp_newoverlay_attr_str)
        (list 'symbols
              'pa_new_canvas_orientation
              'pa_canvas_type
			  'pa_paper_location
              'pa_new_canvas_background
              'pa_new_canvas_screenscapture
			  'pa_new_canvas_createbookmark
              'pa_new_paper_size_type
              'pa_new_paper_unit_type
              'pa_new_canvas_width_pixels
              'pa_new_canvas_height_pixels
              'pa_new_canvas_width_unit
              'pa_new_canvas_height_unit
			  'pa_new_canvas_dpunit_ui
			  'pa_paper_orientation
       )
)

(ui-string "mp_addpaint_str" "New Canvas on Construction Plane..." )
(ui-string "mp_addpaint_attr_str" "nwccp" )
(ui-function "m_menu_addpaint"
		(list 'command "AddPaint")
		(list 'label_string 'mp_addpaint_str)
		(list 'attribute_string 'mp_addpaint_attr_str)
		(list 'symbols
              'pa_new_canvas_orientation
              'pa_canvas_type
			  'pa_paper_location
              'pa_new_canvas_background
              'pa_new_canvas_screenscapture
			  'pa_new_canvas_createbookmark
              'pa_new_paper_size_type
              'pa_new_paper_unit_type
              'pa_new_canvas_width_pixels
              'pa_new_canvas_height_pixels
              'pa_new_canvas_width_unit
              'pa_new_canvas_height_unit
			  'pa_new_canvas_dpunit_ui
			  'pa_paper_orientation
		)
)

(ui-string "mp_newcanvascurrwin_str" "New canvas on current window..." )
(ui-function "m_menu_newcanvascurrwin"
		(list 'command "NewCanvasOnCurrWindow")
		(list 'label_string "mp_newcanvascurrwin_str" )
		(list 'attribute_string "mp_newcanvascurrwin_str" )
		(list 'symbols
              'pa_new_canvas_orientation
              'pa_canvas_type
			  'pa_paper_location
              'pa_new_canvas_background
              'pa_new_canvas_screenscapture
			  'pa_new_canvas_createbookmark
              'pa_new_paper_size_type
              'pa_new_paper_unit_type
              'pa_new_canvas_width_pixels
              'pa_new_canvas_height_pixels
              'pa_new_canvas_width_unit
              'pa_new_canvas_height_unit
			  'pa_new_canvas_dpunit_ui
			  'pa_paper_orientation
		)
)

; 
; Invert mask menu item
;

(ui-string "mp_paintinvertmask_str"          "Invert mask layer")
(ui-string "mp_paintinvertmask_attr_str"     "Invert mask layer")

(ui-function "m_menu_paintinvertmask"
        (list 'command                  "InvertMaskLayer")
        (list 'label_string             'mp_paintinvertmask_str)
        (list 'attribute_string         'mp_paintinvertmask_attr_str)
)

(ui-string "mp_paintinvertselmask_str"          "Invert Marquee")
(ui-string "mp_paintinvertselmask_attr_str"     "invmq")

(ui-function "m_menu_paintinvertselmask"
        (list 'command                  "InvertSelectionMaskLayer")
        (list 'label_string             'mp_paintinvertselmask_str)
        (list 'attribute_string         'mp_paintinvertselmask_attr_str)
)

; 
; Clear Image plane menu item
;

(ui-string "mp_paintclearimage_str"          "Clear Canvas Layer")
(ui-string "mp_paintclearimage_attr_str"     "clrcan")
(ui-string "mp_paintclearimage_viewer_str"   "Clear")

(ui-function "m_menu_paintclearimage"
        (list 'command                  "ClearImageLayer")
        (list 'label_string             'mp_paintclearimage_str)
        (list 'attribute_string         'mp_paintclearimage_attr_str)
)

(ui-function "m_menu_paintclearimage_viewer"
        (list 'command                  "ClearImageLayer")
        (list 'label_string             'mp_paintclearimage_viewer_str)
        (list 'attribute_string         'mp_paintclearimage_viewer_str)
)

(ui-string "mp_paintclearsel_str"          "Clear Marquee")
(ui-string "mp_paintclearsel_attr_str"     "clrmq")

(ui-function "m_menu_paintclearselection"
        (list 'command                  "ClearSelectionMask")
        (list 'label_string             'mp_paintclearsel_str)
        (list 'attribute_string         'mp_paintclearsel_attr_str)
)

; 
; Change Image plane menu item
;

(ui-string "mp_changecanvas_str"          "Resize canvas")
(ui-string "mp_changecanvas_attr_str"     "resize")

(ui-function "m_menu_changecanvas"
        (list 'command                  "ChangeImage")
        (list 'label_string             'mp_changecanvas_str)
        (list 'attribute_string         'mp_changecanvas_attr_str)
		(list 'option_editor			"Paint/pa_change_image.o.scm"
										'image.change.options)
)

(ui-string "mp_colorwheeleditor_str"          "Color Editor")
(ui-string "mp_colorwheeleditor_attr_str"     "color")

(ui-function "m_menu_coloreditor"
        (list 'command                  "ColorWheelEditor")
        (list 'label_string             'mp_colorwheeleditor_str)
        (list 'attribute_string         'mp_colorwheeleditor_attr_str)
)

(ui-string "mp_cropcanvas_str"          "Crop to Marquee")
(ui-string "mp_cropcanvas_attr_str"     "crop")

(ui-function "m_menu_cropcanvas"
        (list 'command                  "CropImagePlane")
        (list 'label_string             'mp_cropcanvas_str)
        (list 'attribute_string         'mp_cropcanvas_attr_str)
)

(ui-string "mp_resize_canvas_str"       "Resize Canvas")
(ui-string "mp_resize_canvas_attr_str"  "resize")

(ui-function "m_menu_resize_canvas"
        (list 'command                  "ResizeCanvas")
        (list 'label_string             'mp_resize_canvas_str)
        (list 'attribute_string         'mp_resize_canvas_attr_str)
        (list 'option_function          "ResizeCanvasControlBox")
        (list 'symbols
              'pa_resize_canvas_pixel_width
              'pa_resize_canvas_pixel_height
              'pa_resize_canvas_unit_width
              'pa_resize_canvas_unit_height
        )
)
(ui-function-symbol-list-reset "ResizeCanvas"
        (list "pa_resize_canvas_pixel_width"   1024 )
        (list "pa_resize_canvas_pixel_height"  1024 )
        (list "pa_resize_canvas_unit_width"   1024.0 )
        (list "pa_resize_canvas_unit_height"  1024.0 )
)

; menu items for layer functionality -- up, down, new and delete layer
(ui-string "mp_rasterizelayer_str"      "Rasterize layer")
(ui-string "mp_rasterizelayer_attr_str" "Rasterize layer")

(ui-function "m_menu_rasterizelayer"
        (list 'command                  "rasterizelayer")
        (list 'label_string             'mp_rasterizelayer_str)
        (list 'attribute_string         'mp_rasterizelayer_attr_str)
)

(ui-string "mp_deleteallmasklayers_str"            "Delete All Mask Layers")
(ui-string "mp_deleteallmasklayers_attr_str"       "dmsk")

(ui-function "m_paint_delete_all_masks"
        (list 'command                  "deleteAllMasks")
        (list 'label_string             'mp_deleteallmasklayers_str)
        (list 'attribute_string         'mp_deleteallmasklayers_attr_str)
)

(ui-string "mp_deleteallhidinvmasklayers_str"            "Delete all invisibility mask layers")
(ui-string "mp_deleteallhidinvmasklayers_attr_str"       "Delete all invisibility mask layers")

(ui-function "m_paint_delete_all_hidinv_masks"
        (list 'command                  "deleteAllHiddenInvisibleMasks")
        (list 'label_string             'mp_deleteallhidinvmasklayers_str)
        (list 'attribute_string         'mp_deleteallhidinvmasklayers_attr_str)
)

(ui-string "mp_deleteAllTransformLayers_str"            "Delete all layers in transform group")
(ui-string "mp_deleteAllTransformLayers_attr_str"       "Delete all layers in transform group")

(ui-function "m_paint_delete_all_transform_layers"
        (list 'command                  "deleteAllTransformLayers")
        (list 'label_string             'mp_deleteAllTransformLayers_str)
        (list 'attribute_string         'mp_deleteAllTransformLayers_attr_str)
)

(ui-string "mp_deleteAllInvisibleLayers_str"            "Delete all invisible layers")
(ui-string "mp_deleteAllInvisibleLayers_attr_str"       "Delete all invisible layers")

(ui-function "m_paint_delete_all_invisible_layers"
        (list 'command                  "deleteAllInvisibleLayers")
        (list 'label_string             'mp_deleteAllInvisibleLayers_str)
        (list 'attribute_string         'mp_deleteAllInvisibleLayers_attr_str)
)

(ui-string "mp_deletecanvases_str"            "Delete Canvases")
(ui-string "mp_deletecanvases_attr_str"       "dcan")

(ui-function "m_paint_delete_canvases"
        (list 'command                  "deleteCanvases")
        (list 'label_string             'mp_deletecanvases_str)
        (list 'attribute_string         'mp_deletecanvases_attr_str)
		(list 'option_editor			"Paint/pa_delete_canvases.o.scm"
										'delete_canvases.options)

)

(ui-string "mp_deletecanvasesfromcp_str"            "Delete Canvases from Construction Plane")
(ui-string "mp_deletecanvasesfromcp_attr_str"       "dcncp")

(ui-function "m_paint_delete_canvasesfromcp"
        (list 'command                  "deleteCanvasesFromConstPlane")
        (list 'label_string             'mp_deletecanvasesfromcp_str)
        (list 'attribute_string         'mp_deletecanvasesfromcp_attr_str)
)

; 
; Construction Plane Window menu item
;
(ui-string "mp_constrplanelister_str"          "Construction Plane Editor...")
(ui-string "mp_constrplanelister_attr_str"     "cp ed")

(ui-function "m_menu_constructionplanelister"
        (list 'command                  "ConstructionPlaneLister")
        (list 'label_string             'mp_constrplanelister_str)
        (list 'attribute_string         'mp_constrplanelister_attr_str)
)

(ui-string "mp_canvasinfo_str"          "Canvas General Information...")
(ui-string "mp_canvasinfo_attr_str"     "Canvas General Information...")

(ui-function "m_menu_canvasinfo"
        (list 'command                  "CanvasInfoEditor")
        (list 'label_string             'mp_canvasinfo_str)
        (list 'attribute_string         'mp_canvasinfo_attr_str)
)

; 
; Paint Layer Window menu item
;
(ui-string "mp_paintlayerlister_str"          "Canvas Layer Editor...")
(ui-string "mp_paintlayerlister_attr_str"     "cvsed")

(ui-function "m_menu_paintlayerlister"
        (list 'command                  "PaintLayerLister")
        (list 'label_string             'mp_paintlayerlister_str)
        (list 'attribute_string         'mp_paintlayerlister_attr_str)
)

(ui-function "mp_paint_layerlister"
        (list 'command                  "PaintLayerLister")
        (list 'label_string             'mp_paintlayerlister_str)
        (list 'attribute_string         'mp_paintlayerlister_attr_str)
)

; 
; Toggle Selection mask
;
(ui-string "m_menu_tglselectionmask_str"          "Toggle Marquee")
(ui-string "m_menu_tglselectionmask_attr_str"     "tg mq")

(ui-function "m_menu_tglselectionmask"
        (list 'command                  "PaintTglSelMask")
        (list 'label_string             'm_menu_tglselectionmask_str)
        (list 'attribute_string         'm_menu_tglselectionmask_attr_str)
)

; 
; Clear Selection mask
;
(ui-string "m_menu_clrselectionmask_str"          "Clear selection mask")
(ui-string "m_menu_clrselectionmask_attr_str"     "Clear selection mask")

(ui-function "m_menu_clrselectionmask"
        (list 'command                  "PaintClrSelMask")
        (list 'label_string             'm_menu_clrselectionmask_str)
        (list 'attribute_string         'm_menu_clrselectionmask_attr_str)
)

;
; Toggle 2D Control Panel
;
(ui-string "mp_2DPanel_str"          "Tgl paint panel")
(ui-string "mp_2DPanel_attr_str"     "tglpntPnl")

(ui-function "m_menu_2DPanel"
        (list 'command                  "toggle2DPanel")
        (list 'label_string             'mp_2DPanel_str)
        (list 'attribute_string         'mp_2DPanel_attr_str)
)

;
; 2D Mode
;
(ui-string "mp_2DMode_str"          "Paint Default UI")
(ui-string "mp_2DMode_attr_str"     "Paint")

(ui-function "m_menu_2DMode"
        (list 'command                  "SwitchToPaintUI")
        (list 'label_string             'mp_2DMode_str)
        (list 'attribute_string         'mp_2DMode_attr_str)
		(list 'option_editor			"Paint/paint_mode.o.scm"
										'paint_mode.options)
)
 
;
; 3D Mode
;
(ui-string "mp_3DMode_str"          "Modeling Default UI")
(ui-string "mp_3DMode_attr_str"     "Modeling")

(ui-function "m_menu_3DMode"
        (list 'command                  "SwitchToModelingUI")
        (list 'label_string             'mp_3DMode_str)
        (list 'attribute_string         'mp_3DMode_attr_str)
		(list 'option_editor			"Paint/standard3d_mode.o.scm"
										'standard3d_mode.options)
)

;
; Re-import layer source files
;
(ui-string "mp_reimport_layers_str"          "Re-Import Canvas Layers")
(ui-string "mp_reimport_layers_attr_str"     "cnvimprt")

(ui-function "m_menu_reimport_layers"
    (list 'command          "ReimportCanvasLayers")
  (list 'label_string     'mp_reimport_layers_str)
  (list 'attribute_string 'mp_reimport_layers_attr_str)
  (list 'option_editor    "Paint/pa_reimport_layers.o.scm"
                          'reimport_layers_options)
)
