;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1999, Alias|Wavefront, Inc.                       ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias|Wavefront, Inc.  and are   ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias|Wavefront,  Inc.   ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;       File:           pa_vars.v.scm
;       Routines:       <none>
;       Purpose:        Scheme - Paint variables

; Default brush settings for 2B pencil


(ui-symbol "pa_brush_mode"            1)

(ui-symbol "pa_brush_color"          0.0 0.0 0.0)

(ui-symbol "pa_brush_colorA"          1.0)
(ui-symbol "pa_preserve_color"        'FALSE)

(ui-symbol "pa_capture_mode"           3)
(ui-symbol "pa_use_stamp"              -1)

; old variable, but don't delete it yet
(ui-symbol "pa_shape_stamp"           'FALSE)  
(ui-symbol "pa_texture_stamp"         'FALSE)

(ui-symbol "pa_shape_filename"           "")
(ui-symbol "pa_texture_filename"         "")

(ui-symbol "pa_brush_min_radius"             0.00)
(ui-symbol "pa_brush_max_radius"             0.00)
(ui-symbol "pa_brush_min_opacity"            0.00)
(ui-symbol "pa_brush_max_opacity"            0.00)
(ui-symbol "pa_brush_aspect"                 0.00)
(ui-symbol "pa_brush_rotation"               0.0)
(ui-symbol "pa_brush_profile"                0)
(ui-symbol "pa_brush_profile_vector"        '(0.0 0.0 0.5 1.0 1.0 0.0))
(ui-symbol "pa_marker_wetness"               0.50)
(ui-symbol "pa_floodandmagic_tolerance"      20.0)

(ui-symbol "pa_sharpenbrush_sharpness"       5.0)
(ui-symbol "pa_sharpenbrush_radius"		     1.5)
(ui-symbol "pa_blurbrush_radius"             3.0)

(ui-symbol "pa_sharpen_sharpness"            5.0)
(ui-symbol "pa_sharpen_radius"			     1.5)
(ui-symbol "pa_blur_radius"                  3.0)

(ui-symbol "pa_dodge_selection"              1)
(ui-symbol "pa_dodge_factor"                 0.5)
(ui-symbol "pa_burn_selection"               1)
(ui-symbol "pa_burn_factor"                  0.5)

(ui-symbol "pa_spacing_bias"                 1.0)
(ui-symbol "pa_spacing_noise"                0.0)
(ui-symbol "pa_rotate_to_stroke"             'FALSE)
(ui-symbol "pa_rotation_jitter"              0.0)

(ui-symbol "pa_brush_pressure"              1)
; SID delete canvases options
(ui-symbol "pa_delete_canvases_mode" (ui-symbol-reference "PA_DELETE_CANVAS_MODE_ALL" ) )

; SID new canvas options
(ui-symbol "pa_new_width_type"                          (ui-symbol-reference "MO_CANVAS_SIZE"))
(ui-symbol "pa_new_x_fill_type"                         (ui-symbol-reference "MO_CANVAS_PIXELS"))
(ui-symbol "pa_new_pixels_x"                            1280)
(ui-symbol "pa_new_units_x"                                     64.0 )
(ui-symbol "pa_new_height_type"                         (ui-symbol-reference "MO_CANVAS_SIZE"))
(ui-symbol "pa_new_y_fill_type"                         (ui-symbol-reference "MO_CANVAS_PIXELS"))
(ui-symbol "pa_new_pixels_y"                            1024)
(ui-symbol "pa_new_units_y"                                     48.0 )
(ui-symbol "pa_new_res"                                         1 )
(ui-symbol "pa_new_fit_type"                            (ui-symbol-reference "MO_CANVAS_FIT_HEIGHT"))
(ui-symbol "pa_depth"							(ui-symbol-reference "PA_DEPTH_BACKGROUND"))

(ui-symbol "pa_new_canvas_orientation" 5 )
(ui-symbol "pa_paper_location" ( ui-symbol-reference "PA_PAPER_LOCATION_CENTERWINDOW" ) )
(ui-symbol "pa_canvas_type" (ui-symbol-reference "PA_CANVAS_TYPE_STANDARD") )
(ui-symbol "pa_new_canvas_background" (ui-symbol-reference "PA_BACKGROUND_TRANSPARENT"))
(ui-symbol "pa_new_canvas_screenscapture" 'FALSE )
(ui-symbol "pa_new_canvas_createbookmark" #t )
(ui-symbol "pa_new_paper_size_type" (ui-symbol-reference "PA_PAPER_SIZE_A4"))
(ui-symbol "pa_new_paper_unit_type" (ui-symbol-reference "PA_PAPER_UNIT_MM"))
(ui-symbol "pa_new_canvas_width_pixels" 1650.0 )
(ui-symbol "pa_new_canvas_height_pixels" 1275.0 )
(ui-symbol "pa_new_canvas_width_unit" 0.0 )
(ui-symbol "pa_new_canvas_height_unit" 0.0 )
(ui-symbol "pa_new_canvas_dpunit_ui" 4.0 )
(ui-symbol "pa_paper_orientation" ( ui-symbol-reference "PA_PAPER_LANDSCAPE" ) )

(ui-symbol "pa_add_paint_pixel_width" 1597 )
(ui-symbol "pa_add_paint_pixel_height" 987 )
(ui-symbol "pa_add_paint_background" (ui-symbol-reference "PA_BACKGROUND_TRANSPARENT"))

; SID change canvas options
(ui-symbol "pa_change_canvas_width_type"        (ui-symbol-reference "MO_CANVAS_FIT"))
(ui-symbol "pa_change_canvas_lr_side"           (ui-symbol-reference "MO_CANVAS_BOTH"))
(ui-symbol "pa_change_canvas_x_fill_type"       (ui-symbol-reference "MO_CANVAS_PIXELS"))
(ui-symbol "pa_change_canvas_pixels_x"          (ui-symbol-reference "MO_CANVAS_NUM_PIXELS"))
(ui-symbol "pa_change_canvas_units_x"           (ui-symbol-reference "MO_CANVAS_NUM_UNITS"))

(ui-symbol "pa_change_canvas_height_type"       (ui-symbol-reference "MO_CANVAS_FIT"))
(ui-symbol "pa_change_canvas_tb_side"           (ui-symbol-reference "MO_CANVAS_BOTH"))
(ui-symbol "pa_change_canvas_y_fill_type"       (ui-symbol-reference "MO_CANVAS_PIXELS"))
(ui-symbol "pa_change_canvas_pixels_y"          (ui-symbol-reference "MO_CANVAS_NUM_PIXELS"))
(ui-symbol "pa_change_canvas_units_y"           (ui-symbol-reference "MO_CANVAS_NUM_UNITS"))

(ui-symbol "pa_image_layer_type"                (ui-symbol-reference "MO_IMAGE_AS_IMAGE"))
(ui-symbol "pa_always_create_canvas"            #f)

(ui-symbol "pa_text_font"	-2 )
(ui-symbol "pa_text_style"	-2 )
(ui-symbol "pa_text_size"	24 )
(ui-symbol "pa_text_tracking"	1 )
(ui-symbol "pa_text_underline"	'FALSE )
(ui-symbol "pa_text_strikeout" 'FALSE )

; Reimport canvas layer options
(ui-symbol "pa_reimport_canvas" 1)
(ui-symbol "pa_reimport_missing_files" 1)

; Vars for the Paint Controlpanel editor

(ui-symbol "pn_cpanel.brush.style"				0 )
(ui-symbol "pn_cpanel.brush.profile"			0 )
(ui-symbol "pn_cpanel.brush.red"				0.0 )
(ui-symbol "pn_cpanel.brush.green"				0.0 )
(ui-symbol "pn_cpanel.brush.blue"				0.0 )
(ui-symbol "pn_cpanel.brush.minopcty"			0.0 )
(ui-symbol "pn_cpanel.brush.maxopcty"			0.0 )
(ui-symbol "pn_cpanel.brush.minrds"				0.0 )
(ui-symbol "pn_cpanel.brush.maxrds"				1.0 )
(ui-symbol "pn_cpanel.brush.aspect"				0.0 )
(ui-symbol "pn_cpanel.brush.rot"				0.0 )

(ui-symbol "pn_cpanel.autoshape.stype"          0 )
(ui-symbol "pn_cpanel.interactiveshapes.on"     1 ) 

(ui-symbol "pn_cpanel.outlines.red"             0.0 )
(ui-symbol "pn_cpanel.outlines.green"           119.99994 )
(ui-symbol "pn_cpanel.outlines.blue"            204.0 )
(ui-symbol "pn_cpanel.outlines.opacity"         1.0 )
(ui-symbol "pn_cpanel.outlines.style"           0 )
(ui-symbol "pn_cpanel.outlines.width"           4.0 )
(ui-symbol "pn_cpanel.outlines.aspect"          1.0 )
(ui-symbol "pn_cpanel.outlines.rotation"        0.0 )
(ui-symbol "pn_cpanel.outlines.spacing"         1.0 )   
(ui-symbol "pn_cpanel.outlines.pos"                     0 )
(ui-symbol "pn_cpanel.outlines.visible"         #t )

(ui-symbol "pn_cpanel.fill.red"                         0.0 )
(ui-symbol "pn_cpanel.fill.green"                       119.99994 )
(ui-symbol "pn_cpanel.fill.blue"                        204.0 )
(ui-symbol "pn_cpanel.fill.opacity"                     1.0 )
(ui-symbol "pn_cpanel.fill.visible"                     #t )
(ui-symbol "pn_cpanel.fill.quality"                     1 )
(ui-symbol "pn_cpanel.fill.inside"                      2 )
(ui-symbol "pn_cpanel.shapePasteOpt"                    0 )
 
(ui-symbol "pn_cpanel.warp.influence"                   40.0 )
(ui-symbol "pn_cpanel.warp.feedback"                    #f )

(ui-symbol "pn_cpanel.text.font"                   1 )
(ui-symbol "pn_cpanel.text.style"                  1 )

(ui-symbol "pn_cpanel.shapeTex.General.name"                  "Solid" )
(ui-symbol "pn_cpanel.shapeTex.General.type"                  "Solid" )
(ui-symbol "pn_cpanel.shapeTex.General.urepeat"               0.0 )
(ui-symbol "pn_cpanel.shapeTex.General.vrepeat"               0.0 )
(ui-symbol "pn_cpanel.shapeTex.General.utranslate"            0.0 )
(ui-symbol "pn_cpanel.shapeTex.General.vtranslate"            0.0 )
(ui-symbol "pn_cpanel.shapeTex.General.uwrap"                 #f )
(ui-symbol "pn_cpanel.shapeTex.General.vwrap"                 #f )
(ui-symbol "pn_cpanel.shapeTex.General.rotate"                0.0 )

(ui-symbol "pn_cpanel.shapeTex.Bulge.uwidth"                  0.1 )
(ui-symbol "pn_cpanel.shapeTex.Bulge.vwidth"                  0.1 )

(ui-symbol "pn_cpanel.shapeTex.Grid.uwidth"                   0.1 )
(ui-symbol "pn_cpanel.shapeTex.Grid.vwidth"                   0.1 )
(ui-symbol "pn_cpanel.shapeTex.Grid.contrast"                 1.0 )
(ui-symbol "pn_cpanel.shapeTex.Grid.line_color.red"           255.0 )
(ui-symbol "pn_cpanel.shapeTex.Grid.line_color.green"         255.0 )
(ui-symbol "pn_cpanel.shapeTex.Grid.line_color.blue"          255.0 )
(ui-symbol "pn_cpanel.shapeTex.Grid.filler_color.red"         0.0 )
(ui-symbol "pn_cpanel.shapeTex.Grid.filler_color.green"       0.0 )
(ui-symbol "pn_cpanel.shapeTex.Grid.filler_color.blue"        0.0 )

(ui-symbol "pn_cpanel.shapeTex.Mount.snow_colour.red"           255.0 )
(ui-symbol "pn_cpanel.shapeTex.Mount.snow_colour.green"         255.0 )
(ui-symbol "pn_cpanel.shapeTex.Mount.snow_colour.blue"          255.0 )
(ui-symbol "pn_cpanel.shapeTex.Mount.rock_colour.red"           90.0 )
(ui-symbol "pn_cpanel.shapeTex.Mount.rock_colour.green"         110.0 )
(ui-symbol "pn_cpanel.shapeTex.Mount.rock_colour.blue"          120.0 )
(ui-symbol "pn_cpanel.shapeTex.Mount.snow_altitude"             0.5 )
(ui-symbol "pn_cpanel.shapeTex.Mount.snow_dropoff"              2.0 )
(ui-symbol "pn_cpanel.shapeTex.Mount.snow_slope"                0.8 )
(ui-symbol "pn_cpanel.shapeTex.Mount.snow_fractal"              0.4 )
(ui-symbol "pn_cpanel.shapeTex.Mount.snow_border"               1.0 )
(ui-symbol "pn_cpanel.shapeTex.Mount.level_max"                 20.0)
(ui-symbol "pn_cpanel.shapeTex.Mount.rock_amplitude"            1.0 )
(ui-symbol "pn_cpanel.shapeTex.Mount.rock_fractal"              0.707 )

(ui-symbol "pn_cpanel.shapeTex.Checker.contrast"                1.0 )
(ui-symbol "pn_cpanel.shapeTex.Checker.color1.red"              255.0 )
(ui-symbol "pn_cpanel.shapeTex.Checker.color1.green"            255.0 )
(ui-symbol "pn_cpanel.shapeTex.Checker.color1.blue"             255.0 )
(ui-symbol "pn_cpanel.shapeTex.Checker.color2.red"              0.0 )
(ui-symbol "pn_cpanel.shapeTex.Checker.color2.green"            0.0 )
(ui-symbol "pn_cpanel.shapeTex.Checker.color2.blue"             0.0 )

(ui-symbol "pn_cpanel.shapeTex.Noise.animated"                  0.0 )
(ui-symbol "pn_cpanel.shapeTex.Noise.time"                      0.0 )
(ui-symbol "pn_cpanel.shapeTex.Noise.amplitude"                 1.0 )
(ui-symbol "pn_cpanel.shapeTex.Noise.threshold"                 0.0 )

(ui-symbol "pn_cpanel.shapeTex.Cloth.u_thread_width"            0.75 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.v_thread_width"            0.75 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.u_wave"                    0.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.v_wave"                    0.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.randomness"                0.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.intensity_spread"          0.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.width_spread"              0.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.u_thread_color.red"        255.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.u_thread_color.green"      255.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.u_thread_color.blue"       255.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.v_thread_color.red"        255.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.v_thread_color.green"      0.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.v_thread_color.blue"       0.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.gap_color.red"             0.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.gap_color.green"           0.0 )
(ui-symbol "pn_cpanel.shapeTex.Cloth.gap_color.blue "           0.0 )  

(ui-symbol "pn_cpanel.shapeTex.Ramp.ramp_type"                  0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.interpolation"              1 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.list_length"                3 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.number_entries"             3 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.u_wave"                     0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.v_wave"                     0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.noise"                      0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.noise_frequency"            0.5 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.hue_noise"                  0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.hue_noise_frequency"        0.5 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.sat_noise"                  0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.sat_noise_frequency"        0.5 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.val_noise"                  0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.val_noise_frequency"        0.5 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.edit_color.red"             0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.edit_color.green"           0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.edit_color.blue"            0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.edit_value"                 0.0 )
(ui-symbol "pn_cpanel.shapeTex.Ramp.recordvalue"                "" )

(ui-symbol "pn_cpanel.shapeTex.Water.reflections"              0 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_wavenumber"        25.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_phase_velocity"    2.5 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_group_velocity"    1.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_origin_spread"     0.005 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_spread_rate"       0.3 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_amplitude"         0.05 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_u_origin"          0.5 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_v_origin"          0.5 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_time"              0.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.numwaves"                 8 )
(ui-symbol "pn_cpanel.shapeTex.Water.wave_frequency_step"      0.125 )
(ui-symbol "pn_cpanel.shapeTex.Water.wind_u"                   1.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.wind_v"                   0.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.wave_time"                0.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.wave_amplitude"           0.05 )
(ui-symbol "pn_cpanel.shapeTex.Water.wave_amplitude_power"     2.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.ripple_drop_size"         0.3 )
(ui-symbol "pn_cpanel.shapeTex.Water.umin"                     0.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.umax"                     1.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.vmin"                     0.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.vmax"                     1.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.wavenumber"               4.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.wave_velocity"            1.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.wave_u_origin"            0.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.wave_v_origin"            0.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.spread_pc"                0.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.envelope_scale_pc"        0.0 )
(ui-symbol "pn_cpanel.shapeTex.Water.wave_array_size"          0.0 )

(ui-symbol "pn_cpanel.shapeTex.Leather.invdet"                  0.0 )
(ui-symbol "pn_cpanel.shapeTex.Leather.creases"                 1 )
(ui-symbol "pn_cpanel.shapeTex.Leather.density"                 1.0 )
(ui-symbol "pn_cpanel.shapeTex.Leather.cell_size"               0.5 )
(ui-symbol "pn_cpanel.shapeTex.Leather.spottyness"              0.1 )
(ui-symbol "pn_cpanel.shapeTex.Leather.randomness"              0.5 )
(ui-symbol "pn_cpanel.shapeTex.Leather.threshold"               0.83)
(ui-symbol "pn_cpanel.shapeTex.Leather.contrast"                1.0 )
(ui-symbol "pn_cpanel.shapeTex.Leather.cell_color.red"          95.0 )
(ui-symbol "pn_cpanel.shapeTex.Leather.cell_color.green"        40.0 )
(ui-symbol "pn_cpanel.shapeTex.Leather.cell_color.blue"         15.0 )
(ui-symbol "pn_cpanel.shapeTex.Leather.crease_color.red"        60.0)
(ui-symbol "pn_cpanel.shapeTex.Leather.crease_color.green"      30.0 )
(ui-symbol "pn_cpanel.shapeTex.Leather.crease_color.blue"       0.0 )

(ui-symbol "pn_cpanel.shapeTex.Granite.invdet"                      0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.creases"                     1 )
(ui-symbol "pn_cpanel.shapeTex.Granite.density"                     1.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.cell_size"                   0.15 )
(ui-symbol "pn_cpanel.shapeTex.Granite.spottyness"                  0.3 )
(ui-symbol "pn_cpanel.shapeTex.Granite.randomness"                  1.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.threshold"                   0.5 )
(ui-symbol "pn_cpanel.shapeTex.Granite.contrast"                    1.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.mix_ratio"                   0.5 )
(ui-symbol "pn_cpanel.shapeTex.Granite.color1.red"                  0.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.color1.green"                0.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.color1.blue"                 0.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.color2.red"                  140.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.color2.green"                200.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.color2.blue"                 100.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.color3.red"                  160.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.color3.green"                210.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.color3.blue"                 210.0)
(ui-symbol "pn_cpanel.shapeTex.Granite.filler_color.red"            150.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.filler_color.green"          75.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.filler_color.blue"           50.0)
(ui-symbol "pn_cpanel.shapeTex.Granite.c1level"                     0.0 )
(ui-symbol "pn_cpanel.shapeTex.Granite.c2level"                     0.0 )



; Magic Wand
(ui-symbol "pa_magicwand_mode"				(ui-symbol-reference "PA_MAGICWAND_NEW"))
(ui-symbol "pa_magicwand_tolerance"          20.0)

; Marquee
(ui-symbol "pa_marquee_mode"    (ui-symbol-reference "PA_MARQUEE_NEW"))
(ui-symbol "pa_marquee_constraint"    #f )


; Set Color Tool
(ui-symbol "pa_colorR"          0)
(ui-symbol "pa_colorG"          0)
(ui-symbol "pa_colorB"          0)


; Paint Mode
(ui-symbol "pa_paintmode_menu"	#t)
(ui-symbol "pa_paintmode_color_type" (ui-symbol-reference "PA_PAINTMODE_DEFAULT"))
(ui-symbol "pa_paintmode_color_filename" "" )
(ui-symbol "pa_paintmode_panel" #t)
(ui-symbol "pa_paintmode_mm"	#t)
(ui-symbol "pa_paintmode_grid"	#t)

; Standard 3d Mode
(ui-symbol "pa_standard3dmode_menu"	#t)
(ui-symbol "pa_standard3dmode_menu_choice"	(ui-symbol-reference "MENU_LONG"))
(ui-symbol "pa_standard3dmode_color" #t)
(ui-symbol "pa_standard3dmode_panel" #t)
(ui-symbol "pa_standard3dmode_mm"	#t)
(ui-symbol "pa_standard3dmode_grid"	#t)


; Pick Layer Mode

(ui-symbol "pa_picklayer_opacity"	0.25)
(ui-symbol "pa_picklayer_ignoreshape"	#f)
(ui-symbol "pa_picklayer_ignoretext"	#f)


; AutoShape 
(ui-symbol "pa_autoshape_type"  0)


; Image Deform
(ui-symbol "pa_image_deform_constraint"             1)
(ui-symbol "pa_image_deform_type"                   1)
(ui-symbol "pa_image_deform_interactive_display"          1)
(ui-symbol "pa_image_deform_use_guidelines"          1)
(ui-symbol "pa_image_deform_u_bias"          0.0)
(ui-symbol "pa_image_deform_v_bias"          0.0)


; ColorCorrect tools
(ui-symbol "pa_cc_selectiontype"  3)
(ui-symbol "pa_cc_brightness"  0)
(ui-symbol "pa_cc_contrast"  0)
(ui-symbol "pa_cc_saturation"  0)
(ui-symbol "pa_cc_value"  0)
(ui-symbol "pa_cc_dodge"  0)
(ui-symbol "pa_cc_dodge_color"          255.0 255.0 255.0)
(ui-symbol "pa_cc_burn"  0)
(ui-symbol "pa_cc_burn_color"          0.0 0.0 0.0)
(ui-symbol "pa_cc_colorbalance"  30)
(ui-symbol "pa_cc_addhuetogray" #f)
(ui-symbol "pa_cc_colorreplace_hue"  #t)
(ui-symbol "pa_cc_colorreplace_sat"  #t)
(ui-symbol "pa_cc_colorreplace_val"  #t)

; Image color editor tool

(ui-symbol "pa_ce_preview" 1)
(ui-symbol "pa_ce_hueadjustmode" 2)
(ui-symbol "pa_ce_strength" 0.5)
(ui-symbol "pa_ce_Hue" 180.0)
(ui-symbol "pa_ce_Saturation" 0.0)
(ui-symbol "pa_ce_Luminance" 0.0)
(ui-symbol "pa_ce_Hue_shift" 0.0)
(ui-symbol "pa_ce_Saturation_shift" 0.0)
(ui-symbol "pa_ce_Luminance_shift" 0.0)
(ui-symbol "pa_ce_brightness"  0)
(ui-symbol "pa_ce_contrast"  0)
(ui-symbol "pa_ce_highlightsTone" 0.0)
(ui-symbol "pa_ce_lightTone" 0.0)
(ui-symbol "pa_ce_darkTone" 0.0)
(ui-symbol "pa_ce_ShadowsTone" 0.0)
(ui-symbol "pa_ce_redHue" 0.0)
(ui-symbol "pa_ce_redSaturation" 0.0)
(ui-symbol "pa_ce_redLuminance" 0.0)
(ui-symbol "pa_ce_orangeHue" 0.0)
(ui-symbol "pa_ce_orangeSaturation" 0.0)
(ui-symbol "pa_ce_orangeLuminance" 0.0)
(ui-symbol "pa_ce_yellowHue" 0.0)
(ui-symbol "pa_ce_yellowSaturation" 0.0)
(ui-symbol "pa_ce_yellowLuminance" 0.0)
(ui-symbol "pa_ce_greenHue" 0.0)
(ui-symbol "pa_ce_greenSaturation" 0.0)
(ui-symbol "pa_ce_greenLuminance" 0.0)
(ui-symbol "pa_ce_turquoiseHue" 0.0)
(ui-symbol "pa_ce_turquoiseSaturation" 0.0)
(ui-symbol "pa_ce_turquoiseLuminance" 0.0)
(ui-symbol "pa_ce_blueHue" 0.0)
(ui-symbol "pa_ce_blueSaturation" 0.0)
(ui-symbol "pa_ce_blueLuminance" 0.0)
(ui-symbol "pa_ce_violetHue" 0.0)
(ui-symbol "pa_ce_violetSaturation" 0.0)
(ui-symbol "pa_ce_violetLuminance" 0.0)
(ui-symbol "pa_ce_magentHue" 0.0)
(ui-symbol "pa_ce_magentSaturation" 0.0)
(ui-symbol "pa_ce_magentLuminance" 0.0)
(ui-symbol "pa_ce_violetSaturation" 0.0)
(ui-symbol "pa_ce_dropoff" 50) 
(ui-symbol "pa_ce_order" 0)
(ui-symbol "pa_ce_pageID" 1)

















