;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 2004, Alias Systems Corp                          ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; New Overlay Option Box
;;;

(ui-string "new_overlay.name"                 "New Overlay Canvas Options")

(ui-string "pa_new_overlay_size_type" "Size")
(ui-string "pa_new_overlay_pixel_width" "Width (pixels)")
(ui-string "pa_new_overlay_pixel_height" "Height (pixels)")
(ui-string "pa_new_overlay_placement" "Placement")
(ui-string "pa_new_overlay_grab_screen" "Grab Screen")

(ui-string "new_overlay.size.window" "Window")
(ui-string "new_overlay.size.specify" "Specify")

(ui-string "new_overlay.placement.letterbox" "Letterbox" )
(ui-string "new_overlay.placement.fill" "Fill" )
(ui-string "new_overlay.placement.width" "Fit Width" )
(ui-string "new_overlay.placement.height" "Fit Height" )

(ui-editor "new_overlay.options"

	(list 'title 'new_overlay.name)

    (list 'symbols
          'pa_new_overlay_size_type
          'pa_new_overlay_pixel_width
          'pa_new_overlay_pixel_height
          'pa_new_overlay_placement
          'pa_new_overlay_grab_screen
          )

	(list 'buttons 'Reset 'Save 'Exit 'Go)

    ( ui-radio-widget "pa_new_overlay_size_type"
                      ( list 'rebuild #t )
                      ( ui-choice "new_overlay.size.specify"  'PA_SPECIFY_SIZE ) 
                      ( ui-choice "new_overlay.size.window" 'PA_FIT_WINDOW ))

    ( ui-integer-widget "pa_new_overlay_pixel_width"
                        (list 'slider_range 1 8000 )
                        (list 'range 1 8000 )
                        (list 'enabled
                              (ui-eq "pa_new_overlay_size_type" 1 ) ) )

    ( ui-integer-widget "pa_new_overlay_pixel_height"
                        (list 'slider_range 1 8000 )
                        (list 'range 1 8000 )
                        (list 'enabled
                              (ui-eq "pa_new_overlay_size_type" 1 ) ) )

    ( ui-radio-widget "pa_new_overlay_placement"
                      ( ui-choice "new_overlay.placement.letterbox" 'PA_PLACEMENT_LETTERBOX )
                      ( ui-choice "new_overlay.placement.fill" 'PA_PLACEMENT_FILL )
                      ( ui-choice "new_overlay.placement.width" 'PA_PLACEMENT_WIDTH )
                      ( ui-choice "new_overlay.placement.height" 'PA_PLACEMENT_HEIGHT )
                      ( list 'enabled
                             (ui-eq "pa_new_overlay_size_type" 1 ) ) )

	( ui-tick-widget "pa_new_overlay_grab_screen" )
)
