;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1999, Alias|Wavefront, Inc.                       ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias|Wavefront, Inc.  and are   ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias|Wavefront,  Inc.   ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Change Image Options
;;;

(ui-string "image.change.name"                          "Resize Sketching Image Plane Options")

(ui-string "pa_change_canvas_width_type"                "Image Plane Width")
(ui-string "change.fit"                                 "Fit Window")
(ui-string "change.size"                                "Specified")
(ui-string "change.neither"                             "Neither")

(ui-string "pa_change_canvas_lr_side"                   "Side")
(ui-string "change.left"                                "Left")
(ui-string "change.right"                               "Right")
(ui-string "change.both"                                "Both")

(ui-string "pa_change_canvas_x_fill_type"               "Fill Type")
(ui-string "change.pixels"                              "Pixels")
(ui-string "change.units"                               "Units")

(ui-string "pa_change_canvas_pixels_x"                  "Pixels")
(ui-string "pa_change_canvas_units_x"                   "Units")

(ui-string "pa_change_canvas_height_type"               "Image Plane Height")
(ui-string "pa_change_canvas_tb_side"                   "Side")
(ui-string "pa_change_canvas_y_fill_type"               "Fill Type")
(ui-string "pa_change_canvas_pixels_y"                  "Pixels")
(ui-string "pa_change_canvas_units_y"                   "Units")
(ui-string "change.top"                                 "Top")
(ui-string "change.bottom"                              "Bottom")

(ui-editor "image.change.options"              

        (list 'title 'image.change.name)

        (list 'symbols  'pa_change_canvas_width_type
                                        'pa_change_canvas_x_fill_type
                                        'pa_change_canvas_pixels_x
                                        'pa_change_canvas_units_x
                                        'pa_change_canvas_lr_side
                                        'pa_change_canvas_height_type
                                        'pa_change_canvas_y_fill_type
                                        'pa_change_canvas_pixels_y
                                        'pa_change_canvas_units_y
                                        'pa_change_canvas_tb_side
        )

        (list 'buttons 'Reset 'Save 'Exit 'Go)

        (ui-radio-widget "pa_change_canvas_width_type"    
                (list 'rebuild #t)
                (ui-choice "change.fit"                 'MO_CANVAS_FIT)
                (ui-choice "change.size"                'MO_CANVAS_SIZE)
                (ui-choice "change.neither"             'MO_CANVAS_NEITHER)
        )

        (ui-radio-widget "pa_change_canvas_lr_side"
                (list 'rebuild #t)
                (list 'enabled (ui-eq "pa_change_canvas_width_type" 'MO_CANVAS_SIZE))
                (ui-choice "change.left"                'MO_CANVAS_LEFT)
                (ui-choice "change.right"               'MO_CANVAS_RIGHT)
                (ui-choice "change.both"                'MO_CANVAS_BOTH)
        )

        (ui-radio-widget "pa_change_canvas_x_fill_type"
                (list 'rebuild #t)
                (list 'enabled (ui-eq "pa_change_canvas_width_type" 'MO_CANVAS_SIZE))
                (ui-choice "change.pixels"              'MO_CANVAS_PIXELS)
                (ui-choice "change.units"               'MO_CANVAS_UNITS)
        )

        (ui-integer-widget "pa_change_canvas_pixels_x"
                (list 'rebuild #t)
                (list 'enabled (ui-and
                        (ui-eq "pa_change_canvas_width_type" 'MO_CANVAS_SIZE)
                        (ui-eq "pa_change_canvas_x_fill_type" 'MO_CANVAS_PIXELS)))
                (list 'range -6144 6144)
        )

        (ui-distance-widget "pa_change_canvas_units_x"
                (list 'rebuild #t)
                (list 'enabled (ui-and
                        (ui-eq "pa_change_canvas_width_type" 'MO_CANVAS_SIZE)
                        (ui-eq "pa_change_canvas_x_fill_type" 'MO_CANVAS_UNITS)))
                (list 'range -10000.00 10000.00)
                (list 'precision "%f7.2")
        )

        (ui-blank-widget)
        (ui-separator-widget)

        (ui-radio-widget "pa_change_canvas_height_type"    
                (list 'rebuild #t)
                (ui-choice "change.fit"                 'MO_CANVAS_FIT)
                (ui-choice "change.size"                'MO_CANVAS_SIZE)
                (ui-choice "change.neither"             'MO_CANVAS_NEITHER)
        )

        (ui-radio-widget "pa_change_canvas_tb_side"
                (list 'rebuild #t)
                (list 'enabled (ui-eq "pa_change_canvas_height_type" 'MO_CANVAS_SIZE))
                (ui-choice "change.top"                 'MO_CANVAS_TOP)
                (ui-choice "change.bottom"              'MO_CANVAS_BOTTOM)
                (ui-choice "change.both"                'MO_CANVAS_BOTH)
        )

        (ui-radio-widget "pa_change_canvas_y_fill_type"
                (list 'rebuild #t)
                (list 'enabled (ui-eq "pa_change_canvas_height_type" 'MO_CANVAS_SIZE))
                (ui-choice "change.pixels"              'MO_CANVAS_PIXELS)
                (ui-choice "change.units"               'MO_CANVAS_UNITS)
        )

        (ui-integer-widget "pa_change_canvas_pixels_y"
                (list 'rebuild #t)
                (list 'enabled (ui-and
                        (ui-eq "pa_change_canvas_height_type" 'MO_CANVAS_SIZE)
                        (ui-eq "pa_change_canvas_y_fill_type" 'MO_CANVAS_PIXELS)))
                (list 'range -6144 6144)
        )

        (ui-distance-widget "pa_change_canvas_units_y"
                (list 'rebuild #t)
                (list 'enabled (ui-and
                        (ui-eq "pa_change_canvas_height_type" 'MO_CANVAS_SIZE)
                        (ui-eq "pa_change_canvas_y_fill_type" 'MO_CANVAS_UNITS)))
                (list 'range -10000.00 10000.00)
                (list 'precision "%f7.2")
        )
)

