;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 2001, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Undo/Redo Options

(ui-string "undo_redo.name"             "Undo/Redo Options")
(ui-string "undo_redo_limit_number"     "Limit number of undo commands")
(ui-string "undo_redo_limit_memory"     "Limit memory used by undo")
(ui-string "undo_redo_number_limit"     "Maximum number of undo commands")
(ui-string "undo_redo_memory_limit"     "Maximum memory used by undo (Mbytes)")

(ui-editor "undo_redo.options" 

	(list 'title 'undo_redo.name)

	(list 'symbols 	'undo_redo_limit_number
					'undo_redo_limit_memory
					'undo_redo_number_limit
					'undo_redo_memory_limit
					)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-tick-widget "undo_redo_limit_number"
					(list 'rebuild #t)
					)

	(ui-integer-widget "undo_redo_number_limit" 
		(list 'enabled (ui-eq 'undo_redo_limit_number #t))
		(list 'range 0 1000)
		)
	
	(ui-tick-widget "undo_redo_limit_memory"
					(list 'rebuild #t)
					)

	(ui-integer-widget "undo_redo_memory_limit" 
		(list 'enabled (ui-eq 'undo_redo_limit_memory #t))
		(list 'range 0 100)
		)
)
