;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
;  this code,  you  are  agreeing  to the terms and conditions of the
;  License  Agreement  included  in  the documentation for this code.
;  AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
;  CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
;  IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
;  DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
;  DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
; 
;  Use, duplication,  or disclosure by the U.S. Government is subject
;  to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
;  Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
;  (Rights  in Technical Data and Computer Software),  as applicable.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; Window Toggle Options

(ui-string "display.all"                "All Windows")
(ui-string "display.current"            "Current Window")

(map (lambda (arg)
    (let* ((base (car arg))
           (title_string (cadr arg))
           (editor_sym (string->symbol (string-append "mw_toggle_" base ".options")))
           (variable_name (string-append "mw_toggle_" base "_scope"))
           (variable_sym (string->symbol variable_name))
           (title_sym_name (string-append "mw_toggle_" base ".name"))
          )

        (ui-string variable_name "Toggle Type")
        (ui-string title_sym_name title_string)

        (ui-editor editor_sym
            (list 'title (string->symbol title_sym_name))
            (list 'symbols variable_sym)
            
            (ui-radio-widget variable_name
                (ui-choice "display.all"     'MO_ALL_WIND)
                (ui-choice "display.current" 'MO_CUR_WIND)
            )
        )
    )
) '(
    ("pivots"               "Toggle Pivots")
    ("grid"                 "Toggle Grid")
    ("guidelines"           "Toggle Guidelines")
    ("locators"             "Toggle Locators")
    ("construction_objects" "Toggle Construction Objects")
    ("canvases"             "Toggle Canvas Planes")
    ("lights"               "Toggle Lights")
    ("textures"             "Toggle Textures")
    ("cameras"              "Toggle Cameras")
    ("image_planes"         "Toggle Image Planes")
    ("clouds"               "Toggle Clouds")
    ("nonproportional"      "Toggle Non Proportional")
)   )


(ui-string "mw_toggle_model_scope" "Toggle Type")
(ui-string "mw_toggle_model.name" "Toggle Model")
(ui-string "mw_toggle_model_wireframe_only" "Wireframe only")

(ui-editor "mw_toggle_model.options"
           (list 'title 'mw_toggle_model.name)
           (list 'symbols 
                 'mw_toggle_model_scope
                 'mw_toggle_model_wireframe_only)

           (ui-radio-widget "mw_toggle_model_scope"
                            (ui-choice "display.all"     'MO_ALL_WIND)
                            (ui-choice "display.current" 'MO_CUR_WIND))

           (ui-tick-widget "mw_toggle_model_wireframe_only"))

                 
