;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
;  this code,  you  are  agreeing  to the terms and conditions of the
;  License  Agreement  included  in  the documentation for this code.
;  AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
;  CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
;  IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
;  DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
;  DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
; 
;  Use, duplication,  or disclosure by the U.S. Government is subject
;  to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
;  Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
;  (Rights  in Technical Data and Computer Software),  as applicable.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; Window Display Options

(ui-string "window_display_name"        "Show")

(ui-string "display.on"                 "On")
(ui-string "display.off"                "Off")
(ui-string "display.toggle"             "Toggle")
(ui-string "display.ignore"             "Ignore")

(ui-string "display.all"                "All")
(ui-string "display.current"            "Current")


(ui-string "mw_display_scope"           "Windows")
(ui-string "mw_display_model"           "Model")
(ui-string "mw_display_pivots"          "Pivots")
(ui-string "mw_display_grid"            "Grid")
(ui-string "mw_display_guidelines"      "Guidelines")
(ui-string "mw_display_locators"        "Locators")
(ui-string "mw_display_construction"    "Construction Objects")
(ui-string "mw_display_canvases"        "Canvas Planes")
(ui-string "mw_display_lights"          "Lights")
(ui-string "mw_display_textures"        "Textures")
(ui-string "mw_display_cameras"         "Cameras")
(ui-string "mw_display_image_planes"    "Image Planes")
(ui-string "mw_display_clouds"          "Clouds")

(ui-editor "window_display_options"

    (list 'width 200)

    (list 'title 'window_display_name)

    (list 'symbols  'mw_display_scope
                    'mw_display_model
                    'mw_display_controls
                    'mw_display_pivots
                    'mw_display_grid
                    'mw_display_guidelines
                    'mw_display_locators
                    'mw_display_construction
                    'mw_display_canvases
                    'mw_display_lights
                    'mw_display_textures
                    'mw_display_cameras
                    'mw_display_image_planes
                    'mw_display_clouds
    )

    (list 'buttons 'Reset 'Save 'Exit 'Go)

    (ui-radio-widget "mw_display_scope"
        (ui-choice "display.all"     'MO_ALL_WIND)
        (ui-choice "display.current" 'MO_CUR_WIND)
    )

    (ui-separator-widget)

    (ui-popup-widget "mw_display_model"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-popup-widget "mw_display_pivots"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-blank-widget)

    (ui-popup-widget "mw_display_grid"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-popup-widget "mw_display_guidelines"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-blank-widget)

    (ui-popup-widget "mw_display_locators"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-popup-widget "mw_display_construction"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-popup-widget "mw_display_canvases"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-blank-widget)

    (ui-popup-widget "mw_display_lights"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-popup-widget "mw_display_cameras"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-popup-widget "mw_display_textures"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-popup-widget "mw_display_image_planes"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )

    (ui-blank-widget)

    (ui-popup-widget "mw_display_clouds"
        (ui-choice "display.on"     'MW_DISPLAY_ON)
        (ui-choice "display.off"    'MW_DISPLAY_OFF)
        (ui-choice "display.toggle" 'MW_DISPLAY_TOGGLE)
        (ui-choice "display.ignore" 'MW_DISPLAY_IGNORE)
    )
)
