;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; VRED Output Options
;;;

(ui-string "vredout.name"                     "Send To VRED Options")

(ui-string "mo_vredout_geometry"	   	      "Geometry Output")
(ui-string "mo_vredout_keep_nurbs"	          "Keep Surface Data")
(ui-string "mo_vredout_chord_deviation"	      "Chord Deviation")
(ui-string "mo_vredout_normal_tolerance"	  "Normal Tolerance")
(ui-string "mo_vredout_max_chord_length"	  "Max Chord Length")
(ui-string "mo_vredout_enable_stitching"	  "Enable Stitching")
(ui-string "mo_vredout_stitching_tolerance"	  "Stitching Tolerance")
(ui-string "mo_vredout_merge_geometries"	  "Merge Geometries")

(ui-string "vredout.geometry.all"           "All")
(ui-string "vredout.geometry.selected"      "Selected")

(ui-string "mo_vredout_want_new_scene"      "Open New Scene")

(ui-editor "vredout.options"                
	
	(list 'title 'vredout.name)

	(ui-radio-widget "mo_vredout_geometry"    
		(ui-choice "vredout.geometry.all"       'MO_SAVE_ALL_AS)
		(ui-choice "vredout.geometry.selected"  'MO_SAVE_ACTIVE_AS)
	)

	(ui-tick-widget "mo_vredout_want_new_scene" )

	(ui-blank-widget)
	(ui-blank-widget)

	( ui-group-widget
        ( list 'title "VRED Base CAD Options:" )
        ( list "nohilight" )
    )

	(ui-tick-widget "mo_vredout_keep_nurbs" )

	(ui-tick-widget "mo_vredout_merge_geometries" )

	(ui-double-widget "mo_vredout_chord_deviation"
	   (list 'precision "%f6.4")
	   (list 'slider_range 0.001 1.0)
    )

	(ui-double-widget "mo_vredout_normal_tolerance"
	   (list 'precision "%f6.3")
	   (list 'slider_range 1 100)
    )

    (ui-double-widget "mo_vredout_max_chord_length"
	   (list 'precision "%f6.3")
	   (list 'slider_range 10 90)
    )
	
	(ui-tick-widget "mo_vredout_enable_stitching" 
        (list 'rebuild #t)
	)
	
	(ui-double-widget "mo_vredout_stitching_tolerance"
	   (list 'enabled (ui-eq "mo_vredout_enable_stitching" 1))
	   (list 'precision "%f6.3")
	   (list 'slider_range 0.01 1.0)
    )

    (ui-blank-widget)
	(ui-blank-widget)

	(list 'buttons 'Reset 'Save 'Exit 'Go)
)

