;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; (C) Copyright 2008 by Autodesk, Inc. All Rights Reserved. By using
; this code,  you  are  agreeing  to the terms and conditions of the
; License  Agreement  included  in  the documentation for this code.
; AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
; CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
; IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
; DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
; DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
;
; Use, duplication,  or disclosure by the U.S. Government is subject
; to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
; Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
; (Rights  in Technical Data and Computer Software),  as applicable.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(ui-string "mp_visualstateopt_str"            "Visual State")
(ui-string "mp_visualstateopt_attr_str"       "V state")
(ui-symbol "mo_visualstate_name" "FileState")

;; Visual States Options
(ui-function "mp_display_visualstate_options"         
;	(list 'select        		'mp_display 'MP_TOGGLESHADEOPTIONS)
	(list 'command				"VisualState")
	(list 'label_string        	'mp_visualstateopt_str)
	(list 'attribute_string   	'mp_visualstateopt_attr_str)
    (list 'option_function      "VisualStateOptions")
	(list 'symbols
          'mo_visualstate_name
		  'mo_tglshade_use_fileSyms
		  'mo_tgl_shade_options
		  'mo_shade_geom_all
		  'mo_shade_preset
		  'mo_shade_force_shader

		  'mo_tglshade_tess_flavor
		  'mo_tglshade_tess_preset
		  'ir_tglshade_tol
		  'mo_tglshade_tess_limit_edge_length
		  'mo_tglshade_tess_max_edge_length
		  'mo_tglshade_display_tesselation

		  'mo_tglshade_texture_res
          'mo_tglshade_clearcoat
          'mo_tglshade_show_background
          'mo_tglshade_reflect_background

		  'mo_tglshade_enable_gp
		  'mo_tglshade_enable_lt

		  'mo_shade_self_shadows
          'mo_tglshade_lighting
		  'mo_tglshade_shaderglow
		  'mo_tglshade_shaderglow_quality

		  'mo_tglshade_optimizeshaderglow
		  'mo_tglshade_optimizegroundplanereflection
		  'mo_use_optimize_selfshadows_on_tumble

		  'mo_shade_auto_update
	)
)

(ui-shelf-entry "DiagShadeVS1" "VisualState" 
    (ui-new-symbol "mo_visualstate_name" "DiagShadeVS1")
	( list 'label "Shade" )
 )

(ui-shelf-entry "DiagShadeVS2" "VisualState" 
    (ui-new-symbol "mo_visualstate_name" "DiagShadeVS2")
	( list 'label "Shade" )
 )

(ui-shelf-entry "DiagShadeVS3" "VisualState" 
    (ui-new-symbol "mo_visualstate_name" "DiagShadeVS3")
	( list 'label "Shade" )
 )

(ui-shelf-entry "FileState" "VisualState" 
    (ui-new-symbol "mo_visualstate_name" "FileState")
	( list 'label "Shade" )
)

(ui-shelf-entry "DesignDiagShadeVS1" "VisualState" 
    (ui-new-symbol "mo_visualstate_name" "DesignDiagShadeVS1")
	( list 'label "Shade" )
 )

(ui-shelf-entry "DesignDiagShadeVS2" "VisualState" 
    (ui-new-symbol "mo_visualstate_name" "DesignDiagShadeVS2")
	( list 'label "Shade" )
 )

(ui-shelf-entry "DesignDiagShadeVS3" "VisualState" 
    (ui-new-symbol "mo_visualstate_name" "DesignDiagShadeVS3")
	( list 'label "Shade" )
 )

(ui-shelf-entry "DesignFileState" "VisualState" 
    (ui-new-symbol "mo_visualstate_name" "DesignFileState")
	( list 'label "Shade" )
 )

; hardware shade state used by the rapid prototyping tool
(ui-shelf-entry "RapidProtoDisplayColor" "TglShade" 
	(ui-new-symbol "mo_tglshade_use_fileSyms" 0)
	(ui-new-symbol "mo_tgl_shade_options" 5)
	(ui-new-symbol "mo_shade_geom_all" 0)
	(ui-new-symbol "mo_tglshade_show_background" 0)
	(ui-new-symbol "mo_tglshade_reflect_background" 0)
	(ui-new-symbol "mo_tglshade_enable_gp" 0)
	(ui-new-symbol "mo_tglshade_enable_lt" 0)
	(ui-new-symbol "mo_shade_self_shadows" 0)
	(ui-new-symbol "mo_tglshade_lighting" 46)
	(ui-new-symbol "mo_tglshade_shaderglow" 0)
	(ui-new-symbol "mo_tglshade_optimizeshaderglow" 0)
	(ui-new-symbol "mo_tglshade_optimizegroundplanereflection" 0)
	(ui-new-symbol "mo_use_optimize_selfshadows_on_tumble" 0)

	( list 'label "Shade" )
 )




