;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Viewing Options
;;;

(ui-string "twist.name"                 "Twist Options")
(ui-string "yaw.name"                   "Yaw/Pitch Options")
(ui-string "azim.name"                  "Azimuth/Elevation Options")
(ui-string "zoom.name"                  "Zoom Options")
(ui-string "mo_eyex"                    "Eye")
(ui-string "mo_viewx"                   "View")
(ui-string "mo_upx"                     "Up")
(ui-string "mo_zoom"                    "Zoom")

; The option boxes for Twist Azim/Inc and Yaw/Pitch are all the same.
; To reduce the amount of repetition we define an anonamous lambda
; function for one of them and map the three three argument pairs to
; produce three similar option boxes with different names and titles
; (car arg) represents the name and (cadr arg) the title.

(map (lambda (arg)
	(ui-editor (car arg)
		(list 'title (cadr arg))

; Don't include symbols that are initialized by InitViewsOptions
; Otherwise, they get overwritten by the local to global copy, which is
; done following the bounceback to the current continuous function,
; after the InitViewsOptions function is called.
; The symbols initialized by InitViewsOptions are: 
; 'mo_eyex			'mo_eyey		'mo_eyez
; 'mo_viewx			'mo_viewy		'mo_viewz
; 'mo_upx			'mo_upy			'mo_upz
; 'mo_zoom

		(list 'buttons 'Reset 'Save 'Exit 'Go)

		;; 	InitViewsOptions will stuff the camera values of the current win
		;;	into the option box

		(list 'init_option_function "InitViewsOptions")
		
		(list 'reset_option_function "ResetViewsOptions")

		(list 'go_option_function   "GoViewsOptions")

		(ui-wdltriple-linear-widget "mo_eyex" 'mo_eyey 	'mo_eyez
			(list 'precision "%f8.4")
		)

		(ui-wdltriple-linear-widget "mo_viewx" 'mo_viewy	'mo_viewz
			(list 'precision "%f8.4")
		)

		(ui-wdltriple-linear-widget "mo_upx" 'mo_upy		'mo_upz
			(list 'precision "%f8.4")
		)
		(ui-double-widget "mo_zoom"     
			(list 'range 0.0034 179.0)
			(list 'precision "%f8.4")
		)
	)
) '(
	(twist.options twist.name)
	(yaw.options yaw.name)
	(azim.options azim.name)
	(zoom.options zoom.name)
))
