;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Views Menu
;;;

(ui-string "mp_reset_view_str"          "Reset View")
(ui-string "mp_reset_view_attr_str"     "reset")
(ui-string "mp_previous_str"            "Previous View")
(ui-string "mp_previous_attr_str"       "prev")
(ui-string "mp_viewer_previous_str"            "previous view")
(ui-string "mp_viewer_previous_attr_str"       "previous")
(ui-string "mp_nextview_str"            "next view")
(ui-string "mp_nextview_attr_str"       "next")
(ui-string "mp_new_camera_str"          "New Camera")
(ui-string "mp_new_camera_attr_str"     "nwcam")
(ui-string "mp_twist_str"               "twist")
(ui-string "mp_twist_attr_str"          "twist")
(ui-string "mp_elevation_str"           "Azimuth/Elevation")
(ui-string "mp_elevation_attr_str"      "az/elv")
(ui-string "mp_pitch_str"               "Yaw/Pitch")
(ui-string "mp_pitch_attr_str"          "yw/pch")
(ui-string "mp_look_str"                "Look At")
(ui-string "mp_look_attr_str"           "lookat")
(ui-string "mp_zoom_str"                "zoom")
(ui-string "mp_zoom_attr_str"           "zoom")
(ui-string "mp_dolly_str"               "dolly")
(ui-string "mp_dolly_attr_str"          "dolly")
(ui-string "mp_track_str"               "track")
(ui-string "mp_track_attr_str"          "track")
(ui-string "mp_tumble_str"              "tumble")
(ui-string "mp_tumble_attr_str"         "tumble")
(ui-string "mp_multiview_str"           "Track/Dolly/Tumble")
(ui-string "mp_multiview_attr_str"      "views")
(ui-string "mp_lookaround_str"          "Look Around")
(ui-string "mp_lookaround_attr_str"     "lookarnd")
(ui-string "mp_tglens_str"           	"Toggle Perspective")
(ui-string "mp_tglens_attr_str"      	"tg prsp")
(ui-string "mp_one2one_calibrate"		"calibrate 1:1")
(ui-string "mp_one2one_calibrate_attr_str"    "cal 1:1")
(ui-string "mp_one2one_toggle"			"toggle 1:1")
(ui-string "mp_one2one_toggle_attr_str"	"tg 1:1")
(ui-string "mp_set_nonp_str"            "Set Non Proportional View")
(ui-string "mp_set_nonp_attr_str"       "set np")
(ui-string "mp_view_flip_str"           "View Flip")  
(ui-string "mp_view_flip_attr_str"      "vwflp")
(ui-string "mp_view_both_str"           "View Both")  
(ui-string "mp_view_both_attr_str"      "vwbth")


(ui-function "mp_one2one_calibrate"
	(list 'command				"One2One")
	(list 'label_string			'mp_one2one_calibrate)
	(list 'attribute_string   	'mp_one2one_calibrate_attr_str)
	(list 'option_function		"One2One")
	(list 'symbols
			'mo_one2one_length
			'mo_one2one_userdefined
			'mo_one2one_displayed
			'mo_one2one_scale
	)
)

(ui-function "mp_one2one_toggle"
	(list 'command				"TglOne2One")
	(list 'label_string      	'mp_one2one_toggle)
	(list 'attribute_string   	'mp_one2one_toggle_attr_str)
	;(list 'tick                 (ui-eval "awWindowsUIIsOne2One"))
)

(ui-function "mp_tgl_lens_style"          
    (list 'active (ui-eq "mo_current_win" 'MO_PERSP ))
	(list 'command				"TogglePerspective")
	(list 'label_string        	'mp_tglens_str)
	(list 'attribute_string   	'mp_tglens_attr_str)
)

(ui-function "mp_views_reset"           
	(list 'select        		'mp_views 'MP_RESET)
	(list 'command				"ResetView" )
	(list 'label_string        	'mp_reset_view_str)
	(list 'attribute_string   	'mp_reset_view_attr_str)
)

(ui-function "mp_views_previous"        
	(list 'select        		'mp_views 'MP_PREVIOUS)
	(list 'command				"Previous")
	(list 'label_string        	'mp_previous_str)
	(list 'attribute_string   	'mp_previous_attr_str)
)

(ui-function "mp_viewer_views_previous"        
	(list 'select        		'mp_views 'MP_PREVIOUS)
	(list 'command				"ViewPrevious")
	(list 'label_string        	'mp_viewer_previous_str)
	(list 'attribute_string   	'mp_viewer_previous_attr_str)
)

(ui-function "mp_views_next"        
	(list 'select        		'mp_views 'MP_NEXTVIEW)
	(list 'command				"NextView")
	(list 'label_string        	'mp_nextview_str)
	(list 'attribute_string   	'mp_nextview_attr_str)
)

(ui-function "mp_views_camera"          
	(list 'select        		'mp_views 'MP_NEWCAMERA)
	(list 'command				"NewCamera")
	(list 'label_string        	'mp_new_camera_str)
	(list 'attribute_string   	'mp_new_camera_attr_str)
)

;; ---------------------
(ui-string "mp_reset_camera_str" "Reset")
(ui-string "mp_reset_camera_attr_str" "Reset")
(ui-string "mp_lock_camera_str" "Lock")
(ui-string "mp_lock_camera_attr_str" "Lock")
(ui-string "mp_unlock_camera_str" "Unlock")
(ui-string "mp_unlock_camera_attr_str" "Unlock")
(ui-string "mp_pick_camera_str" "Pick")
(ui-string "mp_pick_camera_attr_str" "Pick")
(ui-string "mp_persp_camera_str" "Perspective")
(ui-string "mp_persp_camera_attr_str" "Persp")
(ui-string "mp_ortho_camera_str" "Orthographic")
(ui-string "mp_ortho_camera_attr_str" "Ortho")
(ui-string "mp_views_nextbookmark_str" "Next Variant")
(ui-string "mp_views_nextbookmark_attr_str" "Next")
(ui-string "mp_views_prevbookmark_str" "Prev Variant")
(ui-string "mp_views_prevbookmark_attr_str" "Prev")
(ui-string "mp_views_cyclebookmark_str" "Cycle Variant")
(ui-string "mp_views_cyclebookmark_attr_str" "Cycle")
(ui-string "mp_views_publishbookmark_str" "Publish Variant")
(ui-string "mp_views_publishbookmark_attr_str" "Publish")
(ui-string "mp_views_setbookmark_str" "New Variant")
(ui-string "mp_views_setbookmark_attr_str" "New")
(ui-string "mp_views_deletebookmark_str" "Delete Variant")
(ui-string "mp_views_deletebookmark_attr_str" "Delete")
(ui-string "mp_views_editbookmark_str" "Edit Variant...")
(ui-string "mp_views_editbookmark_attr_str" "BkMark")
(ui-string "mp_views_toggleCameraBookmark_str" "Toggle Camera Only Mode")
(ui-string "mp_views_toggleCameraBookmark_attr_str" "Camera")

(ui-string "mp_views_tglstereo_str" "Toggle Stereo")
(ui-string "mp_views_tglstereo_attr_str" "stereo")


(ui-function "mp_views_reset_camera"          
	(list 'select        		'mp_views 'MP_RESETCAMERA)
	(list 'command				"ResetCamera")
	(list 'label_string        	'mp_reset_camera_str)
	(list 'attribute_string   	'mp_reset_camera_attr_str)
)

(ui-function "mp_views_tglStereo"          
	(list 'select        		'mp_views 'MP_TGLSTEREO)
	(list 'command				"TglStereo")
	(list 'label_string        	'mp_views_tglstereo_str)
	(list 'attribute_string   	'mp_views_tglstereo_attr_str)
)

(ui-function "mp_views_lock_camera"          
	(list 'select        		'mp_views 'MP_LOCKCAMERA)
	(list 'command				"LockCamera")
	(list 'label_string        	'mp_lock_camera_str)
	(list 'attribute_string   	'mp_lock_camera_attr_str)
	(list 'tick                 (ui-eval "awWindowsUIIsCameraLocked"))
)

(ui-function "mp_views_unlock_camera"          
	(list 'select        		'mp_views 'MP_UNLOCKCAMERA)
	(list 'command				"UnlockCamera")
	(list 'label_string        	'mp_unlock_camera_str)
	(list 'attribute_string   	'mp_unlock_camera_attr_str)
	(list 'tick                 (ui-eval "awWindowsUIIsCameraLocked"))
)

(ui-function "mp_views_pick_camera"          
	(list 'select        		'mp_views 'MP_PICKCAMERA)
	(list 'command				"PickCamera")
	(list 'label_string        	'mp_pick_camera_str)
	(list 'attribute_string   	'mp_pick_camera_attr_str)
	(list 'active				(ui-eval "awWindowsUIOrthoWindowDisable"))
)

(ui-function "mp_views_persp_camera"          
	(list 'select        		'mp_views 'MP_PERSPCAMERA)
	(list 'command				"PerspectiveCamera")
	(list 'label_string        	'mp_persp_camera_str)
	(list 'attribute_string   	'mp_persp_camera_attr_str)
	(list 'enabled				(ui-eval "awWindowsUIPerspCamera"))
	(list 'active				(ui-eval "awWindowsUIOrthoWindowDisable"))
	(list 'tick					(ui-eval "awWindowsUIPerspCamera"))
)

(ui-function "mp_views_ortho_camera"          
	(list 'select        		'mp_views 'MP_ORTHOCAMERA)
	(list 'command				"OrthographicCamera")
	(list 'label_string        	'mp_ortho_camera_str)
	(list 'attribute_string   	'mp_ortho_camera_attr_str)
	(list 'tick					(ui-not (ui-eval "awWindowsUIPerspCamera")))
)

(ui-function "mp_views_delete_bookmark"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"DeleteBookmark")
	(list 'label_string        	'mp_views_deletebookmark_str)
	(list 'attribute_string   	'mp_views_deletebookmark_attr_str)
)

(ui-function "mp_views_next_bookmark"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"NextBookmark")
	(list 'label_string        	'mp_views_nextbookmark_str)
	(list 'attribute_string   	'mp_views_nextbookmark_attr_str)
)

(ui-function "mp_views_prev_bookmark"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"PrevBookmark")
	(list 'label_string        	'mp_views_prevbookmark_str)
	(list 'attribute_string   	'mp_views_prevbookmark_attr_str)
)

(ui-function "mp_views_toggleCameraBookmark"
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"ToggleCameraBookmark")
	(list 'label_string        	'mp_views_toggleCameraBookmark_str)
	(list 'attribute_string   	'mp_views_toggleCameraBookmark_attr_str)
	(list 'tick                 (ui-eval "awWindowsUI_isBookmarkUseOnlyCamera"))
)

(ui-function "mp_views_cycle_bookmark"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"CycleBookmark")
	(list 'label_string        	'mp_views_cyclebookmark_str)
	(list 'attribute_string   	'mp_views_cyclebookmark_attr_str)
	(list 'option_editor       	"Modeling/mo_viewBookmark_cycle.o.scm"
								'cyclebookmark.options)
)

(ui-function "mp_views_publish_bookmark"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"PublishBookmark")
	(list 'label_string        	'mp_views_publishbookmark_str)
	(list 'attribute_string   	'mp_views_publishbookmark_attr_str)
	(list 'option_editor       	"Modeling/mo_viewBookmark_publish.o.scm"
								'publishbookmark.options)
)

(ui-function "mp_views_next_bookmark2"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"NextBookmark")
	(list 'label_string        	'mp_views_nextbookmark_str)
	(list 'attribute_string   	'mp_views_nextbookmark_attr_str)
)

(ui-function "mp_views_prev_bookmark2"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"PrevBookmark")
	(list 'label_string        	'mp_views_prevbookmark_str)
	(list 'attribute_string   	'mp_views_prevbookmark_attr_str)
)

(ui-function "mp_views_cycle_bookmark2"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"CycleBookmark")
	(list 'label_string        	'mp_views_cyclebookmark_str)
	(list 'attribute_string   	'mp_views_cyclebookmark_attr_str)
	(list 'option_editor       	"Modeling/mo_viewBookmark_cycle.o.scm"
								'cyclebookmark.options)
)

(ui-function "mp_views_next_bookmark3"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"NextBookmark")
	(list 'label_string        	'mp_views_nextbookmark_str)
	(list 'attribute_string   	'mp_views_nextbookmark_attr_str)
)

(ui-function "mp_views_prev_bookmark3"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"PrevBookmark")
	(list 'label_string        	'mp_views_prevbookmark_str)
	(list 'attribute_string   	'mp_views_prevbookmark_attr_str)
)

(ui-function "mp_views_set_bookmark"          
	(list 'select        		'mp_views 'MP_SETBOOKMARK)
	(list 'command				"SetBookmark")
	(list 'label_string        	'mp_views_setbookmark_str)
	(list 'attribute_string   	'mp_views_setbookmark_attr_str)
	(list 'option_editor       	"Modeling/mo_viewBookmark_new.o.scm"
								'newbookmark.options)
)
(ui-function "mp_views_edit_bookmark"          
	(list 'select        		'mp_views 'MP_EDITBOOKMARK)
	(list 'command				"EditBookmark")
	(list 'label_string        	'mp_views_editbookmark_str)
	(list 'attribute_string   	'mp_views_editbookmark_attr_str)
)

(ui-function "mp_views_edit_bookmark2"          
	(list 'select        		'mp_views 'MP_EDITBOOKMARK)
	(list 'command				"EditBookmark")
	(list 'label_string        	'mp_views_editbookmark_str)
	(list 'attribute_string   	'mp_views_editbookmark_attr_str)
)

;; --------------------

(ui-function "mp_views_twist"           
	(list 'select        		'mp_views 'MP_TWIST)
	(list 'command				"Twist")
	(list 'label_string        	'mp_twist_str)
	(list 'attribute_string   	'mp_twist_attr_str)
	(list 'option_editor       	"Modeling/mo_views_options.o.scm"
								'twist.options)
)

(ui-function "mp_views_elevation"       
	(list 'select        		'mp_views 'MP_AZIMINC)
	(list 'command				"AzimInc")
	(list 'label_string        	'mp_elevation_str)
	(list 'attribute_string   	'mp_elevation_attr_str)
	(list 'option_editor       	"Modeling/mo_views_options.o.scm"
								'azim.options)
)

(ui-function "mp_views_pitch"           
	(list 'select        		'mp_views 'MP_YAWPITCH)
	(list 'command				"YawPitch")
	(list 'label_string        	'mp_pitch_str)
	(list 'attribute_string   	'mp_pitch_attr_str)
	(list 'option_editor       	"Modeling/mo_views_options.o.scm"
								'yaw.options)
)

(ui-function "mp_views_look"            
	(list 'select        		'mp_views 'MP_LOOKAT)
	(list 'command				"LookAt")
	(list 'label_string        	'mp_look_str)
	(list 'attribute_string   	'mp_look_attr_str)
	(list 'option_editor       	"Modeling/mo_lookat_options.o.scm"
								'lookat.options)
)

(ui-function "mp_views_lookaround"          
	(list 'select        		'mp_views 'MP_LOOKAROUND)
	(list 'command				"LookAround")
	(list 'label_string        	'mp_lookaround_str)
	(list 'attribute_string   	'mp_lookaround_attr_str)
)

(ui-function "mp_views_zoom"            
	(list 'select        		'mp_views 'MP_FOV)
	(list 'command				"Zoom")
	(list 'label_string        	'mp_zoom_str)
	(list 'attribute_string   	'mp_zoom_attr_str)
	(list 'option_editor       	"Modeling/mo_views_options.o.scm"
								'zoom.options)
)

(ui-function "mp_views_dolly"           
	(list 'select        		'mp_views 'MP_IN)
    (list 'command              "Dolly")
	(list 'label_string        	'mp_dolly_str)
	(list 'attribute_string   	'mp_dolly_attr_str)
	(list 'option_editor       	"Modeling/mo_dolly_options.o.scm"
								'dolly.options)
)

(ui-function "mp_views_view_flip"           
	(list 'command				"ViewFlip")
	(list 'label_string        	'mp_view_flip_str)
	(list 'attribute_string   	'mp_view_flip_attr_str)
    (list 'option_editor       	"Modeling/mo_view_flip_options.o.scm"
								'flip.options)
)

(ui-function "mp_views_view_both"           
	(list 'command				"ViewBoth")
	(list 'label_string        	'mp_view_both_str)
	(list 'attribute_string   	'mp_view_both_attr_str)
    (list 'option_editor       	"Modeling/mo_view_flip_options.o.scm"
								'flip.options)
)

(ui-function "mp_views_set_nonproportional"           
	(list 'command				"SetNonProportional")
	(list 'label_string        	'mp_set_nonp_str)
	(list 'attribute_string   	'mp_set_nonp_attr_str)
	(list 'symbols 
		  'mo_scaling
		  'mo_dolly.auto.zoom
    )
)

(ui-function-symbol-list-reset "SetNonProportional"
    (list 'mo_scaling           'MO_NON_PROPORTIONAL)
    (list 'mo_dolly.auto.zoom   0)
)

(ui-function "mp_views_track"           
	(list 'select        		'mp_views 'MP_PAN)
	(list 'command				"Track")
	(list 'label_string        	'mp_track_str)
	(list 'attribute_string   	'mp_track_attr_str)
	(list 'option_editor       	"Modeling/mo_track_options.o.scm"
								'track.options)
)


(ui-function "mp_views_tumble"          
	(list 'select        		'mp_views 'MP_TUMBLE)
	(list 'command				"Tumble")
	(list 'label_string        	'mp_tumble_str)
	(list 'attribute_string   	'mp_tumble_attr_str)
	(list 'option_editor       	"Modeling/mo_tumble_options.o.scm"
								'tumble.options)
)

(ui-function "mp_views_multiview"          
	(list 'select        		'mp_views 'MP_PAN)
	(list 'command				"MultiView")
	(list 'label_string        	'mp_multiview_str)
	(list 'attribute_string   	'mp_multiview_attr_str)
)


;;------------Alias Viewer functions

( ui-string 	"mp_view_reset" 		"Reset" )
( ui-string 	"mp_view_reset_attr" 	"Reset" )
( ui-function 	"mp_view_reset"          
	(list 'select        		'mp_views 'MP_RESETCAMERA )
	(list 'command				"ViewReset" )
	(list 'label_string        	'mp_view_reset )
	(list 'attribute_string   	'mp_view_reset_attr )
)

( ui-string		"mp_goto_surface" 			"Home" )
( ui-string		"mp_goto_surface_attr" 		"Home" )
( ui-function 	"mp_view_goto_surface"            
	(list 'select        		'mp_views 'MP_LOOKAT )
	(list 'command				"GoToSurface" )
	(list 'label_string        	'mp_goto_surface )
	(list 'attribute_string   	'mp_goto_surface_attr )
)

( ui-string		"mp_view_dolly_str" 			"Zoom" )
( ui-string		"mp_view_dolly_attr_str" 		"Zoom" )
( ui-function	"mp_view_dolly"           
	(list 'select        		'mp_views 'MP_IN)
	(list 'command				"ViewDolly")
	(list 'label_string        	'mp_view_dolly_str)
	(list 'attribute_string   	'mp_view_dolly_attr_str)
)
( ui-function	"mp_view_dolly2"           
	(list 'select        		'mp_views 'MP_IN)
	(list 'command				"ViewDolly")
	(list 'label_string        	'mp_view_dolly_str)
	(list 'attribute_string   	'mp_view_dolly_attr_str)
)
( ui-string    	"mp_view_track_str" 			"Pan" )
( ui-string   	"mp_view_track_attr_str" 		"Pan" )
( ui-function	"mp_view_track"           
	(list 'select        		'mp_views 'MP_PAN)
	(list 'command				"ViewTrack")
	(list 'label_string        	'mp_view_track_str)
	(list 'attribute_string   	'mp_view_track_attr_str)
)
( ui-function	"mp_view_track2"           
	(list 'select        		'mp_views 'MP_PAN)
	(list 'command				"ViewTrack")
	(list 'label_string        	'mp_view_track_str)
	(list 'attribute_string   	'mp_view_track_attr_str)
)
( ui-string    	"mp_view_tumble" 			"Rotate" )
( ui-string   	"mp_view_tumble_attr" 		"Rotate" )

( ui-function 	"mp_view_tumble"          
	(list 'select        		'mp_views 'MP_TUMBLE )
	(list 'command				"ViewTumble" )
	(list 'label_string        	'mp_view_tumble )
	(list 'attribute_string   	'mp_view_tumble_attr )
)
( ui-function 	"mp_view_tumble2"          
	(list 'select        		'mp_views 'MP_TUMBLE )
	(list 'command				"ViewTumble" )
	(list 'label_string        	'mp_view_tumble )
	(list 'attribute_string   	'mp_view_tumble_attr )
)
( ui-string    	"mp_view_turntable" 		"Turntable" )
( ui-string   	"mp_view_turntable_attr"	"Turn" )
( ui-function 	"mp_view_turntable"          
	(list 'select        		'mp_views 'MP_TURNTABLE )
	(list 'command				"ViewTurntable" )
	(list 'label_string        	'mp_view_turntable )
	(list 'attribute_string   	'mp_view_turntable_attr )
)

( ui-string    	"mp_view_moveCompareWindows_str" 		"MoveImages" )
( ui-string   	"mp_view_moveCompareWindows_str_attr"	"Images" )
( ui-function 	"mp_view_moveCompareWindows"          
	(list 'select        		'mp_views 'MP_MOVE )
	(list 'command				"MoveCompareWindows" )
	(list 'label_string        	'mp_view_moveCompareWindows_str )
	(list 'attribute_string   	'mp_view_moveCompareWindows_str_attr )
)

