;-
; ==================================================================
; (C) Copyright 2008 by Autodesk, Inc. All Rights Reserved. By using
; this code,  you  are  agreeing  to the terms and conditions of the
; License  Agreement  included  in  the documentation for this code.
; AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
; CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
; IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
; DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
; DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
;
; Use, duplication,  or disclosure by the U.S. Government is subject
; to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
; Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
; (Rights  in Technical Data and Computer Software),  as applicable.
; ==================================================================
;+

;;; ViewCube Options Box

(ui-string "viewcube.name"                    "ViewCube Options")
(ui-string "mo_viewcube_position"             "On-screen position")
(ui-string "viewcube.position.top.right"      "Top Right")
(ui-string "viewcube.position.top.left"       "Top Left")
(ui-string "viewcube.position.bottom.right"   "Bottom Right")
(ui-string "viewcube.position.bottom.left"    "Bottom Left")
(ui-string "viewcube.size.automatic"          "Automatic")
(ui-string "viewcube.size.tiny"               "Tiny")
(ui-string "viewcube.size.small"              "Small")
(ui-string "viewcube.size.normal"             "Normal")
(ui-string "viewcube.size.large"              "Large")

(ui-string "mo_viewcube_size"                 "ViewCube size")
(ui-string "mo_viewcube_opacity"              "Inactive opacity")
(ui-string "mo_viewcube_keepupright"          "Keep scene upright")
(ui-string "mo_viewcube_snap_to_view"         "Snap to closest view")
(ui-string "mo_viewcube_fit_to_view"          "Fit-to-view on view change")

(ui-editor "viewcube.options"

	(list 'title 'viewcube.name)

	(list 'symbols
		"mo_viewcube_position"
		"mo_viewcube_size"
		"mo_viewcube_opacity"
		"mo_viewcube_keepupright"
		"mo_viewcube_snap_to_view"
		"mo_viewcube_fit_to_view"
		"mo_viewcube_use_animation"
		"mo_viewcube_ortho_faces"
		"mo_viewcube_previous_camera"
	)

	(ui-popup-widget "mo_viewcube_position"
		(ui-choice "viewcube.position.top.right" 'MO_VIEWCUBE_TOP_RIGHT)
		(ui-choice "viewcube.position.top.left" 'MO_VIEWCUBE_TOP_LEFT)
		(ui-choice "viewcube.position.bottom.right" 'MO_VIEWCUBE_BOTTOM_RIGHT)
		(ui-choice "viewcube.position.bottom.left" 'MO_VIEWCUBE_BOTTOM_LEFT)
	)

	(ui-popup-widget "mo_viewcube_size"
		(ui-choice "viewcube.size.automatic" 'MO_VIEWCUBE_SIZE_AUTOMATIC)
		(ui-choice "viewcube.size.tiny" 'MO_VIEWCUBE_SIZE_TINY)
		(ui-choice "viewcube.size.small" 'MO_VIEWCUBE_SIZE_SMALL)
		(ui-choice "viewcube.size.normal" 'MO_VIEWCUBE_SIZE_NORMAL)
		(ui-choice "viewcube.size.large" 'MO_VIEWCUBE_SIZE_LARGE)
	)

	(ui-integer-widget "mo_viewcube_opacity"
		(list 'range 0 100)
		(list 'display-range 0 100)
	)

	(ui-tick-widget "mo_viewcube_keepupright" )
	(ui-tick-widget "mo_viewcube_snap_to_view" )
	;(ui-tick-widget "mo_viewcube_fit_to_view" )

	(list 'buttons 'Reset 'Save 'Exit 'Go)
)
