
;;; Publish Bookmark Options
;;;

(ui-string "publishbookmark.name"                 "Publish Variant Options")

(ui-string "mo_view_bookmark_publish_image_type"         "Image File Type")

(ui-string "publishbookmark.filetype.jpeg"        "jpeg")
(ui-string "publishbookmark.filetype.alias"       "als")
(ui-string "publishbookmark.filetype.tiff"        "tiff")
(ui-string "publishbookmark.filetype.tiff4"       "tiff with alpha")
(ui-string "publishbookmark.filetype.png"         "png")
(ui-string "publishbookmark.filetype.png4"        "png with alpha")
(if (ui-symbol-true	"using_nt_os")
 ( begin
	(ui-string "publishbookmark.filetype.bmp24"       "bmp(24bits)")
	(ui-string "publishbookmark.filetype.bmp"         "bmp(32bits)")
 )	
)	
(ui-string "mo_view_bookmark_publish_all"         "Variant Publish")
(ui-string "publishbookmark.publish.all"          "All")
(ui-string "publishbookmark.publish.selected"     "Selected")
(ui-string "mo_view_bookmark_publish_to"			"Publish To")
(ui-string "publishbookmark.publish.to.local"       "Directory")
(ui-string "publishbookmark.publish.to.sharepoint"  "Sharepoint")
(ui-string "publishbookmark.publish.to.tcc"         "TcC")

(ui-string "mo_savecurrentwindow_limit_size"        "Specify Image Size")
(ui-string "mo_savecurrentwindow_set_aspect"        "Maintain Aspect Ratio")
(ui-string "mo_savecurrentwindow_max_x"             "Horizontal Size")
(ui-string "mo_savecurrentwindow_max_y"             "Vertical Size")
(ui-string "mo_savecurrentwindow_q_factor"          " ")
(ui-string "mo_savecurrentwindow_q_level"           "Quality Level")

(ui-string "publishbookmark.max"					"MAXIMUM")
(ui-string "publishbookmark.high"					"HIGH")
(ui-string "publishbookmark.med"					"MEDIUM")
(ui-string "publishbookmark.low"					"LOW")

(ui-string "mo_view_bookmark_publish_seed"        "Create Session File")

(ui-editor "publishbookmark.options"

    (list 'height 500 )

	(list 'title 'publishbookmark.name)

	(list 'symbols 	'mo_view_bookmark_publish_image_type
                    'mo_savecurrentwindow_limit_size
                    'mo_savecurrentwindow_set_aspect
                    'mo_savecurrentwindow_aspect
                    'mo_view_bookmark_publish_seed
                    'mo_savecurrentwindow_max_x
                    'mo_savecurrentwindow_max_y 
                    'mo_savecurrentwindow_q_factor
                    'mo_savecurrentwindow_q_level 
                    'mo_view_bookmark_publish_to 
                    'mo_view_bookmark_publish_all 
                    )

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_view_bookmark_publish_to"
		(list 'rebuild #t)
    	(list 'enabled (ui-eq "mo_view_bookmark_publish_sp" 'MO_BOOKMARK_PUBLISH_TO_SHAREPOINT) )
		(ui-choice "publishbookmark.publish.to.local"    'MO_BOOKMARK_PUBLISH_TO_LOCAL)
		(ui-choice "publishbookmark.publish.to.sharepoint"		'MO_BOOKMARK_PUBLISH_TO_SHAREPOINT)
	)

	(ui-radio-widget "mo_view_bookmark_publish_to"
		(list 'rebuild #t)
    	(list 'enabled (ui-eq "mo_view_bookmark_publish_sp" 'MO_BOOKMARK_PUBLISH_TO_TCC) )
		(ui-choice "publishbookmark.publish.to.local"    'MO_BOOKMARK_PUBLISH_TO_LOCAL)
		(ui-choice "publishbookmark.publish.to.tcc"		'MO_BOOKMARK_PUBLISH_TO_TCC)
	)

;	(ui-radio-widget "mo_view_bookmark_publish_to"
;		(list 'rebuild #t)
;    	(list 'enabled (ui-eq "mo_view_bookmark_publish_sp" 'MO_BOOKMARK_PUBLISH_TO_LOCAL) )
;		(ui-choice "publishbookmark.publish.to.local"    'MO_BOOKMARK_PUBLISH_TO_LOCAL)
;	)

	(ui-radio-widget "mo_view_bookmark_publish_image_type"
		(list 'rebuild #t)
    	(list 'enabled (ui-eq "mo_view_bookmark_publish_to" 'MO_BOOKMARK_PUBLISH_TO_LOCAL ))
		(ui-choice "publishbookmark.filetype.jpeg"     'MO_FILETYPE_JPEG)
		(ui-choice "publishbookmark.filetype.alias"    'MO_FILETYPE_ALIAS)
		(ui-choice "publishbookmark.filetype.tiff"     'MO_FILETYPE_TIFF)
		(ui-choice "publishbookmark.filetype.tiff4"    'MO_FILETYPE_TIFF4)
		(ui-choice "publishbookmark.filetype.png"      'MO_FILETYPE_PNG)
		(ui-choice "publishbookmark.filetype.png4"     'MO_FILETYPE_PNG4)
		(if (ui-symbol-true	"using_nt_os")
		 ( begin
			(ui-choice "publishbookmark.filetype.bmp24"    'MO_FILETYPE_BMP24)
			(ui-choice "publishbookmark.filetype.bmp"      'MO_FILETYPE_BMP)
		)
	  )		
	)
	(ui-radio-widget "mo_view_bookmark_publish_image_type"
		(list 'rebuild #t)
    	(list 'enabled (ui-ne "mo_view_bookmark_publish_to" 'MO_BOOKMARK_PUBLISH_TO_LOCAL ))
		(ui-choice "publishbookmark.filetype.jpeg"     'MO_FILETYPE_JPEG)
	)

	(ui-radio-widget "mo_view_bookmark_publish_all"
		(list 'rebuild #t)
		(list 'columns 1 )
		(ui-choice "publishbookmark.publish.selected"    'MO_BOOKMARK_PUBLISH_SELECTED)
		(ui-choice "publishbookmark.publish.all"		'MO_BOOKMARK_PUBLISH_ALL)
	)

    (ui-tick-widget			"mo_savecurrentwindow_limit_size"
        (list 'rebuild #t)
    )

    (ui-tick-widget			"mo_savecurrentwindow_set_aspect"
    	(list 'enabled
                (ui-eq "mo_savecurrentwindow_limit_size" #t)
		)
		(list 'assign (ui-eq 'mo_savecurrentwindow_set_aspect #t)
				'mo_savecurrentwindow_aspect
						(ui-eval "awWindowsUIIsCurrentAspectRatio")
		)
		(list 'assign (ui-eq 'mo_savecurrentwindow_set_aspect #t)
				'mo_savecurrentwindow_max_y
						(ui-div 'mo_savecurrentwindow_max_x 'mo_savecurrentwindow_aspect)
		)
    )
    
    (ui-double-widget      "mo_savecurrentwindow_max_x"
		(list 'enabled
                (ui-eq "mo_savecurrentwindow_limit_size" #t)
		)

		(list 'assign (ui-eq 'mo_savecurrentwindow_set_aspect #t)
				'mo_savecurrentwindow_max_y
						(ui-div 'mo_savecurrentwindow_max_x 'mo_savecurrentwindow_aspect)
		)
		(list 'range 8)
		(list 'slider_range 32 4096)
		(list 'precision "%f6.0")
	)

    (ui-double-widget      "mo_savecurrentwindow_max_y"
		(list 'enabled
                (ui-eq "mo_savecurrentwindow_limit_size" #t)
		)

		(list 'assign (ui-eq 'mo_savecurrentwindow_set_aspect #t)
				'mo_savecurrentwindow_max_x
						(ui-mul 'mo_savecurrentwindow_max_y 'mo_savecurrentwindow_aspect)
		)
		(list 'range 8)
		(list 'slider_range 32 4096)
		(list 'precision "%f6.0")
	)
		
   (ui-popup-widget "mo_savecurrentwindow_q_level"
		(list 'rebuild #t)
		(list 'enabled
			(ui-eq "mo_view_bookmark_publish_image_type" 'MO_FILETYPE_JPEG)
		)	        
		(ui-choice "publishbookmark.max"    'MO_Q_MAX
			(list 'assign (ui-eq "mo_savecurrentwindow_q_level" 'MO_Q_MAX)
					'mo_savecurrentwindow_q_factor 100)
		)
		(ui-choice "publishbookmark.high"    'MO_Q_HIGH
			(list 'assign (ui-eq "mo_savecurrentwindow_q_level" 'MO_Q_HIGH)
					'mo_savecurrentwindow_q_factor 90)
		)
		(ui-choice "publishbookmark.med"    'MO_Q_MED 
			(list 'assign (ui-eq "mo_savecurrentwindow_q_level" 'MO_Q_MED)
					'mo_savecurrentwindow_q_factor 75)
		)
		(ui-choice "publishbookmark.low"    'MO_Q_LOW 
			(list 'assign (ui-eq "mo_savecurrentwindow_q_level" 'MO_Q_LOW)
					'mo_savecurrentwindow_q_factor 60)
		)	
	)
	(ui-integer-widget      "mo_savecurrentwindow_q_factor"
		(list 'rebuild #t)
		(list 'enabled
			(ui-eq "mo_view_bookmark_publish_image_type" 'MO_FILETYPE_JPEG)
		)
		(list 'assign (ui-eq 'mo_savecurrentwindow_q_factor 100) 
				'mo_savecurrentwindow_q_level 'MO_Q_MAX)
		(list 'assign (ui-lt 'mo_savecurrentwindow_q_factor 100) 
				'mo_savecurrentwindow_q_level 'MO_Q_HIGH)
		(list 'assign (ui-lt 'mo_savecurrentwindow_q_factor 90) 
				'mo_savecurrentwindow_q_level 'MO_Q_MED)
		(list 'assign (ui-lt 'mo_savecurrentwindow_q_factor 60) 
				'mo_savecurrentwindow_q_level 'MO_Q_LOW)		        
		(list 'range 1 100)
	)

    (ui-tick-widget			"mo_view_bookmark_publish_seed"
		(list 'enabled
                (ui-eq "mo_view_bookmark_publish_to" 'MO_BOOKMARK_PUBLISH_TO_TCC)
		)
    )
	
)
