;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Turnable Options Box
;;;

(ui-string "turntable.name"             "Turntable Options")
(ui-string "mo_trntbl_type"             "Type")
(ui-string "mo_trntbl_rest_pos"         "Restore Position")
(ui-string "mo_trntbl_axis"             "Axis")
(ui-string "mo_trntbl_dir"              "Direction")
(ui-string "mo_trntbl_pivot"            "Rotate About")
(ui-string "mo_trntbl_rate"             "Frames/Rev")
(ui-string "mo_trntbl_file"             "Create SDL File")

(ui-string "turntable.type.camera"      "Rotate Camera")
(ui-string "turntable.type.objects"     "Rotate Objects")
(ui-string "turntable.axis.y"           "Y")
(ui-string "turntable.axis.x"           "X")
(ui-string "turntable.axis.y"           "Y")
(ui-string "turntable.axis.z"           "Z")
(ui-string "turntable.dir.positive"     "Clockwise")
(ui-string "turntable.dir.negative"     "Counterclockwise")
(ui-string "turntable.pivot.origin"     "Origin")
(ui-string "turntable.pivot.average"    "Average")
(ui-string "turntable.pivot.center_bbox"    "Bounding Box Center")

(ui-editor "turntable.options"          
	
	(list 'title 'turntable.name)

	(list 'symbols 	'mo_trntbl_type
                    'mo_trntbl_rest_pos		
                    'mo_trntbl_axis		
                    'mo_trntbl_dir
					'mo_trntbl_pivot	
                    'mo_trntbl_rate
					'mo_trntbl_file
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_trntbl_type"   
        (list 'rebuild #t)
		(list 'columns 2)
		(ui-choice "turntable.type.camera"   'MO_TRNTBL_TYPE_CAMERA)
		(ui-choice "turntable.type.objects"  'MO_TRNTBL_TYPE_OBJECTS)
	)

	(ui-tick-widget "mo_trntbl_rest_pos"
        (list 'enabled (ui-eq "mo_trntbl_type" 'MO_TRNTBL_TYPE_CAMERA))
        )

	(ui-separator-widget)

	(ui-radio-widget "mo_trntbl_axis"   
		(list 'columns 3)
		(ui-choice "turntable.axis.x"   'REVOLVE_X)
		(ui-choice "turntable.axis.y"   'REVOLVE_Y)
		(ui-choice "turntable.axis.z"   'REVOLVE_Z)
	)

	(ui-separator-widget)


	(ui-radio-widget "mo_trntbl_dir"    
		(ui-choice "turntable.dir.positive" 'MO_TRNTBL_POS)
		(ui-choice "turntable.dir.negative" 'MO_TRNTBL_NEG)
	)

	(ui-separator-widget)

	(ui-radio-widget "mo_trntbl_pivot"  
		(ui-choice "turntable.pivot.origin" 'MO_TRNTBL_ORIGIN)
		(ui-choice "turntable.pivot.average" 'MO_TRNTBL_AVG)
		(ui-choice "turntable.pivot.center_bbox" 'MO_TRNTBL_CENTER_OF_BBOX)
	)

	(ui-separator-widget)

	(ui-double-widget "mo_trntbl_rate"  
		(list 'range 'min 1)
		(list 'slider_range 1 360)
		(list 'precision "%f6.2")
	)

	(ui-tick-widget "mo_trntbl_file" )

)
