;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Tumble Options
;;;

(ui-string "tumble.name"                "Viewing Options")
(ui-string "mo_eyex"                    "Eye")
(ui-string "mo_viewx"                   "View")
(ui-string "mo_upx"                     "Up")
(ui-string "mo_zoom"                    "Zoom")
(ui-string "mo_tumble_centre_type"      "Tumble Center")
(ui-string "mo_world_point_x"           "World Point")

(ui-string "tumble.center.view"         "View Center")
(ui-string "tumble.center.world"        "World Point")

(ui-editor "tumble.options"             

	(list 'title 'tumble.name)

; Don't include symbols that are initialized by InitViewsOptions
; Otherwise, they get overwritten by the local to global copy, which is
; done following the bounceback to the current continuous function,
; after the InitViewsOptions function is called.
; The symbols initialized by InitViewsOptions are: 
; 'mo_eyex			'mo_eyey		'mo_eyez
; 'mo_viewx			'mo_viewy		'mo_viewz
; 'mo_upx			'mo_upy			'mo_upz
; 'mo_zoom

	(list 'symbols 	
		  'mo_tumble_centre_type
		  'mo_world_point_x		'mo_world_point_y     'mo_world_point_z
    )

	(list 'buttons 'Reset 'Save 'Exit 'Go)


	(ui-radio-widget "mo_tumble_centre_type" 
		(list "rebuild")
		(ui-choice "tumble.center.view" 'MO_VIEW_CENTRE)
		(ui-choice "tumble.center.world" 'MO_WORLD_POINT)
	)

	(ui-separator-widget)

;;  InitViewsOptions will stuff the camera values of the current win
;;  into the option box

    (list 'init_option_function "InitViewsOptions")

	(list 'reset_option_function "ResetViewsOptions")

    (list 'go_option_function 	"GoViewsOptions")

	(ui-wdltriple-linear-widget "mo_eyex" 'mo_eyey    'mo_eyez
		(list 'precision "%f8.4")
	)

	(ui-wdltriple-linear-widget "mo_viewx" 'mo_viewy   'mo_viewz
		(list 'precision "%f8.4")
	)

	(ui-wdltriple-linear-widget "mo_upx" 'mo_upy     'mo_upz
		(list 'precision "%f8.4")
	)

	(ui-double-widget "mo_zoom"         
		(list 'range 0.0034 179.0)
		(list 'precision "%f8.4")
	)

	(ui-wdltriple-linear-widget 
		'mo_world_point_x 'mo_world_point_y 'mo_world_point_z

		(list 'enabled (ui-eq "mo_tumble_centre_type" 'MO_WORLD_POINT))
		(list 'precision "%f8.4")
	)

)
