;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Tolerance Table
;;;

(ui-string "tolerance.name"             "Construction Settings")
(ui-string "mo_tol_crv_fit"             "Curve Fit Distance")
(ui-string "mo_tol_checkpoints"         "Curve Fit Checkpoints")
(ui-string "mo_tol_continuity_gap"      "Maximum Gap Distance")
(ui-string "mo_tol_continuity_angle"    "Continuity Angle")
(ui-string "mo_tol_curvature"           "Continuity Curvature")
(ui-string "mo_tol_maxsurfspans"        "Max Surf Spans")
(ui-string "mo_tol_trim_crv_fit"        "Trim Curve Fit")
(ui-string "mo_tol_cos_gap"             "End Gap Allowed Between Curves")
(ui-string "mo_tol_vertex"              "Polyset Vertex")
(ui-string "mo_modeling_mode"           "Create surface type")
(ui-string "mo_allow_rationals"         "Create rational geometry")

(ui-string "modeling.mode.spline"       "normal NURBS surface")
(ui-string "modeling.mode.polyset"      "polyset")

; Values below this are pretty meaningless.  Established through
; trial and error.  CWM, Oct '95
;
(define minimum-tolerance 0.00005)

(ui-editor "tolerance.options"          
	
	(list 'title 'tolerance.name)

	(list 'symbols 	'mo_tol_crv_fit				'mo_tol_checkpoints
					'mo_tol_continuity_angle	'mo_tol_curvature
					'mo_tol_maxsurfspans		
					'mo_tol_cos_gap
                    'mo_tol_vertex              'mo_tol_trim_crv_fit
					'mo_modeling_mode           'mo_allow_rationals
					'mo_tol_continuity_gap
	)

	(list 'buttons 'Reset 'Save 'Exit)

	(ui-group-widget 
			(list 'title "Fitting")
	)

	(ui-distance-widget "mo_tol_crv_fit" 
		(list 'range 'min minimum-tolerance)
		(list 'precision "%f8.5")
	)

	(ui-integer-widget "mo_tol_checkpoints" 
		(list 'range 1 10)
	)

	(ui-integer-widget "mo_tol_maxsurfspans" 
		(list 'range 1 1024)
	)

	(ui-group-widget 
			(list 'title "Continuity")
	)

	(ui-distance-widget "mo_tol_continuity_gap"
		(list 'range 'min 0.000001)
		(list 'precision "%f8.5")
	)

	(ui-angle-widget "mo_tol_continuity_angle" 
		(list 'precision "%f8.5")
		(list 'range 0.0 90.0)
	)

	(ui-double-widget "mo_tol_curvature" 
		(list 'precision "%f8.5")
		(list 'slider_range 0.0 1.0)
		(list 'range 0.0 10000.0)
	)

	(ui-group-widget 
			(list 'title "Curve On Surface / Trim")
	)

	(ui-distance-widget "mo_tol_trim_crv_fit" 
		(list 'precision "%f8.5")
		(list 'range 'min minimum-tolerance)
	)

	(ui-distance-widget "mo_tol_cos_gap" 
		(list 'precision "%f8.5")
		(list 'range 'min minimum-tolerance)
	)

	(ui-group-widget 
			(list 'title "Polygon")
	)

	(ui-distance-widget "mo_tol_vertex" 
		(list 'precision "%f8.5")
		(list 'range 'min minimum-tolerance)
	)

	(ui-group-widget 
			(list 'title "Modeling modes")
	)

    (ui-radio-widget "mo_modeling_mode" 
		(list 'columns 1)
        (ui-choice "modeling.mode.spline" '0)
        (ui-choice "modeling.mode.polyset" '1)
    )

    (ui-boolean-widget "mo_allow_rationals")

)
