;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Toggle Backface Culling Options
;;;

(ui-string "tglcull.name"              "Polygon Display Options")
(ui-string "mo_tgl_cull_options"       "Toggle Type")
(ui-string "mo_tgl_cull_topo_on"       "Show topology")
(ui-string "mo_tgl_cull_pgon_sel_on"   "Selected polygons")
(ui-string "mo_tgl_cull_edge_affected_off" "Affected Edge Display Mode Off")

(ui-string "mo_tgl_cull_on"             "Backface culling")
(ui-string "mo_tgl_cull_style"			"Cull Style")
(ui-string "mo_tgl_cull_face"			"Faces")
(ui-string "mo_tgl_cull_facevtx"		"Faces and Vertices")

(ui-string "mo_tgl_cull_color_on"	   "Colored Display")
(ui-string "mo_tgl_cull_color_style"   "Display Style")
(ui-string "mo_tgl_cull_shade_on"      "Wire frame ")
(ui-string "mo_tgl_cull_filled_on"     "Filled")
(ui-string "mo_tgl_cull_filled_option" "Depth Buffered")
(ui-string "mo_tgl_col_buffered"	   "On")
(ui-string "mo_tgl_col_nobuffered"	   "Off")

(ui-string "mo_tgl_cull_uv_on" "Color Style")
(ui-string "mo_tgl_col_uv_color"	   "UV color")
(ui-string "mo_tgl_col_geom_color"	   "Geometry color")

(ui-string "tglcull.type.all"          "All Windows")
(ui-string "tglcull.type.cur"          "Current Window")

(ui-string "mo_disp_poly_normal_style" "Normal Style")
(ui-string "tglcull.polynorm"  "Polygon")
(ui-string "tglcull.vertnorm"  "Vertex")
(ui-string "tglcull.vertpolynorm"  "Polygon + Vertex")
(ui-string "mo_disp_poly_normal_scale" "Normal Scale")
(ui-string "mo_disp_poly_normal_scale_style" "Normal Length")
(ui-string "mo_disp_poly_normal_arrow_style" "Normal Arrow")
(ui-string "mo_disp_poly_normal_label_style" "Normal Label")

(ui-string "mo_disp_poly_alpha_style" "Enable Transparency")
(ui-string "mo_disp_poly_cdepth_style" "Color Depth Per Channel")

(ui-string "mo_tgl_cull_showstats" "Show statistics")
(ui-string "mo_tgl_cull_showstats.instances" "Count instances")
(ui-string "mo_tgl_cull_showstats.templates" "Count templated")

(ui-string "mo_tgl_cull_showstats.warn_vcount" "Vertex Count Warning")
(ui-string "mo_tgl_cull_showstats.warn_pcount" "Polygon Count Warning")

(ui-editor "tglcull.options"           

	(list 'title 'tglcull.name)
	
	(list 'symbols 
		  'mo_tgl_cull_options		'mo_tgl_cull_options
		  'mo_tgl_cull_on			'mo_tgl_cull_filled_option
		  'mo_tgl_cull_color_on 	'mo_tgl_cull_color_style 
		  'mo_tgl_cull_topo_on		'mo_tgl_cull_pgon_sel_on 
		  'mo_tgl_cull_style	    'mo_tgl_cull_uv_on 
		  'mo_disp_poly_normal_style  'mo_disp_poly_normal_scale
		  'mo_disp_poly_normal_scale_style 'mo_disp_poly_normal_arrow_style
		  'mo_disp_poly_normal_label_style
		  'mo_disp_poly_alpha_style		  
		  'mo_disp_poly_cdepth_style 'mo_tgl_cull_showstats
 		  'mo_tgl_cull_showstats.instances
		  'mo_tgl_cull_showstats.templates
		  'mo_tgl_cull_showstats.warn_vcount
		  'mo_tgl_cull_showstats.warn_pcount
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-separator-widget)

	;; Statistics
	;;
    (ui-group-widget
	 (list 'title "Poly Statistics Options"))

	(ui-tick-widget 'mo_tgl_cull_showstats
		(list 'assign 'mo_tgl_cull_state_change #t)					
	)	
	(ui-tick-left-widget 'mo_tgl_cull_showstats.instances
		(list 'assign 'mo_tgl_cull_state_change #t)					
		(list 'enabled (ui-eq 'mo_tgl_cull_showstats 1))
	)
	(ui-tick-right-widget 'mo_tgl_cull_showstats.templates
		(list 'assign 'mo_tgl_cull_state_change #t)					
		(list 'enabled (ui-eq 'mo_tgl_cull_showstats 1))
    )

	(ui-tick-left-widget 'mo_tgl_cull_showstats.warn_on_pcount
		(list 'assign 'mo_tgl_cull_state_change #t)					
		(list 'enabled (ui-eq 'mo_tgl_cull_showstats 1))
    )
	(ui-tick-right-widget 'mo_tgl_cull_showstats.warn_on_pcount
		(list 'assign 'mo_tgl_cull_state_change #t)					
		(list 'enabled (ui-eq 'mo_tgl_cull_showstats 1))
    )
	(ui-integer-widget  'mo_tgl_cull_showstats.warn_vcount
	   (list 'range 0)					   
		(list 'assign 'mo_tgl_cull_state_change #t)					
		(list 'enabled (ui-eq 'mo_tgl_cull_showstats 1))
	)
	(ui-integer-widget  'mo_tgl_cull_showstats.warn_pcount
	   (list 'range 0)					   
		(list 'assign 'mo_tgl_cull_state_change #t)					
		(list 'enabled (ui-eq 'mo_tgl_cull_showstats 1))
	)

    (ui-group-widget
	 (list 'title "Object Style Options"))


	(ui-popup-widget "mo_disp_poly_normal_style"
		(list 'columns 1)
		(ui-choice "tglcull.polynorm"  1
		   (list 'assign 'mo_tgl_cull_state_change #t)
	    )
		(ui-choice "tglcull.vertnorm"  2
		   (list 'assign 'mo_tgl_cull_state_change #t)
	    )
		(ui-choice "tglcull.vertpolynorm"  3
		   (list 'assign 'mo_tgl_cull_state_change #t)
	    )
	)
	(ui-double-widget "mo_disp_poly_normal_scale"
		(list 'range 0.1 5.0)
	    (list 'assign 'mo_tgl_cull_state_change #t)
    )					  

;;;
;;; Controls the length of normal drawn, whether it is normalized or not
;;;
    (ui-tick-widget "mo_disp_poly_normal_scale_style"
	    (list 'assign 'mo_tgl_cull_state_change #t)
	)

	(ui-tick-widget "mo_disp_poly_normal_arrow_style"
		(list 'assign 'mo_tgl_cull_state_change #t)
	)	
	
    (ui-tick-widget "mo_disp_poly_normal_label_style"
        (list 'assign 'mo_tgl_cull_state_change #t)
        (list 'enabled (ui-eq 'mo_disp_poly_normal_arrow_style 1))
    )   

	(ui-integer-widget "mo_disp_poly_cdepth_style"
	   (list 'range 0 256)
	   (list 'assign 'mo_tgl_cull_state_change #t)
   )

	(ui-tick-widget "mo_disp_poly_alpha_style"
		(list 'assign 'mo_tgl_cull_state_change #t)
	)

    (ui-group-widget
	 (list 'title "Window Display Options"))

	(ui-popup-widget "mo_tgl_cull_options" 
		(list 'columns 1)
		(ui-choice "tglcull.type.all"  'MO_ALL_WIND)
		(ui-choice "tglcull.type.cur"  'MO_CUR_WIND)
	)

	(ui-separator-widget)

	; Topology on/off
	(ui-tick-left-widget "mo_tgl_cull_topo_on"
	   (list 'assign 'mo_tgl_cull_state_change #t)
	)

	; Selected polygon on/off
	(ui-tick-right-widget "mo_tgl_cull_pgon_sel_on"
	   (list 'assign 'mo_tgl_cull_state_change #t)
	)

	; Affected edges off - disabled for now. BK Oct1796.
	;(ui-boolean-widget "mo_tgl_cull_edge_affected_off"
	;   (list 'assign 'mo_tgl_cull_state_change #t)
	;)

	;(ui-separator-widget)

	; Cull on/off	
	(ui-boolean-widget "mo_tgl_cull_on" 0
	   (list 'assign 'mo_tgl_cull_state_change #t)
	)
	; Cull options
	(ui-popup-widget "mo_tgl_cull_style"
		(list 'rebuild #t)
		(list 'enabled 
			  (ui-eq 'mo_tgl_cull_on #t)
		)
		(ui-choice "mo_tgl_cull_face" 'MO_TGL_CULL_FACE
		   (list 'assign 'mo_tgl_cull_state_change #t)
		)
		(ui-choice "mo_tgl_cull_facevtx" 'MO_TGL_CULL_FACEVTX
		   (list 'assign 'mo_tgl_cull_state_change #t)
		)
    )

	(ui-separator-widget)

	; Color on/off
	(ui-boolean-widget "mo_tgl_cull_color_on"
		(list 'rebuild #t)			   
	    (list 'assign 'mo_tgl_cull_state_change #t)
	)

	; Main color options (wireframe or shaded)
	(ui-popup-widget "mo_tgl_cull_color_style"
		(list 'rebuild #t)
		(list 'enabled 
			  (ui-eq 'mo_tgl_cull_color_on #t)
		)
		(ui-choice "mo_tgl_cull_shade_on" 'MO_TGL_PCOLOR_WIRE
		   (list 'assign 'mo_tgl_cull_state_change #t)
		)
		(ui-choice "mo_tgl_cull_filled_on" 'MO_TGL_PCOLOR_FILL
		   (list 'assign 'mo_tgl_cull_state_change #t)
		)
    )

	; Filled options	   
	(ui-popup-widget "mo_tgl_cull_filled_option"
		(list 'rebuild #t)	  
		(list 'enabled
			  (ui-and
				(ui-eq 'mo_tgl_cull_color_style 'MO_TGL_PCOLOR_FILL)
				(ui-eq 'mo_tgl_cull_color_on #t)
			  )
		)
		(ui-choice "mo_tgl_col_buffered" 'MO_TGL_PCOLOR_ZBUF
		   (list 'assign 'mo_tgl_cull_state_change #t)
		)
		(ui-choice "mo_tgl_col_nobuffered" 'MO_TGL_PCOLOR_NOZBUF
		   (list 'assign 'mo_tgl_cull_state_change #t)
		)
	)

	; Colour style options
	(ui-popup-widget "mo_tgl_cull_uv_on"
		(list 'rebuild #t)	  
		(list 'enabled (ui-eq 'mo_tgl_cull_color_on #t))

		(ui-choice "mo_tgl_col_geom_color" 0
		   (list 'assign 'mo_tgl_cull_state_change #t)
		)
		(ui-choice "mo_tgl_col_uv_color" 1
		   (list 'assign 'mo_tgl_cull_state_change #t)
		)
	)
)























