;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Surface Tools Menu
;;;

(ui-string "mp_movevect_str"            "move project vector")
(ui-string "mp_movevect_attr_str"       "move")
(ui-string "mp_winvect_str"             "vector from window")
(ui-string "mp_winvect_attr_str"        "set vect")
(ui-string "mp_claymate_str"            "claymate...")
(ui-string "mp_claymate_attr_str"       "claymt")
(ui-string "mp_fitscan_str"          	"Fit Scan 2014")
(ui-string "mp_fitscan_attr_str"        "ftsc14")
(ui-string "mp_newfitscan_str"          "Fit Scan")
(ui-string "mp_newfitscan_attr_str"     "fitscn")
(ui-string "mp_rebuild_str"             "Rebuild Surface")
(ui-string "mp_rebuild_attr_str"        "rebsrf")
(ui-string "mp_alignmsh_str"            "align mesh")
(ui-string "mp_alignmsh_attr_str"       "al mesh")
(ui-string "mp_trim_convert_str"        "Trim Convert")
(ui-string "mp_trim_convert_attr_str"   "trmcvt")
(ui-string "mp_untrim_str"              "untrim")
(ui-string "mp_untrim_attr_str"         "untrim")
(ui-string "mp_trimdiv_str"             "trim divide")
(ui-string "mp_trimdiv_attr_str"        "divide")
(ui-string "mp_trim_str"                "trim")
(ui-string "mp_trim_attr_str"           "trim")
(ui-string "mp_geomap_str"              "Geometry Mapping")
(ui-string "mp_geomap_attr_str"         "gomap")
(ui-string "mp_intersect_str"           "intersect")
(ui-string "mp_intersect_attr_str"      "isect")
(ui-string "mp_project_str"             "project")
(ui-string "mp_project_attr_str"        "prjct")
(ui-string "mp_sh_stitch_str"           "Shell Stitch")
(ui-string "mp_sh_stitch_attr_str"      "stch")
(ui-string "mp_sh_unstitch_str"         "Shell Unstitch")
(ui-string "mp_sh_unstitch_attr_str"    "unstch")
(ui-string "mp_sh_subtract_str"         "Shell Subtract")
(ui-string "mp_sh_subtract_attr_str"    "sh sub")
(ui-string "mp_sh_union_str"            "Shell Union")
(ui-string "mp_sh_union_attr_str"       "sh un")
(ui-string "mp_sh_intersect_str"        "Shell Intersect")
(ui-string "mp_sh_intersect_attr_str"   "sh int")
(ui-string "mp_sh_rebuild_str"          "Shell rebuild")
(ui-string "mp_sh_rebuild_attr_str"     "sh reb")
(ui-string "mp_alignhull_str"           "align hull")
(ui-string "mp_alignhull_attr_str"      "al hull")
(ui-string "mp_hullplanarize_str"       "Planarize Hull")
(ui-string "mp_hullplanarize_attr_str"  "plhull")
(ui-string "mp_trim_tool_str"           "Trim Surface")
(ui-string "mp_trim_tool_attr_str"      "trim")
(ui-string "mp_srf_orient_visual_normals"      "Set Visual Surface Orientation")
(ui-string "mp_srf_orient_visual_normals_str"  "visnrm")
(ui-string "mp_srf_orient_geometric_normals"      "Set Geometric Surface Orientation")
(ui-string "mp_srf_orient_geometric_normals_str" "geonrm")
(ui-string "mp_edit_unifynormals"		"Unify Surface Orientation")
(ui-string "mp_edit_unifynormals_str"   "unifor")
(ui-string "mp_refitsurfaces_str"		"Refit Surfaces")
(ui-string "mp_refitsurfaces_attr_str"	"refsrf")
(ui-string "mp_srf_normals"             "Reverse Visual Surface Orientation")
(ui-string "mp_srf_normals_str"         "revor")
(ui-string "mp_srf_uvs"                 "Reverse Surface UV")
(ui-string "mp_srf_uvs_str"             "revuv")
(ui-string "mp_ntb_str"					"NURBS to Bezier")
(ui-string "mp_ntb_attr_str"			"ntb")
(ui-string "mp_srf_align_str"				"Surface Align")
(ui-string "mp_srf_align_attr"			"srfalgn")

(ui-function "mp_srftools_nurbstobez"
	(list 'command				"NurbsToBezierTool")
	(list 'label_string			'mp_ntb_str)
	(list 'attribute_string		'mp_ntb_attr_str)
	(list 'option_function		"NurbsToBezierToolControlBox")
	(list 'symbols
			'mo_nurbs_to_bezier_all
			'mo_nurbs_to_bezier_keep_originals
	)
)

(ui-function "mp_objmod_orient_visual_normals"
	(list 'command				"OrientVisualNormals")
	(list 'label_string			'mp_srf_orient_visual_normals)
	(list 'attribute_string		'mp_srf_orient_visual_normals_str)
)

(ui-function "mp_objmod_orient_geometric_normals"
	(list 'command				"OrientGeometricNormals")
	(list 'label_string			'mp_srf_orient_geometric_normals)
	(list 'attribute_string		'mp_srf_orient_geometric_normals_str)
)

(ui-function "mp_objmod_unifynormals"        
	(list 'command				"UnifyNormals")
	(list 'label_string        	'mp_edit_unifynormals)
	(list 'attribute_string   	'mp_edit_unifynormals_str)
	(list 'option_function		"UnifyNormalsControlBox")
	(list 'symbols
			"mo_unify_normals_type"
			"mo_unify_normals_operation"
	)
)

(ui-function "mp_srftools_movevect"     
	(list 'command				"MoveProjectVector")
	(list 'label_string        	'mp_movevect_str)
	(list 'attribute_string   	'mp_movevect_attr_str)
)

(ui-function "mp_srftools_winvect"      
	(list 'command				"VectorFromWindow")
	(list 'label_string        	'mp_winvect_str)
	(list 'attribute_string   	'mp_winvect_attr_str)
)

(ui-function "mp_srftools_fitscan"
	(list 'command				"FitScan")
	(list 'label_string        	'mp_fitscan_str)
	(list 'attribute_string   	'mp_fitscan_attr_str)
	(list 'option_function		"FitScanControl")
	(list 'symbols
			"mo_fit_scan_uspans"
			"mo_fit_scan_vspans"
			"mo_fit_scan_udegree"
			"mo_fit_scan_vdegree"
			"mo_fit_scan_smoothness"
			"mo_fit_scan_keep_originals"
			"mo_fit_scan_deviations"
			"mo_fit_scan_auto_recalc"
            "mo_fit_scan_create_metadata"
			"mo_fit_scan_direction"
			"mo_fit_scan_proximity"
			"mo_fit_scan_match_surface"
			"mo_fit_scan_match_limit"
	)
)

(ui-function "mp_srftools_newfitscan"
	(list 'command				"NewFitScan")
	(list 'label_string        	'mp_newfitscan_str)
	(list 'attribute_string   	'mp_newfitscan_attr_str)
	(list 'option_function		"NewFitScanControlBox")
	(list 'symbols
			"mo_fit_scan_uspans"
			"mo_fit_scan_vspans"
			"mo_fit_scan_udegree"
			"mo_fit_scan_vdegree"
			"mo_fit_scan_smoothness"
			"mo_fit_scan_keep_originals"
			"mo_fit_scan_deviations"
			"mo_fit_scan_auto_recalc"
			"mo_fit_scan_direction"
			"mo_fit_scan_multi_surf_test"
			"mo_fit_scan_proximity"
	)
)

(ui-function "mp_srftools_claymate"     
	(list 'command				"Claymate")
	(list 'label_string        	'mp_claymate_str)
	(list 'attribute_string   	'mp_claymate_attr_str)
	(list 'option_editor       	"Modeling/mo_claymate_options.o.scm"
								'claymate.options)
)

(ui-function "mp_srftools_rebuild"      
	(list 'command				"RebuildSurface")
	(list 'label_string        	'mp_rebuild_str)
	(list 'attribute_string   	'mp_rebuild_attr_str)
	(list 'option_function		"RebuildSurfaceControl")
	(list 'symbols
			'mo_srf_rebuild_type			'mo_srf_rebuild_tolerance
			'mo_srf_rebuild_tangency		'mo_srf_rebuild_direction
			'mo_srf_rebuild_changeCVs		'mo_srf_rebuild_spansNumU
			'mo_srf_rebuild_spansNumV		'mo_srf_rebuild_relativeSpans
			'mo_srf_rebuild_spansMaxU		'mo_srf_rebuild_spansMaxV
			'mo_srf_rebuild_spansFactU		'mo_srf_rebuild_spansFactV
			'mo_srf_rebuild_changeDegree	'mo_srf_rebuild_degreeU
			'mo_srf_rebuild_degreeV			'mo_srf_rebuild_autoRecalc
			'mo_srf_rebuild_keepOriginals	'mo_srf_rebuild_measureDev
			'mo_srf_rebuild_MinMaxDev		'mo_srf_rebuild_history
	)
)

(ui-function "mp_srftools_alignmsh"     
	(list 'command				"AlignMesh")
	(list 'label_string        	'mp_alignmsh_str)
	(list 'attribute_string   	'mp_alignmsh_attr_str)
	(list 'option_editor       	"Modeling/mo_align_mesh_options.o.scm"
								'align.mesh.options)
)

(ui-function "mp_srftools_trim_convert"
	(list 'command				"TrimConvert")
	(list 'label_string			'mp_trim_convert_str)
	(list 'attribute_string		'mp_trim_convert_attr_str)
	(list 'option_function		"TrimConvertControlBox")
	(list 'symbols
		'mo_trim_convert_3d_trim
		'mo_trim_convert_3d_trim_type
		'mo_trim_convert_extend
		'mo_trim_convert_extend_type
		'mo_trim_convert_extend_tol
		'mo_trim_convert_vector_name
		'mo_trim_convert_vector_presets
		'mo_trim_convert_vector_refresh
		'mo_trim_convert_vector_save
		'mo_trim_convert_vector_create
		'mo_trim_convert_uspans
		'mo_trim_convert_vspans
		'mo_trim_convert_udegree
		'mo_trim_convert_vdegree
		'mo_trim_convert_direction
		'mo_trim_convert_surface_deviation
		'mo_trim_convert_edge_deviations
		'mo_trim_convert_keep_originals
		'mo_trim_convert_auto_recalc
        'mo_trim_convert_create_metadata
		'mo_trim_convert_show_diagnostics
		'mo_trim_convert_show_preview
		'mo_trim_convert_selector_length
		'mo_trim_convert_default_trim_type
		'mo_trim_convert_mouse_trim_mode
	)
)

(ui-function "mp_srftools_untrim"       
	(list 'command				"Untrim")
	(list 'label_string        	'mp_untrim_str)
	(list 'attribute_string  	'mp_untrim_attr_str)
	(list 'option_editor       	"Modeling/mo_untrim_options.o.scm"
								'untrim.options)
)

(ui-function "mp_srftools_trimdiv"      
	(list 'command				"TrimDivide")
	(list 'label_string        	'mp_trimdiv_str)
	(list 'attribute_string   	'mp_trimdiv_attr_str)
	(list 'option_editor       	"Modeling/mo_trmdivide_options.o.scm"
								'divide.options)
)

(ui-function "mp_srftools_trim"         
	(list 'command				"Trimer")
	(list 'label_string        	'mp_trim_str)
	(list 'attribute_string   	'mp_trim_attr_str)
	(list 'option_editor       	"Modeling/mo_trim_options.o.scm"
								'trim.options)
)

(ui-function "mp_srftools_trim_tool"
	(list 'command          "Trim")
	(list 'label_string     'mp_trim_tool_str)
	(list 'attribute_string 'mp_trim_tool_attr_str)
	(list 'option_function  "TrimControlBox")
	(list 'symbols
			'mo_trim_3d_trim
			'mo_trim_3d_trim_type
			'mo_trim_extend
			'mo_trim_extend_type
			'mo_trim_extend_tol
			'mo_trim_project_history
			'mo_trim_divide_history
			'mo_trim_show_diagnostics
			'mo_trim_show_preview
			'mo_trim_pick_chain
			'mo_trim_default_trim_type
			'mo_trim_selector_length
			'mo_trim_vector_name
			'mo_trim_vector_presets
			'mo_trim_vector_refresh
			'mo_trim_vector_save
			'mo_trim_last_selectors
			'mo_trim_mouse_trim_mode
	)
)

(ui-function "mp_srftools_geomap"       
	(list 'command				"GeometryMapping")
	(list 'label_string        	'mp_geomap_str)
	(list 'attribute_string   	'mp_geomap_attr_str)
	(list 'option_editor       	"Modeling/mo_geomap_options.o.scm"
								'geomap.options)
)

(ui-function "mp_srftools_intersect"    
	(list 'command				"Intersect")
	(list 'label_string        	'mp_intersect_str)
	(list 'attribute_string   	'mp_intersect_attr_str)
	(list 'option_editor       	"Modeling/mo_intersect_options.o.scm"
								'intersect.options)
)

(ui-function "mp_srftools_project"      
	(list 'command				"Project")
	(list 'label_string        	'mp_project_str)
	(list 'attribute_string   	'mp_project_attr_str)
    (list 'option_function      "ProjectControlBox")
    (list 'symbols
          'mo_proj_trim_create
		  'mo_proj_explicit_control
		  'mo_proj_exp_degree
		  'mo_proj_exp_spans
		  'mo_proj_exp_modify_target
		  'mo_proj_exp_max_dev
		  'mo_proj_vector_name
		  'mo_proj_vector_presets
		  'mo_proj_vector_refresh
		  'mo_proj_vector_save
          'tro_proj_create_trim_history
		  'tro_closest_checkpoints)
)

(ui-function "mp_srftools_sh_stitch"
	(list 'command				"ShellStitch")
	(list 'label_string        	'mp_sh_stitch_str)
	(list 'attribute_string   	'mp_sh_stitch_attr_str)
    (list 'option_function      "ShellStitchControlBox")
    (list 'symbols
          'mo_stitch_use_constropts
          'mo_stitch_tolerance
          'mo_stitch_keep_originals
          'mo_stitch_detach_single_curves
          'mo_stitch_detach_periodics)
)

(ui-function "mp_srftools_sh_unstitch"  
	(list 'command				"ShellUnStitch")
	(list 'label_string        	'mp_sh_unstitch_str)
	(list 'attribute_string   	'mp_sh_unstitch_attr_str)
	(list 'option_editor       	"Modeling/sh_unstitch_options.o.scm"
								'sh_unstitch.options)
)

(ui-function "mp_srftools_sh_subtract"  
	(list 'command				"ShellSubtract")
	(list 'label_string        	'mp_sh_subtract_str)
	(list 'attribute_string   	'mp_sh_subtract_attr_str)
	(list 'option_editor       	"Modeling/sh_subtract_options.o.scm"
								'sh_subtract.options)
)

(ui-function "mp_srftools_sh_union"     
	(list 'command				"ShellUnion")
	(list 'label_string        	'mp_sh_union_str)
	(list 'attribute_string   	'mp_sh_union_attr_str)
	(list 'option_editor       	"Modeling/sh_union_options.o.scm"
								'sh_union.options)
)

(ui-function "mp_srftools_sh_intersect" 
	(list 'command				"ShellIntersect")
	(list 'label_string        	'mp_sh_intersect_str)
	(list 'attribute_string   	'mp_sh_intersect_attr_str)
	(list 'option_editor       	"Modeling/sh_intersect_options.o.scm"
								'sh_intersect.options)
)

(ui-function "mp_srftools_sh_rebuild"   
	(list 'command				"ShellRebuild")
	(list 'label_string        	'mp_sh_rebuild_str)
	(list 'attribute_string   	'mp_sh_rebuild_attr_str)
)

(ui-function "mp_srftools_hullplanarize"
	(list 'command              "HullPlanarize")
	(list 'label_string         'mp_hullplanarize_str)
	(list 'attribute_string     'mp_hullplanarize_attr_str)
	(list 'option_function      "HullPlanarizeControlBox")
	(list 'symbols
          'mo_hull_planarize_vector_select_method
          'mo_hull_planarize_iterations
          'mo_hull_planarize_include_edges
          'mo_hull_planarize_type
          'mo_hull_planarize_view_based
          'mo_hull_planarize_calculate_deviation
          'mo_hull_planarize_proxy_display
          )
                
    
)

(if (ui-symbol-true "aw_fod_srftools_alignhull" )
	(begin
		(ui-function "mp_srftools_alignhull"
			(list 'command              "AlignHull")
			(list 'label_string         'mp_alignhull_str)
			(list 'attribute_string     'mp_alignhull_attr_str)
			(list 'option_function      "AlignHullControls")
		)
	)
)


(ui-function "mp_srftools_refitsurfaces"
	(list 'command				"RefitSurfaces")
	(list 'label_string        	'mp_refitsurfaces_str)
	(list 'attribute_string   	'mp_refitsurfaces_attr_str)
	(list 'option_function		"RefitSurfacesControlBox")
	(list 'symbols
			"mo_refitsrfs_mindegree"
			"mo_refitsrfs_smooth"
			"mo_refitsrfs_smoothfactor"
			"mo_refitsrfs_direction"
			"mo_refitsrfs_history"
			"mo_refitsrfs_autoupdate"
			"mo_refitsrfs_keep_originals"
			"mo_refitsrfs_deviation"
			"mo_refitsrfs_deviationscale"
	)
)

(ui-function "mp_srftools_reverse_normal"        
	(list 'command				"ReverseDirection")
	(list 'label_string        	'mp_srf_normals)
	(list 'attribute_string   	'mp_srf_normals_str)
	(list 'option_editor        "Modeling/mo_srf_normals_options.o.scm"
								'srf_normals.options)
)

(ui-function "mp_srftools_reverse_uv"        
	(list 'command				"ReverseUV")
	(list 'label_string        	'mp_srf_uvs)
	(list 'attribute_string   	'mp_srf_uvs_str)
	(list 'option_editor        "Modeling/mo_srf_uvs_options.o.scm"
								'srf_uvs.options)
)

(ui-function "mp_srftools_shader_edit"        
	(list 'command				"EditShader")
	(list 'label_string        	'mp_srf_shader_edit)
	(list 'attribute_string   	'mp_srf_shader_edit_str)
)

(ui-function "mp_srftools_shader_set_active"        
	(list 'command				"CopyShader")
	(list 'label_string        	'mp_srf_shader_set_active)
	(list 'attribute_string   	'mp_srf_shader_set_active_str)
)

(ui-function "mp_srftools_shader_assign"        
	(list 'command				"PasteShader")
	(list 'label_string        	'mp_srf_shader_assign)
	(list 'attribute_string   	'mp_srf_shader_assign_str)
)

(ui-function "mp_srftools_shader_create_copy"        
	(list 'command				"CreateShader")
	(list 'label_string        	'mp_srf_shader_create_copy)
	(list 'attribute_string   	'mp_srf_shader_create_copy_str)
)

(ui-function "mp_srftools_shader_multilister_assign"        
	(list 'command				"AssignMultiListerShader")
	(list 'label_string        	'mp_srf_shader_multilister_assign)
	(list 'attribute_string   	'mp_srf_shader_multilister_assign_str)
)

(ui-function "mp_srftools_shader_multilister_edit"        
	(list 'command				"EditMultiListerShader")
	(list 'label_string        	'mp_srf_shader_multilister_edit)
	(list 'attribute_string   	'mp_srf_shader_multilister_edit_str)
)

(ui-function "mp_srftools_srf_align"
	(list 'command          "SurfaceAlign")
	(list 'label_string     'mp_srf_align_str)
	(list 'option_function		"SurfaceAlignControlBox")
	(list 'attribute_string 'mp_srf_align_attr)
	(list 'symbols
		  'mo_surface_align_0_mode
		  'mo_surface_align_1_mode
		  'mo_surface_align_2_mode
		  'mo_surface_align_3_mode

		  'mo_surface_align_0_adopt
		  'mo_surface_align_1_adopt
		  'mo_surface_align_2_adopt
		  'mo_surface_align_3_adopt

		  'mo_surface_align_0_start
		  'mo_surface_align_1_start
		  'mo_surface_align_2_start
		  'mo_surface_align_3_start

		  'mo_surface_align_0_end
		  'mo_surface_align_1_end
		  'mo_surface_align_2_end
		  'mo_surface_align_3_end

		  'mo_surface_align_0_invert
		  'mo_surface_align_1_invert
		  'mo_surface_align_2_invert
		  'mo_surface_align_3_invert

		  'mo_surface_align_0_partial
		  'mo_surface_align_1_partial
		  'mo_surface_align_2_partial
		  'mo_surface_align_3_partial

		  'mo_surface_align_0_adapt
		  'mo_surface_align_1_adapt
		  'mo_surface_align_2_adapt
		  'mo_surface_align_3_adapt

		  'mo_surface_align_0_arc
		  'mo_surface_align_1_arc
		  'mo_surface_align_2_arc
		  'mo_surface_align_3_arc

		  'mo_surface_align_0_raise
		  'mo_surface_align_1_raise
		  'mo_surface_align_2_raise
		  'mo_surface_align_3_raise

		  'mo_surface_align_0_force
		  'mo_surface_align_1_force
		  'mo_surface_align_2_force
		  'mo_surface_align_3_force

		  'mo_surface_align_continuity_check
		  'mo_surface_align_chain_select
		  'mo_surface_align_auto_update
		  )
)
