;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Sphere Option Box
;;;

(ui-string "sphere.name"                "Sphere Options")
(ui-string "mo_prim_sphere_type"   		"Sphere Type")
(ui-string "mo_sphere_sweep"            "Sweep")
(ui-string "mo_sphere_sections"         "Spans")
(ui-string "mo_sphere_geometry_type"    "Object Degree")

(ui-string "sphere.degree.one"            "1")
(ui-string "sphere.degree.three"          "3")

(ui-string "sphere.sphere-kind.nurbs"     "Surface")
(ui-string "sphere.sphere-kind.nopole"    "Shell No-Pole")
(ui-string "sphere.sphere-kind.tennis"    "Shell Tennis ball")

(ui-editor "sphere.options"               
	
	(list 'title 'sphere.name)

	(list 'symbols 	'mo_sphere_sweep 		'mo_sphere_sections		
					'mo_sphere_geometry_type
					'mo_prim_sphere_type
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_prim_sphere_type"
		(list "rebuild")
		(list 'columns 1)
		(ui-choice "sphere.sphere-kind.nurbs"     'MO_PRIM_SPH_NURBS)
		(ui-choice "sphere.sphere-kind.tennis"    'MO_PRIM_SPH_TENNIS
		    (list 'enabled (ui-eq 'mo_modeling_mode 0)
			)
		)
		(ui-choice "sphere.sphere-kind.nopole"    'MO_PRIM_SPH_NOPOLE
		    (list 'enabled (ui-eq 'mo_modeling_mode 0)
			)
	    )
	)

	(ui-radio-widget "mo_sphere_geometry_type" 
		(list 'enabled (ui-and 
						(ui-eq "mo_prim_sphere_type" 'MO_PRIM_SPH_NURBS)
						(ui-eq "mo_allow_rat_primitives" #f)
						)
		)
		(list "rebuild")
		(ui-choice "sphere.degree.one"    'MO_POLYGON)
		(ui-choice "sphere.degree.three"  'MO_BSPLINE)
	)

	(ui-angle-widget "mo_sphere_sweep"         
		(list 'enabled (ui-eq "mo_prim_sphere_type" 'MO_PRIM_SPH_NURBS))
		(list 'precision "%f6.2")
		(list 'range 0 360)
	)

	(ui-integer-widget "mo_sphere_sections"    
		(list 'enabled 
				(ui-and
					(ui-eq "mo_prim_sphere_type" 'MO_PRIM_SPH_NURBS)
					(ui-eq "mo_allow_rat_primitives"  #f)
				)
		)

		(list 'range 3 10000)
	)
)
