;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Smooth Option Box
;;;

(ui-string "smooth.name"                "Smooth Options")
(ui-string "mo_smooth_axis"             "Axis")
(ui-string "mo_smooth_direction"        "Surface Direction")
(ui-string "mo_cont_startu"             "Start U Continuity")
(ui-string "mo_cont_endu"               "End U Continuity")
(ui-string "mo_cont_startv"             "Start V Continuity")
(ui-string "mo_cont_endv"               "End V Continuity")

(ui-string "smooth.axis.x"              "X")
(ui-string "smooth.axis.y"              "Y")
(ui-string "smooth.axis.z"              "Z")
(ui-string "smooth.axis.all"            "All")
(ui-string "smooth.dir.u"               "U")
(ui-string "smooth.dir.v"               "V")
(ui-string "smooth.dir.both"            "Both")
(ui-string "smooth.cont.off"            "Off")
(ui-string "smooth.cont.position"       "Position")
(ui-string "smooth.cont.tangent"        "Tangent")
(ui-string "smooth.cont.curvature"      "Curvature")

(ui-editor "smooth.options"             

	(list 'title 'smooth.name)

	(list 'symbols 	'mo_smooth_axis		'mo_smooth_direction
					'mo_cont_startu		'mo_cont_endu
					'mo_cont_startv		'mo_cont_endv
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_smooth_axis"   
		(list 'columns 3)
		(ui-choice "smooth.axis.x"      'MO_SMOOTH_X)
		(ui-choice "smooth.axis.y"      'MO_SMOOTH_Y)
		(ui-choice "smooth.axis.z"      'MO_SMOOTH_Z)
		(ui-choice "smooth.axis.all"    'MO_SMOOTH_ALL)
	)

	(ui-separator-widget)
	
	(ui-radio-widget "mo_smooth_direction" 
		(list 'columns 3)		
		(list 'rebuild #t)
		(ui-choice "smooth.dir.u"       'MO_SMOOTH_U
			(list 'assign (ui-eq "mo_cont_startu" 'MO_SMOOTH_CONT_OFF)
				'mo_cont_startu	'MO_SMOOTH_CONT_G0
			)
			(list 'assign (ui-eq "mo_cont_endu" 'MO_SMOOTH_CONT_OFF)
				'mo_cont_endu 'MO_SMOOTH_CONT_G0
			)
		)
		(ui-choice "smooth.dir.v"       'MO_SMOOTH_V
			(list 'assign (ui-eq "mo_cont_startv" 'MO_SMOOTH_CONT_OFF)
				'mo_cont_startv 'MO_SMOOTH_CONT_G0
			)
			(list 'assign (ui-eq "mo_cont_endv" 'MO_SMOOTH_CONT_OFF)
				'mo_cont_endv 'MO_SMOOTH_CONT_G0
			)
		)
		(ui-choice "smooth.dir.both"    'MO_SMOOTH_BOTH)
	)
	
	(ui-separator-widget)
	
	(ui-popup-widget "mo_cont_startu"   
		(list 'rebuild #t)
		(ui-choice "smooth.cont.off"    'MO_SMOOTH_CONT_OFF
		 (list 'enabled
		  (ui-or
			(ui-eq "mo_smooth_direction" 'MO_SMOOTH_V)
			(ui-eq "mo_smooth_direction" 'MO_SMOOTH_BOTH)
		  )
		 )
		)
		(ui-choice "smooth.cont.position" 'MO_SMOOTH_CONT_G0)
		(ui-choice "smooth.cont.tangent" 'MO_SMOOTH_CONT_G1)
		(ui-choice "smooth.cont.curvature" 'MO_SMOOTH_CONT_G2)
	)

	(ui-popup-widget "mo_cont_endu"     
		(ui-choice "smooth.cont.off"    'MO_SMOOTH_CONT_OFF
		 (list 'enabled
		  (ui-or
			(ui-eq "mo_smooth_direction" 'MO_SMOOTH_V)
			(ui-eq "mo_smooth_direction" 'MO_SMOOTH_BOTH)
		  )
		 )
		)
		(ui-choice "smooth.cont.position" 'MO_SMOOTH_CONT_G0)
		(ui-choice "smooth.cont.tangent" 'MO_SMOOTH_CONT_G1)
		(ui-choice "smooth.cont.curvature" 'MO_SMOOTH_CONT_G2)
	)

	(ui-popup-widget "mo_cont_startv"   
		(ui-choice "smooth.cont.off"    'MO_SMOOTH_CONT_OFF
		 (list 'enabled
		  (ui-or
			(ui-eq "mo_smooth_direction" 'MO_SMOOTH_U)
			(ui-eq "mo_smooth_direction" 'MO_SMOOTH_BOTH)
		  )
		 )
		)
		(ui-choice "smooth.cont.position" 'MO_SMOOTH_CONT_G0)
		(ui-choice "smooth.cont.tangent" 'MO_SMOOTH_CONT_G1)
		(ui-choice "smooth.cont.curvature" 'MO_SMOOTH_CONT_G2)
	)

	(ui-popup-widget "mo_cont_endv"     
		(ui-choice "smooth.cont.off"    'MO_SMOOTH_CONT_OFF
		 (list 'enabled
		  (ui-or
			(ui-eq "mo_smooth_direction" 'MO_SMOOTH_U)
			(ui-eq "mo_smooth_direction" 'MO_SMOOTH_BOTH)
		  )
		 )
		)
		(ui-choice "smooth.cont.position" 'MO_SMOOTH_CONT_G0)
		(ui-choice "smooth.cont.tangent" 'MO_SMOOTH_CONT_G1)
		(ui-choice "smooth.cont.curvature" 'MO_SMOOTH_CONT_G2)
	)

)
