;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; SLC Output Options
;;;

(ui-string "slc.name"                   "Export SLC Options")

(ui-string "mo_slc_target" 		   	    "Output Units")
(ui-string "mo_slc_auto_range" 			"Auto Range")
(ui-string "mo_slc_step_z"	         	"Thickness")
(ui-string "mo_slc_start_z"         	"Start Z")
(ui-string "mo_slc_end_z"         		"End Z")
(ui-string "mo_slc_display"        		"Display Contours")

(ui-string "mo_slc_model_type"         	"Model Type")
(ui-string "slc.model.part" 			"Part")
(ui-string "slc.model.support" 			"Support")
(ui-string "slc.model.web" 				"Web")
(ui-string "slc.units.mm"               "mm")
(ui-string "slc.units.in"               "inches")

; Let's only go with 5 decimal places in the UI, and don't let anyone enter
; ANYTHING less then 0.0005 inches (0.00127 cm)
; Curve Fit Distance has a minimum of 0.00005 cm (0.00001968503 inches).
(define minimum-thickness 0.00127)

(ui-editor "slc.options"                
	
	(list 'title 'slc.name)

	(list 'symbols  'mo_slc_auto_range  'mo_slc_target
					'mo_slc_step_z 		'mo_slc_start_z
					'mo_slc_end_z		'mo_slc_model_type 
					'mo_slc_display     'mp_slc_command     
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

;	(ui-separator-widget
;		(list 'enabled (ui-eq "mo_sla_file_format" 'MO_SLA_FORMAT_STL))
;	)

	(ui-radio-widget "mo_slc_target"    
		(list 'columns 2)
		(ui-choice "slc.units.mm"       'MO_MILLIMETERS)
		(ui-choice "slc.units.in"       'MO_INCHES)
;		(list 'rebuild #t)
	)

;	(ui-separator-widget)

	(ui-radio-widget "mo_slc_model_type"     
;		(list 'columns 1)
		(ui-choice "slc.model.part" 	'MO_SLC_TYPE_PART)
		(ui-choice "slc.model.support" 	'MO_SLC_TYPE_SUPPORT)
		(ui-choice "slc.model.web"   	'MO_SLC_TYPE_WEB)
	)

 	(ui-tick-widget "mo_slc_auto_range"
		(list 'rebuild)
 	)

	(ui-distance-widget "mo_slc_step_z"
		(list 'precision "%f8.5")
		(list 'range 'min minimum-thickness)
	)

	(ui-distance-widget "mo_slc_start_z" 
		(list 'enabled (ui-eq "mo_slc_auto_range" #f))
		(list 'precision "%f8.5")
		(list 'range -1000000.0 1000000.0)
	)

	(ui-distance-widget "mo_slc_end_z" 
		(list 'enabled (ui-eq "mo_slc_auto_range" #f))
		(list 'precision "%f8.5")
		(list 'range -1000000.0 1000000.0)
	)

)
