;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Skin Option Box
;;;

(ui-string "skin.name"                  "Skinning Options")
(ui-string "mo_skin_mode"               "Skinning Mode")
(ui-string "mo_skintype"                "Topology")
(ui-string "mo_skin_U_knot_spacing"     "U Knot Spacing")
(ui-string "mo_skin_V_knot_spacing"     "V Knot Spacing")
(ui-string "mo_skin_subdiv"            	"Number of Spans")
(ui-string "mo_skin_geom_type"          "Surface Degree")
(ui-string "mo_skin_rebuild"            "Rebuild")
(ui-string "mo_skin_create_history"     "Create History")
(ui-string "mo_skin_auto_recalc"     	"Auto Update")

(ui-string "skin.type.open"             "Open")
(ui-string "skin.type.closed"           "Closed")
(ui-string "skin.spacing.uniform"       "Uniform")
(ui-string "skin.spacing.chord"			"Chord Length")
(ui-string "skin.spacing.arc" 	        "Arc Length")
(ui-string "skin.surface.one"           "1")
(ui-string "skin.surface.three"         "3")
(ui-string "skin.mode.exact"            "Interpolate")
(ui-string "skin.mode.fit"              "Cubic Fit")

(ui-editor "skin.options"               

	(list 'title 'skin.name)

	(list 'symbols 	'mo_skin_mode 
					'mo_skintype
					'mo_skin_U_knot_spacing
					'mo_skin_V_knot_spacing
					'mo_skin_subdiv
					'mo_skin_geom_type	
					'mo_skin_rebuild
					'mo_skin_create_history
					'mo_skin_auto_recalc
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_skin_mode"      
        (list "rebuild")
		(ui-choice "skin.mode.exact"     'MO_SKIN_EXACT)
		(ui-choice "skin.mode.fit"   	 'MO_SKIN_FIT)
	)

	(ui-separator-widget)

	(ui-radio-widget "mo_skintype"      
		(ui-choice "skin.type.open"     'MO_SKINOPEN)
		(ui-choice "skin.type.closed"   'MO_SKINCLOSED)
	)

	(ui-separator-widget)

	(ui-radio-widget "mo_skin_U_knot_spacing" 
        (list "rebuild")
		(ui-choice "skin.spacing.uniform" 	'MO_UNIFORM)
		(ui-choice "skin.spacing.arc" 		'MO_ARC_LENGTH)
	)

	(ui-radio-widget "mo_skin_V_knot_spacing" 
        (list "rebuild")
		(ui-choice "skin.spacing.uniform" 	'MO_UNIFORM)
		(ui-choice "skin.spacing.chord" 	'MO_CHORD_LENGTH)
	)


	(ui-separator-widget)

	(ui-radio-widget "mo_skin_geom_type" 
        (list "rebuild")
		(list 'enabled (ui-eq "mo_skin_mode" 'MO_SKIN_EXACT))
		(ui-choice "skin.surface.one"   'MO_LINEAR_SKIN)
		(ui-choice "skin.surface.three" 'MO_CUBIC_SKIN)
	)

    (ui-integer-widget "mo_skin_subdiv"
        (list "rebuild")
        (list 'range 1 999)
    )

	(ui-separator-widget)

	(ui-tick-widget "mo_skin_rebuild" )

	(ui-separator-widget)

	(ui-tick-widget "mo_skin_auto_recalc" )

	(ui-tick-widget "mo_skin_create_history" )

)




