;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; ShowCaseOut Output Options
;;;

(ui-string "showcaseout.name"                     "Send To Showcase Options")

(ui-string "mo_showcaseout_geometry"	   	      "Geometry Output")
(ui-string "mo_showcaseout_tess_setting"	   	  "Conversion Setting")
(ui-string "mo_showcaseout_bake_ao"  	   	      "Show Ambient Occlusion")
(ui-string "mo_showcaseout_replace_materials"     "Replace Materials")
(ui-string "mo_showcaseout_visual_style"          "Visual Style")
(ui-string "mo_showcaseout_replace_material_map"  "Replacement Map")
(ui-string "mo_showcaseout_visual_style"          "Visual Style")
(ui-string "mo_showcaseout_convert_bookmarks"     "Convert Bookmarks to Shots")
(ui-string "mo_showcaseout_convert_env"           "Match Environment if Available")
(ui-string "mo_showcaseout_ground_plane"          "Ground Plane")
(ui-string "mo_showcaseout_environment"           "Showcase Environment")
(ui-string "mo_showcaseout_center_env"            "Center Environment")


(ui-string "showcaseout.conversionsetting.all_purpose"    "All-Purpose")
(ui-string "showcaseout.conversionsetting.large_parts"    "Large Parts")
(ui-string "showcaseout.conversionsetting.small_details"  "Small Details")
(ui-string "showcaseout.conversionsetting.LOD_Low"        "LOD-Low")
(ui-string "showcaseout.conversionsetting.LOD_Medium"     "LOD-Medium")
(ui-string "showcaseout.conversionsetting.LOD_High"       "LOD-High")

(ui-string "showcaseout.geometry.all"           "All")
(ui-string "showcaseout.geometry.selected"      "Selected")

(ui-string "showcaseout.visualstyle.real_no_shadows"    "Realistic - No Shadows")
(ui-string "showcaseout.visualstyle.real_ao_shadows"    "Realistic - AO Shadows")
(ui-string "showcaseout.visualstyle.real_shadows"       "Realistic - Shadows")
(ui-string "showcaseout.visualstyle.real_both_shadows"  "Realistic - Both Shadows")
(ui-string "showcaseout.visualstyle.real_ray_trace"     "Realistic - Ray Tracing")
(ui-string "showcaseout.visualstyle.abs_flat_color"     "Abstract - Flat Color")
(ui-string "showcaseout.visualstyle.abs_toon_color"     "Abstract - Toon Color")
(ui-string "showcaseout.visualstyle.abs_shaded_tex"     "Abstract - Shaded Texture")
(ui-string "showcaseout.visualstyle.abs_tech"           "Abstract - Tech")
(ui-string "showcaseout.visualstyle.abs_real_edges"     "Abstract - Real with Edges")
(ui-string "showcaseout.visualstyle.abs_ao_edges"       "Abstract - Ambient Shadows with Edges")

(ui-string "showcaseout.groundplane.bottom"     "Bottom of Model")
(ui-string "showcaseout.groundplane.alias"      "Use Alias Environment")

(ui-string "showcaseout.environment.bpblackwhite"   "BP Black-White(Scale Independent)")
(ui-string "showcaseout.environment.bpgeneric"      "BP Generic (Scale Independent)")
(ui-string "showcaseout.environment.bpgradient"     "BP Gradient (Scale Independent)")
(ui-string "showcaseout.environment.stuttgart"      "Stuttgart (Car Size)")
(ui-string "showcaseout.environment.generic"        "Generic (Car Size)")
(ui-string "showcaseout.environment.countryroad"    "Country Road (Car Size)")
(ui-string "showcaseout.environment.gypsumcrater"   "Daylight Gypsum Crater (Car Size)")
(ui-string "showcaseout.environment.desertdawn"     "Desert Dawn Road (Car Size)")
(ui-string "showcaseout.environment.drylakebed"     "Dry Lake Bed (Car Size)")
(ui-string "showcaseout.environment.docks"          "Docks (Car Size)")
(ui-string "showcaseout.environment.exhibithall"    "Exhibit Hall (Car Size)")
(ui-string "showcaseout.environment.nightplaza"     "Night Plaza (Car Size)")
(ui-string "showcaseout.environment.nightstreet"    "Night Street (Car Size)")
(ui-string "showcaseout.environment.sepulveda"      "Sepulveda (Car Size)")
(ui-string "showcaseout.environment.sepulveda"      "Sepulveda (Car Size)")
(ui-string "showcaseout.environment.oldwarehouse"   "Old Warehouse (Car Size)")
(ui-string "showcaseout.environment.grassfield"     "Grass Field (Building Size)")
(ui-string "showcaseout.environment.whiteroom"      "White Room (Building Size)")
(ui-string "showcaseout.environment.blackroom"      "Black Room (Building Size)")

(ui-editor "showcaseout.options"                
	
	(list 'title 'showcaseout.name)

	(list 'symbols  'mo_showcaseout_geometry
					'mo_showcaseout_bake_ao   'mo_showcaseout_replace_materials
					'mo_showcaseout_replace_material_map 'mo_showcaseout_visual_style
					'mo_showcaseout_convert_bookmarks 'mo_showcaseout_convert_env
					'mo_showcaseout_center_env 'mo_showcaseout_ground_plane
					'mo_showcaseout_environment 'mo_showcaseout_tess_setting
	)

	(ui-popup-widget "mo_showcaseout_tess_setting"
	    (ui-choice "showcaseout.conversionsetting.all_purpose"    0)
		(ui-choice "showcaseout.conversionsetting.large_parts"    1)
		(ui-choice "showcaseout.conversionsetting.small_details"  2)
		(ui-choice "showcaseout.conversionsetting.LOD_Low"        3)
		(ui-choice "showcaseout.conversionsetting.LOD_Medium"     4)
		(ui-choice "showcaseout.conversionsetting.LOD_High"       5)
	)

	(ui-radio-widget "mo_showcaseout_geometry"    
		(ui-choice "showcaseout.geometry.all"       'MO_SAVE_ALL_AS)
		(ui-choice "showcaseout.geometry.selected"  'MO_SAVE_ACTIVE_AS)
	)

	(ui-tick-widget "mo_showcaseout_bake_ao" )
	(ui-tick-widget "mo_showcaseout_replace_materials" 
	       (list 'rebuild #t)
    )

	(ui-string-widget "mo_showcaseout_replace_material_map"
	    
		(list 'enabled (ui-eq "mo_showcaseout_replace_materials" 1))
	    (list 'function             "MaterialReplacementMapPath")
		(list 'functionlabel        "Browse...")
	)

	(ui-popup-widget "mo_showcaseout_visual_style"
	    (ui-choice "showcaseout.visualstyle.real_no_shadows"    0)
		(ui-choice "showcaseout.visualstyle.real_ao_shadows"    1)
		(ui-choice "showcaseout.visualstyle.real_shadows"       2)
		(ui-choice "showcaseout.visualstyle.real_both_shadows"  3)
		(ui-choice "showcaseout.visualstyle.real_ray_trace"     4)
		(ui-choice "showcaseout.visualstyle.abs_flat_color"     5)
		(ui-choice "showcaseout.visualstyle.abs_toon_color"     6)
		(ui-choice "showcaseout.visualstyle.abs_shaded_tex"     7)
		(ui-choice "showcaseout.visualstyle.abs_tech"           8)
		(ui-choice "showcaseout.visualstyle.abs_real_edges"     9)
		(ui-choice "showcaseout.visualstyle.abs_ao_edges"       10)
	)

	(ui-tick-widget "mo_showcaseout_convert_bookmarks" )
	(ui-tick-widget "mo_showcaseout_convert_env" )
	
	(ui-popup-widget "mo_showcaseout_environment"

	    (ui-choice "showcaseout.environment.bpblackwhite"     0)
	    (ui-choice "showcaseout.environment.bpgeneric"        1)
	    (ui-choice "showcaseout.environment.bpgradient"       2)
	    (ui-choice "showcaseout.environment.stuttgart"        3)
		(ui-choice "showcaseout.environment.generic"          4)
		(ui-choice "showcaseout.environment.countryroad"      5)
		(ui-choice "showcaseout.environment.gypsumcrater"     6)
		(ui-choice "showcaseout.environment.desertdawn"       7)
		(ui-choice "showcaseout.environment.drylakebed"       8)
		(ui-choice "showcaseout.environment.docks"            9)
		(ui-choice "showcaseout.environment.exhibithall"     10)
		(ui-choice "showcaseout.environment.nightplaza"      11)
		(ui-choice "showcaseout.environment.nightstreet"     12)
		(ui-choice "showcaseout.environment.sepulveda"       13)
		(ui-choice "showcaseout.environment.oldwarehouse"    14)
		(ui-choice "showcaseout.environment.grassfield"      15)
		(ui-choice "showcaseout.environment.whiteroom"       16)
		(ui-choice "showcaseout.environment.blackroom"       17)
	)

    (ui-popup-widget "mo_showcaseout_ground_plane"
	    (ui-choice "showcaseout.groundplane.bottom"    0)
		(ui-choice "showcaseout.groundplane.alias"     1)
	)

	(ui-tick-widget "mo_showcaseout_center_env" )

	(list 'buttons 'Reset 'Save 'Exit 'Go)
)
