;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1996, Alias|Wavefront.                            ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias|Wavefront.  and are	     ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias|Wavefront.	     ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; Preset Grid Spacing Options Box
;;;

(ui-string "setgrid.name"		"Preset Grid Options")
(ui-string "setgrid.type.all"		"All")
(ui-string "setgrid.type.current"	"Current")
(ui-string "mo_set_grid_all_windows"	"Windows")
(ui-string "mo_set_grid_value"		"Grid Spacing")
;; the following symbols are common with interactive grid setting option
(ui-string "mo_grddots"                 "Subdivisions")
(ui-string "mo_grid_labels"             "Labels")
(ui-string "mo_grid_corner_perspective_gnomen"	    "Corner Perspective Gnomon")
(ui-string "mo_persp_grid_extent"		"Perspective Grid Extent")
(ui-string "mo_grid_label_fontsize"         "Label Font Size")
(ui-string "mo_grid_label_font_override"    "Label Font Properties")

(ui-editor "setgrid.options"
	   (list 'title  'setgrid.name)
	   
	   (list 'symbols   
		 'mo_set_grid_value 
		 'mo_set_grid_all_windows
		 'mo_grddots
		 'mo_grid_labels
		 'mo_grid_label_fontsize
 		 'mo_grid_label_font_override
		 'mo_grid_corner_perspective_gnomen
		 'mo_persp_grid_extent
		 )
	   (list 'buttons 'Reset 'Save 'Exit 'Go)
	   
	   (list 'go_option_function "InitPerspectiveGrid")

	   (ui-radio-widget 'mo_set_grid_all_windows			    
			    (ui-choice 'setgrid.type.all #t)
			    (ui-choice 'setgrid.type.current #f)
			    )


	   (ui-distance-widget "mo_set_grid_value"    
			       (list "rebuild")
			       (list 'precision "%f10.4")
			       (list 'range 0.0001 10000.0)
			       )
	   (ui-blank-widget)
	   (ui-separator-widget)

	   (ui-integer-widget "mo_grddots"     
			      (list 'range 1 10000)
			      )

	   (ui-distance-widget "mo_persp_grid_extent" 
		   (list 'precision "%f8.2")
		   (list 'range 1.0 1000000.0)
		)
	   (ui-tick-widget "mo_grid_corner_perspective_gnomen")

	(ui-tick-widget "mo_grid_labels"
		 '(rebuild #t)
	)					

	(ui-popup-widget "mo_grid_label_font_override"
					 (ui-choice "Default" #f)
					 (ui-choice "Custom" #t)
					 (list 'enabled (ui-ne "mo_grid_labels" 0) )
					 '(rebuild #t)
				)

    ;  Label font size selection 
	;  (only available if labels on and font override on)
	;  Note: identical list is in mo_set_grdspace_options.o.scm
	(ui-popup-widget "mo_grid_label_fontsize"
		 (ui-choice "72" 72)
		 (ui-choice "48" 48)
		 (ui-choice "36" 36)
		 (ui-choice "28" 28)
		 (ui-choice "26" 26)
		 (ui-choice "24" 24)
		 (ui-choice "22" 22)
		 (ui-choice "20" 20)
		 (ui-choice "18" 18)
		 (ui-choice "16" 16)
		 (ui-choice "14" 14)
		 (ui-choice "12" 12)
		 (ui-choice "11" 11)
		 (ui-choice "10" 10)
		 (ui-choice "8" 8)
		 (list 'enabled 
			   (ui-and (ui-ne "mo_grid_labels" 0) (ui-ne "mo_grid_label_font_override" 0)))
	)
					
)










