
;;; Export to Illustrator Options
;;;

(ui-string "savetoillustrator.name"                 "Export to Illustrator Options")

(ui-string "mo_savetoillustrator_geom"              "Geometry")
(ui-string "mo_savetoillustrator_active"            "Active")
(ui-string "mo_savetoillustrator_all"               "All")
(ui-string "mo_savetoillustrator_max_x"             "Horizontal Size")
(ui-string "mo_savetoillustrator_max_y"             "Vertical Size")
(ui-string "mo_savetoillustrator_scale_from"        "Scale")
(ui-string "mo_savetoillustrator_scale_to"          "To")
(ui-string "mo_savetoillustrator_tol_crv_fit"       "Curve Fit distance")

(define minimum-tolerance 0.00005)

(ui-editor "savetoillustrator.options"

	(list 'title 'savetoillustrator.name)

	(list 'symbols  'mo_savetoillustrator_max_x
                    'mo_savetoillustrator_max_y 
                    'mo_savetoillustrator_scale_from
                    'mo_savetoillustrator_scale_to
                    'mo_savetoillustrator_tol_crv_fit)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

    (ui-radio-widget 'mo_savetoillustrator_geom
        (list 'rebuild #t)
        (ui-choice 'mo_savetoillustrator_active  1)
        (ui-choice 'mo_savetoillustrator_all     2)
    )

    (ui-double-widget      "mo_savetoillustrator_max_x"
        (list 'enabled (ui-eq "mo_current_cam_is_persp" 1 ))
		(list 'range 32 4096)
		(list 'slider_range 32 4096)
		(list 'precision "%f6.0")
	)

    (ui-double-widget      "mo_savetoillustrator_max_y"
        (list 'enabled (ui-eq "mo_current_cam_is_persp" 1 ))
		(list 'range 32 4096)
		(list 'slider_range 32 4096)
		(list 'precision "%f6.0")
	)

    (ui-double-widget      "mo_savetoillustrator_scale_from"
        (list 'enabled (ui-ne "mo_current_cam_is_persp" 1 ))
		(list 'range 1 50)
		(list 'slider_range 1 100)
		(list 'precision "%f6.0")
	)

    (ui-double-widget      "mo_savetoillustrator_scale_to"
        (list 'enabled (ui-ne "mo_current_cam_is_persp" 1 ))
		(list 'range 1 50)
		(list 'slider_range 1 100)
		(list 'precision "%f6.0")
    )

	(ui-group-widget 
			(list 'title "Fitting")
	)

	(ui-distance-widget "mo_savetoillustrator_tol_crv_fit" 
		(list 'range 'min minimum-tolerance)
		(list 'precision "%f8.5") 
    )
)
