
;;; Export Screen Options
;;;

(ui-string "savescreen.name"                 "Export Screen Options")

(ui-string "mo_savescreen_file_type"         "File Type")

(ui-string "savescreen.filetype.jpeg"        "jpeg")
(ui-string "savescreen.filetype.tiff"        "tiff")
(ui-string "savescreen.filetype.png"         "png")
(if (ui-symbol-true	"using_nt_os")
 ( begin
   (ui-string "savescreen.filetype.bmp24"       "bmp(24bits)")
   (ui-string "savescreen.filetype.bmp"         "bmp(32bits)")
 )	 
)	 
(ui-string "mo_savescreen_q_factor"			 " ")
(ui-string "mo_savescreen_q_level"			 "Quality Level")

(ui-string "savescreen.max"					"MAXIMUM")
(ui-string "savescreen.high"				"HIGH")
(ui-string "savescreen.med"					"MEDIUM")
(ui-string "savescreen.low"					"LOW")

(ui-editor "savescreen.options"

	(list 'title 'savescreen.name)

	(list 'symbols 	'mo_savescreen_file_type 
					'mo_savescreen_q_factor 
					'mo_savescreen_q_level )

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_savescreen_file_type"
		(list 'rebuild #t)
		(ui-choice "savescreen.filetype.jpeg"     'MO_FILETYPE_JPEG)
		(ui-choice "savescreen.filetype.tiff"     'MO_FILETYPE_TIFF)
		(ui-choice "savescreen.filetype.png"      'MO_FILETYPE_PNG)
		(if (ui-symbol-true	"using_nt_os")
		 ( begin
		  (ui-choice "savescreen.filetype.bmp24"    'MO_FILETYPE_BMP24)
		  (ui-choice "savescreen.filetype.bmp"      'MO_FILETYPE_BMP)
		 )
	   )		
	)
	
	(ui-popup-widget "mo_savescreen_q_level"
		(list 'rebuild #t)
		(list 'enabled
				(ui-eq "mo_savescreen_file_type" 'MO_FILETYPE_JPEG)
		)	
		(ui-choice "savescreen.max"    'MO_Q_MAX
			(list 'assign (ui-eq "mo_savescreen_q_level" 'MO_Q_MAX)
					'mo_savescreen_q_factor 100)
		)
		(ui-choice "savescreen.high"    'MO_Q_HIGH
			(list 'assign (ui-eq "mo_savescreen_q_level" 'MO_Q_HIGH)
					'mo_savescreen_q_factor 90)
		)
		(ui-choice "savescreen.med"    'MO_Q_MED 
			(list 'assign (ui-eq "mo_savescreen_q_level" 'MO_Q_MED)
					'mo_savescreen_q_factor 75)
		)
		(ui-choice "savescreen.low"    'MO_Q_LOW 
			(list 'assign (ui-eq "mo_savescreen_q_level" 'MO_Q_LOW)
					'mo_savescreen_q_factor 60)
		)	
	)
	(ui-integer-widget      "mo_savescreen_q_factor"
		(list 'rebuild #t)
		(list 'enabled
				(ui-eq "mo_savescreen_file_type" 'MO_FILETYPE_JPEG)
		)		
		(list 'assign (ui-eq 'mo_savescreen_q_factor 100) 
				'mo_savescreen_q_level 'MO_Q_MAX)
		(list 'assign (ui-lt 'mo_savescreen_q_factor 100) 
				'mo_savescreen_q_level 'MO_Q_HIGH)
		(list 'assign (ui-lt 'mo_savescreen_q_factor 90) 
				'mo_savescreen_q_level 'MO_Q_MED)
		(list 'assign (ui-lt 'mo_savescreen_q_factor 60) 
				'mo_savescreen_q_level 'MO_Q_LOW)		        
		(list 'range 1 100)
	)
)
