
;;; Export Current Window Options
;;;

(ui-string "savecurrentwindow.name"                 "Export Current Window Options")

(ui-string "mo_savecurrentwindow_file_type"         "Image File Type")

(ui-string "savecurrentwindow.filetype.jpeg"        "jpeg")
(ui-string "savecurrentwindow.filetype.tiff"        "tiff")
(ui-string "savecurrentwindow.filetype.tiff4"       "tiff with alpha")
(ui-string "savecurrentwindow.filetype.png"         "png")
(ui-string "savecurrentwindow.filetype.png4"        "png with alpha")
(if (ui-symbol-true	"using_nt_os")
	( begin
		(ui-string "savecurrentwindow.filetype.bmp24"       "bmp(24bits)")
		(ui-string "savecurrentwindow.filetype.bmp"         "bmp(32bits)")
	)
)		
(ui-string "mo_savecurrentwindow_limit_size"        "Specify Image Size")
(ui-string "mo_savecurrentwindow_set_aspect"        "Maintain Aspect Ratio")
(ui-string "mo_savecurrentwindow_max_x"             "Horizontal Size")
(ui-string "mo_savecurrentwindow_max_y"             "Vertical Size")
(ui-string "mo_savecurrentwindow_q_factor"          " ")
(ui-string "mo_savecurrentwindow_q_level"           "Quality Level")

(ui-string "savecurrentwindow.max"					"MAXIMUM")
(ui-string "savecurrentwindow.high"					"HIGH")
(ui-string "savecurrentwindow.med"					"MEDIUM")
(ui-string "savecurrentwindow.low"					"LOW")

(ui-string "mo_savecurrentwindow_AA_on"				"Enable Anti-Alias")


(ui-editor "savecurrentwindow.options"

	(list 'title 'savecurrentwindow.name)

	(list 'symbols 	'mo_savecurrentwindow_file_type
                    'mo_savecurrentwindow_limit_size
                    'mo_savecurrentwindow_set_aspect
                    'mo_savecurrentwindow_aspect
                    'mo_savecurrentwindow_max_x
                    'mo_savecurrentwindow_max_y 
                    'mo_savecurrentwindow_q_factor
                    'mo_savecurrentwindow_q_level )

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_savecurrentwindow_file_type"
		(list 'rebuild #t)
		(ui-choice "savecurrentwindow.filetype.tiff"     'MO_FILETYPE_TIFF)
		(ui-choice "savecurrentwindow.filetype.tiff4"    'MO_FILETYPE_TIFF4)
		(ui-choice "savecurrentwindow.filetype.png"      'MO_FILETYPE_PNG)
		(ui-choice "savecurrentwindow.filetype.png4"     'MO_FILETYPE_PNG4)
		(ui-choice "savecurrentwindow.filetype.jpeg"     'MO_FILETYPE_JPEG)
		
		(if (ui-symbol-true	"using_nt_os")
		 ( begin
			(ui-choice "savecurrentwindow.filetype.bmp24"    'MO_FILETYPE_BMP24)
			(ui-choice "savecurrentwindow.filetype.bmp"      'MO_FILETYPE_BMP)
		 )	
		)
	)

    (ui-tick-widget			"mo_savecurrentwindow_limit_size"
        (list 'rebuild #t)
    )

    (ui-tick-widget			"mo_savecurrentwindow_set_aspect"
    	(list 'enabled
                (ui-eq "mo_savecurrentwindow_limit_size" #t)
		)
		(list 'assign (ui-eq 'mo_savecurrentwindow_set_aspect #t)
				'mo_savecurrentwindow_aspect
						(ui-eval "awWindowsUIIsCurrentAspectRatio")
		)
		(list 'assign (ui-eq 'mo_savecurrentwindow_set_aspect #t)
				'mo_savecurrentwindow_max_y
						(ui-div 'mo_savecurrentwindow_max_x 'mo_savecurrentwindow_aspect)
		)
    )
    
    (ui-double-widget      "mo_savecurrentwindow_max_x"
		(list 'enabled
                (ui-eq "mo_savecurrentwindow_limit_size" #t)
		)

		(list 'assign (ui-eq 'mo_savecurrentwindow_set_aspect #t)
				'mo_savecurrentwindow_max_y
						(ui-div 'mo_savecurrentwindow_max_x 'mo_savecurrentwindow_aspect)
		)
		(list 'range 8)
		(list 'slider_range 32 4096)
		(list 'precision "%f6.0")
	)

    (ui-double-widget      "mo_savecurrentwindow_max_y"
		(list 'enabled
                (ui-eq "mo_savecurrentwindow_limit_size" #t)
		)

		(list 'assign (ui-eq 'mo_savecurrentwindow_set_aspect #t)
				'mo_savecurrentwindow_max_x
						(ui-mul 'mo_savecurrentwindow_max_y 'mo_savecurrentwindow_aspect)
		)
		(list 'range 8)
		(list 'slider_range 32 4096)
		(list 'precision "%f6.0")
	)
		
	(ui-popup-widget "mo_savecurrentwindow_q_level"
		(list 'rebuild #t)
		(list 'enabled
			(ui-eq "mo_savecurrentwindow_file_type" 'MO_FILETYPE_JPEG)
		)	        
		(ui-choice "savecurrentwindow.max"    'MO_Q_MAX
			(list 'assign (ui-eq "mo_savecurrentwindow_q_level" 'MO_Q_MAX)
					'mo_savecurrentwindow_q_factor 100)
		)
		(ui-choice "savecurrentwindow.high"    'MO_Q_HIGH
			(list 'assign (ui-eq "mo_savecurrentwindow_q_level" 'MO_Q_HIGH)
					'mo_savecurrentwindow_q_factor 90)
		)
		(ui-choice "savecurrentwindow.med"    'MO_Q_MED 
			(list 'assign (ui-eq "mo_savecurrentwindow_q_level" 'MO_Q_MED)
					'mo_savecurrentwindow_q_factor 75)
		)
		(ui-choice "savecurrentwindow.low"    'MO_Q_LOW 
			(list 'assign (ui-eq "mo_savecurrentwindow_q_level" 'MO_Q_LOW)
					'mo_savecurrentwindow_q_factor 60)
		)	
	)
	(ui-integer-widget      "mo_savecurrentwindow_q_factor"
		(list 'rebuild #t)
		(list 'enabled
			(ui-eq "mo_savecurrentwindow_file_type" 'MO_FILETYPE_JPEG)
		)
		(list 'assign (ui-eq 'mo_savecurrentwindow_q_factor 100) 
				'mo_savecurrentwindow_q_level 'MO_Q_MAX)
		(list 'assign (ui-lt 'mo_savecurrentwindow_q_factor 100) 
				'mo_savecurrentwindow_q_level 'MO_Q_HIGH)
		(list 'assign (ui-lt 'mo_savecurrentwindow_q_factor 90) 
				'mo_savecurrentwindow_q_level 'MO_Q_MED)
		(list 'assign (ui-lt 'mo_savecurrentwindow_q_factor 60) 
				'mo_savecurrentwindow_q_level 'MO_Q_LOW)		        
		(list 'range 1 100)
	)
	
	(ui-tick-widget			"mo_savecurrentwindow_AA_on" )
)
