;
; create the file menu
;

(ui-function "al_ref_menu_ImportReference"
	(list 'command	"ImportReference" )
	(list 'label_string	"Import" )
	(list 'attribute_string	"import" )
	(list 'option_editor        "Modeling/mo_import_reference_options.o.scm"
                                'mo_importRef.options)
)

(ui-function "al_ref_menu_ReimportSelectedReferences"
    (list 'command  "ReimportSelectedReferences" )
    (list 'label_string "Re-Tessellate Files" )
    (list 'attribute_string "reimport" )
    (list 'option_editor        "Modeling/mo_retessellate_reference_options.o.scm"
                                'mo_retessellateRef.options)
)

(ui-function "al_ref_menu_ReimportAllReferences"
    (list 'command  "UpdateAllReferences" )
    (list 'label_string "Update All" )
    (list 'attribute_string "update" )
)

(ui-function "al_ref_menu_TranslateReference"
    (list 'command  "ConvertReference" )
    (list 'label_string "Batch Translate" )
    (list 'attribute_string "translate" )
    (list 'option_editor        "Modeling/mo_convert_reference_options.o.scm"
                                'mo_convertRef.options)
    )

(ui-symbol "ref_cancel_all"	#f)

(ui-function "al_ref_menu_CancelActiveTranslations"
    (list 'command  "CancelActiveTranslations" )
    (list 'label_string "Cancel All" )
    (list 'attribute_string "canimprt" )
    (list 'active (ui-eq "ref_cancel_all" #t))
)

(ui-function "al_ref_menu_SetReferenceDirectories"
    (list 'command "ReferenceManager_setDirectories")
    (list 'label_string "Set Reference Directories")
    (list 'attribute_string "refdirs")
)

(ui-function "al_ref_menu_PackReference"
	(list 'command	"PackReference" )
	(list 'label_string	"Pack" )
	(list 'attribute_string	"pack" )
	)

(ui-function "al_ref_menu_ImportRefFromVault"
	(list 'command	"VaultImportReference" )
	(list 'label_string	"Import From Vault..." )
	(list 'attribute_string	"ImportFromVault" )
	(list 'symbols 	
		'mo_vault_checkout_on_open
		'mo_vault_connected
		'mo_vault_folder_id
	)
	(list 'active (ui-eq "mo_vault_connected" #t))
    (list 'rebuild #t)
	)

(ui-symbol "al_ref_file_menu" 1)

(ui-menu "al_ref_file_menu"
    (list 'label_string "File")
     )

(ui-menu-add-entry "al_ref_file_menu" 'al_ref_menu_ImportReference)
(ui-menu-add-entry "al_ref_file_menu" 'al_ref_menu_ReimportSelectedReferences)
(ui-menu-add-entry "al_ref_file_menu" 'al_ref_menu_ReimportAllReferences)
(ui-menu-add-entry "al_ref_file_menu" 'al_ref_menu_TranslateReference)
(ui-menu-add-entry "al_ref_file_menu" 'al_ref_menu_CancelActiveTranslations)
(ui-menu-add-entry "al_ref_file_menu" 'al_ref_menu_SetReferenceDirectories)
(ui-menu-add-entry "al_ref_file_menu" 'al_ref_menu_PackReference)

(if (ui-symbol-true "mo_vault_enabled")
		(ui-menu-add-separator "al_ref_file_menu")
	)
(if (ui-symbol-true "mo_vault_enabled")
    	(ui-menu-add-entry "al_ref_file_menu"      "al_ref_menu_ImportRefFromVault")
	)

;
; create the edit menu
;

(ui-function "al_ref_menu_DuplicateReference"
    (list 'command              "DuplicateReference")
    (list 'label_string         "Promote Geometry")
    (list 'attribute_string     "promote")
    )

(ui-function "al_ref_menu_DuplicateRefShader"
    (list 'command              "DuplicateRefShader")
    (list 'label_string         "Promote Shader")
    (list 'attribute_string     "promote shader")
    )

(ui-function "al_ref_menu_RetessellateReference"
	(list 'command				"RetessellateReference")
	(list 'label_string 		"Re-Tessellate Objects")
	(list 'attribute_string 	"retess")
	(list 'option_editor 		"Modeling/mo_retess_reference_options.o.scm"
								'mo_retessRef.options)
    )

(ui-function "al_ref_menu_DeleteAlternative"
    (list 'command              "DeleteAlternative")
    (list 'label_string         "Remove Alternative")
    (list 'attribute_string     "del alt")
    )

(ui-function "al_ref_menu_RemoveReference"
	(list 'command	"RemoveReference" )
	(list 'label_string	"Remove File" )
	(list 'attribute_string	"remove" )
	)

(ui-function "al_ref_menu_CreateAlternative"
    (list 'command              "CreateAlternative")
    (list 'label_string         "New Alternative")
    (list 'attribute_string     "new alt")
    )

(ui-function "al_ref_menu_DuplicateAlternative"
    (list 'command              "DuplicateAlternative")
    (list 'label_string         "Duplicate Alternative")
    (list 'attribute_string     "dup alt")
    )




(ui-symbol "al_ref_edit_menu" 1)

(ui-menu "al_ref_edit_menu"
    (list 'label_string "Edit")
    )

(ui-menu-add-entry "al_ref_edit_menu" 'al_ref_menu_RemoveReference)
(ui-menu-add-entry "al_ref_edit_menu" 'al_ref_menu_DeleteAlternative)
(ui-menu-add-separator "al_ref_edit_menu")
(ui-menu-add-entry "al_ref_edit_menu" 'al_ref_menu_CreateAlternative)
(ui-menu-add-entry "al_ref_edit_menu" 'al_ref_menu_DuplicateAlternative)
(ui-menu-add-separator "al_ref_edit_menu")
(ui-menu-add-entry "al_ref_edit_menu" 'al_ref_menu_DuplicateReference)
(ui-menu-add-entry "al_ref_edit_menu" 'al_ref_menu_DuplicateRefShader)
(ui-menu-add-entry "al_ref_edit_menu" 'al_ref_menu_RetessellateReference)


; create the view menu
;

(ui-function "al_ref_menu_ShowOnlyRefFiles"
    (list 'command              "ShowOnlyReferencesInRefMan")
    (list 'label_string         "Reference Files")
    (list 'attribute_string     "show ref")
    (list 'tick     		(ui-eq 'reference_manager_view 0))
    )

(ui-function "al_ref_menu_ShowOnlyAlternatives"
    (list 'command              "ShowOnlyAlternativesInRefMan")
    (list 'label_string         "Alternatives")
    (list 'attribute_string     "show alt")
    (list 'tick     		(ui-eq 'reference_manager_view 1))
    )

(ui-function "al_ref_menu_ShowBoth"
    (list 'command              "ShowSplitViewInRefMan")
    (list 'label_string         "Both")
    (list 'attribute_string     "show both")
    (list 'tick     		(ui-eq 'reference_manager_view 2))
    )

(ui-function "al_ref_menu_ExpandCollapse"
    (list 'command              "ExpandCollapseRefManHierarchy")
    (list 'label_string         "+/- All")
    (list 'attribute_string     "expand / collapse")
    )


(ui-symbol "al_ref_view_menu" 1)

(ui-menu "al_ref_view_menu"
    (list 'label_string "View")
    )

(ui-menu-add-entry "al_ref_view_menu" 'al_ref_menu_ShowOnlyRefFiles)
(ui-menu-add-entry "al_ref_view_menu" 'al_ref_menu_ShowOnlyAlternatives)
(ui-menu-add-entry "al_ref_view_menu" 'al_ref_menu_ShowBoth)
(ui-menu-add-separator "al_ref_view_menu")
(ui-menu-add-entry "al_ref_view_menu" 'al_ref_menu_ExpandCollapse)

; create the filter menu
;

(ui-function "al_ref_menu_filterRefSurfaces"
    (list 'command              "FilterReferenceSurfaces")
    (list 'label_string         "Surfaces")
    (list 'attribute_string     "surf")
	(list 'tick     		(ui-eq 'reference_manager_filter_surfaces 0))
    )

(ui-function "al_ref_menu_filterRefCurves"
    (list 'command              "FilterReferenceCurves")
    (list 'label_string         "Curves")
    (list 'attribute_string     "crv")
	(list 'tick     		(ui-eq 'reference_manager_filter_curves 0))
    )

(ui-function "al_ref_menu_filterRefMeshes"
    (list 'command              "FilterReferenceMeshes")
    (list 'label_string         "Meshes")
    (list 'attribute_string     "mesh")
	(list 'tick     		(ui-eq 'reference_manager_filter_meshes 0))
    )

(ui-function "al_ref_menu_filterRefShells"
    (list 'command              "FilterReferenceShells")
    (list 'label_string         "Shells")
    (list 'attribute_string     "shell")
	(list 'tick     		(ui-eq 'reference_manager_filter_shells 0))
    )

(ui-symbol "al_ref_filter_menu" 1)

(ui-menu "al_ref_filter_menu"
    (list 'label_string "Filter")
    )

(ui-menu-add-entry "al_ref_filter_menu" 'al_ref_menu_filterRefSurfaces)
(ui-menu-add-entry "al_ref_filter_menu" 'al_ref_menu_filterRefCurves)
(ui-menu-add-entry "al_ref_filter_menu" 'al_ref_menu_filterRefMeshes)
(ui-menu-add-entry "al_ref_filter_menu" 'al_ref_menu_filterRefShells)