;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; (C) Copyright 2009 by Autodesk, Inc. All Rights Reserved. By using
; this code,  you  are  agreeing  to the terms and conditions of the
; License  Agreement  included  in  the documentation for this code.
; AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
; CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
; IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
; DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
; DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
;
; Use, duplication,  or disclosure by the U.S. Government is subject
; to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
; Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
; (Rights  in Technical Data and Computer Software),  as applicable.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Promote Section Option Box
;;;

(ui-string "mo_xsection_promote.name"              "Promote Options")

(ui-string "mo_xsection_promote_type"          "Sections type")
(ui-string "xsection_promote_type.sec_data"    "Section data")
(ui-string "xsection_promote_type.nurbs"       "NURBS")

(ui-string "mo_xsection_sort_sections"         "Sort sections")
(ui-string "mo_xsection_merge_sections"        "Merge sections")
(ui-string "mo_xsection_promote_tol"		   "Tolerance")

(ui-editor "mo_xsection_promote.options"               
	
	(list 'title 'mo_xsection_promote.name)

	(list 'symbols 	"mo_xsection_promote_type"
					"mo_xsection_sort_sections"
                    "mo_xsection_merge_sections"
                    "mo_xsection_promote_tol"
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-popup-widget "mo_xsection_promote_type"
		(list 'rebuild #t)
		(ui-choice "xsection_promote_type.sec_data"	0)
		(ui-choice "xsection_promote_type.nurbs"	1)
	)

    (ui-tick-widget "mo_xsection_sort_sections")
    
    (ui-tick-widget "mo_xsection_merge_sections"
					(list 'enabled (ui-eq "mo_xsection_promote_type" 0))
    )
                    
    (ui-distance-widget "mo_xsection_promote_tol"
        (list 'precision "%8.5")
        (list 'range 0.0001 100.0)
        (list 'slider_range 0.001 10.0)
    )                    
)
