;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Projective texture "primitives" Option Box
;;;

;; Option box title.
(ui-string "projtxt_name"             "Projection Primitive Options")

;; Projection type option strings
(ui-string "projtxt_projtype"				"Projection Type")
(ui-string "projtxt_projtype.planar"		"Planar")
(ui-string "projtxt_projtype.concentric"    "Concentric")
(ui-string "projtxt_projtype.triplanar"     "Triplanar")
(ui-string "projtxt_projtype.spherical"     "Spherical")
(ui-string "projtxt_projtype.ball"			"Ball")
(ui-string "projtxt_projtype.cylindrical"   "Cylindrical")
(ui-string "projtxt_projtype.cubic"			"Cubic")
(ui-string "projtxt_projtype.camera"		"Camera")

;; Editor popup option
(ui-string "projtxt_editOnCreate"		"Display editor")

;; Planar options
(ui-string "projtxt_planarCenter" "Center pivot on grid")

(ui-string "projtxt_snapBox" "Override magnet with B-box snap")
(ui-string "projtxt_snap_none" "OFF")
(ui-string "projtxt_snap_leaf" "DAG OBJECT(S)")
(ui-string "projtxt_snap_active" "SELECTED DAG(S)")
(ui-string "projtxt_snapactive_all" "SELECTION LIST")
(ui-string "projtxt_drawBox" "Draw snap box")
(ui-string "projtxt_uniformSnap" "Uniform scale")

(ui-string "projtxt_cameraSnap" "Snap to camera")

(ui-editor "projtxt.options"
		  
    (list 'title 'projtxt_name)	   
	(list 'symbols 'projtxt_ptype, 'projtxt_editOnCreate 'projtxt_planarCenter
		  'projtxt_snapBox 'projtxt_drawBox 'projtxt_cameraSnap
		  'projtxt_uniformSnap)

    (list 'buttons 'Reset 'Save 'Exit 'Go)

    (ui-separator-widget)

	;; Projection type option
	;(ui-popup-widget "projtxt_projtype"
	;	(ui-choice "projtxt_projtype.planar" 'PTXT_PLANAR)
	;	(ui-choice "projtxt_projtype.concentric" 'PTXT_CONCENTRIC)
	;	(ui-choice "projtxt_projtype.triplanar" 'PTXT_TRIPLANAR)
	;	(ui-choice "projtxt_projtype.spherical" 'PTXT_SPHERICAL)
	;	(ui-choice "projtxt_projtype.ball" 'PTXT_BALL)
	;	(ui-choice "projtxt_projtype.cylindrical" 'PTXT_CYLINDRICAL)
	;	(ui-choice "projtxt_projtype.cubic" 'PTXT_CUBIC)
	;	(ui-choice "projtxt_projtype.camera" 'PTXT_CAMERA)
	;)

	;; Editor popup option
	(ui-tick-widget "projtxt_editOnCreate")

	;; Camera snap option
	(ui-tick-widget "projtxt_cameraSnap"
		(list 'enabled (ui-eq "projtxt_projtype" 'PTXT_CAMERA))
		 '(rebuild #t)
	)

	;; Planar option -- OFF for now
	;;(ui-tick-widget "projtxt_planarCenter"
	;;	(list 'enabled (ui-eq "projtxt_projtype" 'PTXT_PLANAR))
	;;)

	;; BBox snap, only if not creating camera texture
	(ui-popup-widget "projtxt_snapBox"
		 (list 'enabled (ui-ne "projtxt_projtype" 'PTXT_CAMERA))

		 (ui-choice "projtxt_snap_none" 0)
		 (ui-choice "projtxt_snap_leaf" 1)
		 (ui-choice "projtxt_snap_active" 2)
		 (ui-choice "projtxt_snapactive_all" 3)
		 '(rebuild #t)
	)					
	(ui-tick-widget "projtxt_drawBox"
		(list 'enabled (ui-and 
						(ui-ne "projtxt_projtype" 'PTXT_CAMERA)
						(ui-ne "projtxt_snapBox" 0)))
	)
	(ui-tick-widget "projtxt_uniformSnap"	
		(list 'enabled (ui-and 
						(ui-ne "projtxt_projtype" 'PTXT_CAMERA)
						(ui-ne "projtxt_snapBox" 0)))
	)
)
