;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Object Tools Menu
;;;

(ui-string "mp_text_str"                "text...")
(ui-string "mp_text_attr_str"           "text")
(ui-string "mp_draw_skeleton_str"       "New Skeleton")
(ui-string "mp_draw_skeleton_attr_str"  "drw skl")
(ui-string "mp_bspline_str"             "fit b-spline")
(ui-string "mp_bspline_attr_str"        "fit")
(ui-string "mp_close_str"               "close")
(ui-string "mp_close_attr_str"          "close")
(ui-string "mp_insert_str"              "insert")
(ui-string "mp_insert_attr_str"         "insert")
(ui-string "mp_extend_str"              "extend")
(ui-string "mp_extend_attr_str"         "extend")
(ui-string "mp_offset_str"              "offset")
(ui-string "mp_tubular_offset_str"      "Tubular offset")
(ui-string "mp_tubular_offset_attr_str" "tuboff")
(ui-string "mp_offset_attr_str"         "offset")
(ui-string "mp_smooth_object_str"       "smooth")
(ui-string "mp_smooth_object_attr_str"  "smooth")
(ui-string "mp_align_str"               "align 2008")
(ui-string "mp_align_attr_str"          "align08")
(ui-string "mp_align_nova_str"               "align")
(ui-string "mp_align_nova_attr_str"          "align")
(ui-string "mp_symalign_str"            "Symmetry Plane Align")
(ui-string "mp_symalign_attr_str"       "symaln")

(ui-string "mp_object_symmetric_str"    "Symmetric Modeling")
(ui-string "mp_object_symmetric_attr_str"  "symm")
(ui-string "mp_vsrsmooth_str"			"Smooth")
(ui-string "mp_vsrsmooth_attr_str"		"smooth")

(ui-string "mp_detach_str"              "detach")
(ui-string "mp_detach_attr_str"         "detach")
(ui-string "mp_undo_str"                "undo attach")
(ui-string "mp_undo_attr_str"           "undo")
(ui-string "mp_attach_str"              "attach")
(ui-string "mp_attach_attr_str"         "attach")
(ui-string "mp_dup_obj_str"             "Object")
(ui-string "mp_dup_obj_attr_str"        "dpobj")
(ui-string "mp_sel_handle_create_str"   "New Selection Handle")
(ui-string "mp_sel_handle_create_attr_str"  "sel hand")
(ui-string "mp_query_geom_str"          "Query Edit")
(ui-string "mp_query_geom_attr_str"     "qryed")
(ui-string "mp_sphere_str"         		"sphere")
(ui-string "mp_sphere_attr_str"    		"sphere")
(ui-string "mp_torus_str"               "torus")
(ui-string "mp_torus_attr_str"          "torus")
(ui-string "mp_plane_str"          		"plane")
(ui-string "mp_plane_attr_str"     		"plane")
(ui-string "mp_cylinder_str"       		"cylinder")
(ui-string "mp_cylinder_attr_str"  		"cylnd")
(ui-string "mp_cone_str"          		"cone")
(ui-string "mp_cone_attr_str"     		"cone")
(ui-string "mp_circle_str"        		"circle")
(ui-string "mp_circle_attr_str"    		"circle")
(ui-string "mp_jack_str"				"jack")
(ui-string "mp_jack_attr_str"			"jack")
(ui-string "mp_cube_str"          		"cube")
(ui-string "mp_cube_attr_str"     		"cube")
(ui-string "mp_objecteditor_str"        "Object Editor")
(ui-string "mp_objecteditor_attr_str"   "objed")

(ui-string "mp_projplanar_str"          		"planar")
(ui-string "mp_projplanar_attr_str"     		"plnar")
(ui-string "mp_projconcentric_str"          		"concentric")
(ui-string "mp_projconcentric_attr_str"     		"concn")
(ui-string "mp_projtriplanar_str"          		"triplanar")
(ui-string "mp_projtriplanar_attr_str"     		"trpln")
(ui-string "mp_projspherical_str"          		"spherical")
(ui-string "mp_projspherical_attr_str"     		"sphrcl")
(ui-string "mp_projball_str"          		"ball")
(ui-string "mp_projball_attr_str"     		"ball")
(ui-string "mp_projcylindrical_str"          		"cylindrical")
(ui-string "mp_projcylindrical_attr_str"     		"cylnd")
(ui-string "mp_projcubic_str"          		"cubic")
(ui-string "mp_projcubic_attr_str"     		"cubic")
(ui-string "mp_projcamera_str"          		"camera")
(ui-string "mp_projcamera_attr_str"     		"camra")
(ui-string "mp_placeprojtxt_str"		"Place Projection")
(ui-string "mp_placeprojtxt_attr_str"	"plcpj")
(ui-string "mp_defSpace_geom_str"          		"Global Deformation")
(ui-string "mp_defSpace_geom_attr_str"     		"deform")

(ui-function "mp_object_tools_text"
	(list 'command				"Text")
	(list 'label_string        	'mp_text_str)
	(list 'attribute_string   	'mp_text_attr_str)
	(list 'option_function		"TextGeomOpt")
)

(ui-function "mp_object_tools_skeleton" 
	(list 'select 				'mp_objtools	'MP_MAKE_SKELETON)
	(list 'command				"DrawSkeleton")
	(list 'label_string 		'mp_draw_skeleton_str)
	(list 'attribute_string 	'mp_draw_skeleton_attr_str)
)

(ui-function "mp_object_tools_bspline"  
	(list 'select 				'mp_objtools	'MP_FIT_BSPLINE)
	(list 'command				"FitBspline")
	(list 'label_string 		'mp_bspline_str)
	(list 'attribute_string 	'mp_bspline_attr_str)
	(list 'option_editor 		"Modeling/mo_fit_spline_options.o.scm"
								'fit.options)
)

(ui-function "mp_object_tools_close"    
	(list 'select 				'mp_objtools	'MP_CLOSE)
	(list 'command				"Close")
	(list 'label_string 		'mp_close_str)
	(list 'attribute_string 	'mp_close_attr_str)
	(list 'option_editor 		"Modeling/mo_close_options.o.scm"
								'close.options)
)

(ui-function "mp_object_tools_insert"   
	(list 'select 				'mp_objtools 'MP_INSERT)
	(list 'command				"Insert")
	(list 'label_string 		'mp_insert_str)
	(list 'attribute_string 	'mp_insert_attr_str)
	(list 'option_editor       	"Modeling/mo_insert_options.o.scm"
								'insert.options)
)

(ui-function "mp_object_tools_extend"   
	(list 'select 				'mp_objtools	'MP_EXTEND)
	(list 'command				"Extend")
	(list 'label_string 		'mp_extend_str)
	(list 'attribute_string 	'mp_extend_attr_str)
	(list 'option_editor 		"Modeling/mo_extend_options.o.scm"
								'extend.options)
)

(ui-function "mp_object_tools_make_symmetric"   
	(list 'command				"ObjectSymmetric")
	(list 'label_string 		'mp_object_symmetric_str)
	(list 'attribute_string 	'mp_object_symmetric_attr_str)
)

(ui-function "mp_object_tools_vsrsmooth"
	(list 'command				"SmoothTool")
	(list 'label_string        	'mp_vsrsmooth_str)
	(list 'attribute_string   	'mp_vsrsmooth_attr_str)
	(list 'option_function      "SmoothToolControlBox")
	(list 'symbols
		  'mo_vsrsmooth_smoothing_factor
		  'mo_vsrsmooth_partial_undo
		  'mo_vsrsmooth_smooth_u
		  'mo_vsrsmooth_smooth_v
		  'mo_vsrsmooth_fixed_edges
		  'mo_vsrsmooth_edge_influence
		  'mo_vsrsmooth_deviation
		  'mo_vsrsmooth_proxy_display
		  'mo_vsrsmooth_keep_originals
	)
)

(ui-function "mp_object_tools_ch_offset"   
	(list 'command				"OffsetHistory")
	(list 'label_string 		'mp_offset_str)
	(list 'attribute_string 	'mp_offset_attr_str)
	(list 'option_function 		"OffsetControl")
	(list 'symbols
			'mo_ch_offset_curve_break 'mo_ch_offset_plane
			'mo_ch_offset_curve_loop_cutting 'mo_ch_offset_offset_autorecalc
			'mo_ch_offset_offset_history 'mo_ch_offset_offset_control
			'mo_ch_offset_curve_cutting_radius 'mo_ch_offset_max_spans_factor
			'mo_ch_offset_distance 'mo_ch_offset_offset_copy_cos
			'mo_ch_offset_normal_mode 'mo_ch_offset_create_metadata
	)
)

; will be obsolete soon
(ui-function "mp_object_tools_offset"   
 	(list 'select 				'mp_objtools 'MP_OFFSET)
 	(list 'command				"Offset")
 	(list 'label_string 		'mp_offset_str)
 	(list 'attribute_string 	'mp_offset_attr_str)
 	(list 'option_editor 		"Modeling/mo_offset_options.o.scm"
 								'offset.options)
)

(ui-function "mp_object_tools_tub_offset"
    (list 'select               'mp_objtools 'MP_TUBULAR_OFFSET)
    (list 'command              "TubularOffset")
    (list 'label_string         'mp_tubular_offset_str)
    (list 'attribute_string     'mp_tubular_offset_attr_str)
	(list 'option_function 		"TubularOffsetControlBox")
	(list 'symbols
		'mo_tubular_offset_surface_type 'mo_tubular_offset_trim_type
		'mo_tubular_offset_single_srf	'mo_tubular_offset_auto_recalc
		'mo_tubular_offset_radius		'mo_tubular_offset_flip
		'mo_tubular_offset_h_offset		'mo_tubular_offset_v_offset
		'mo_tubular_offset_pick_chain	'mo_tubular_offset_inter_continuity_check
		'mo_tubular_offset_surface      'mo_tubular_offset_create_metadata
		'mo_tubular_offset_single_span  'mo_tubular_offset_create_history
	)
)

(if (ui-symbol-true "aw_fod_object_edit_smooth" )
   (begin
      (ui-function "mp_object_tools_smooth"   
	     (list 'select 				'mp_objtools	'MP_FAIR)
	     (list 'command				"Smooth")
	     (list 'label_string 		'mp_smooth_object_str)
	     (list 'attribute_string 	'mp_smooth_object_attr_str)
	     (list 'option_editor 		"Modeling/mo_smooth_options.o.scm"
		     						'smooth.options)
      )
   )
)

(ui-function "mp_object_tools_align"    
	(list 'select 				'mp_objtools 'MP_ALIGN)
	(list 'command				"Align2008")
	(list 'label_string 		'mp_align_str)
	(list 'attribute_string 	'mp_align_attr_str)
	(list 'option_function      "Align2008Controls")
	(list 'symbols	
		'mo_align_history			'mo_align_keep_orig
		'mo_align_tangent_scaling	'mo_align_mod_type
		'mo_align_snap_mode			'mo_align_align_mode
		'mo_align_continuity_check  'mo_align_explicit_control
		'mo_align_insert_at_param   'mo_align_align_by_project
		'mo_align_skews_allowed     'mo_align_partial_joins
		'mo_align_alignmode_C0      'mo_align_alignmode_G1
		'mo_align_alignmode_G2      'mo_align_auto_recalc
		'mo_align_continuity        'mo_align_attach_hardness
		'mo_align_modify_type       'mo_align_intersection_type
		'mo_align_interp_int_from_ends  'mo_align_modify_interior_allowed
		'mo_align_se_controls			'mo_align_alignment_type    
		'mo_align_alignment_type_start	'mo_align_alignment_type_end
		'mo_align_dirAlignVector
        'mo_align_dirAlignPreset
        'mo_align_dirAlignRotation
		'mo_align_continuity_check_same 'mo_align_continuity_check_type
		'mo_align_item1_g1_scale		'mo_align_item1_g1_scale_end	
		'mo_align_item1_g1_skew0		'mo_align_item1_g1_skew1		
		'mo_align_item1_g2_scale		'mo_align_item1_g2_scale_end
		'mo_align_item1_g2_skew0		'mo_align_item1_g2_skew1
		'mo_align_item1_cv_rows_affected    'mo_align_item1_decay
		'mo_align_item1_degreeSync		'mo_align_item1_num_manip
		'mo_align_item2_g1_scale		'mo_align_item2_g1_scale_end	
		'mo_align_item2_g1_skew0		'mo_align_item2_g1_skew1
		'mo_align_item2_g2_scale		'mo_align_item2_g2_scale_end
		'mo_align_item2_g2_skew0		'mo_align_item2_g2_skew1		
		'mo_align_item2_cv_rows_affected    'mo_align_item2_decay
		'mo_align_item2_degreeSync		'mo_align_item2_num_manip
		'mo_align_lock_position_row		'mo_align_lock_tangent_row
	)
)

(ui-function "mp_object_tools_align_nova"    
	(list 'command				"Align")
	(list 'label_string 		'mp_align_nova_str)
	(list 'attribute_string 	'mp_align_nova_attr_str)
	(list 'option_function      "AlignControlBox")
	(list 'symbols	
		'mo_align_nova_autoRecalc
		'mo_align_nova_create_history
    	'mo_align_nova_continuity
    	'mo_align_nova_want_continuity_check
        'mo_align_nova_enable_blending
        'mo_align_nova_blending_num_rows_modified
        'mo_align_nova_blending_decay
    	'mo_align_nova_aSlider_G2_infer
    	'mo_align_nova_slaveSrf_explicit
    	'mo_align_nova_slave_influence_value
    	'mo_align_nova_enable_overhang_tolerance
        'mo_align_nova_enable_partial
        'mo_align_nova_enable_position_influence
        'mo_align_nova_vector_constraint
        'mo_align_nova_crv_srf_alignType
    	'mo_align_nova_SS_align_linked
        'mo_align_nova_project_vector_presets
        'mo_align_nova_partial_auto_snap
		'mo_align_nova_proxy_display
		'mo_align_nova_diagnostic_feedback
        'mo_align_nova_lock_row0
    )
)

(ui-function "mp_object_tools_symalign"    
	(list 'command				"SymAlign")
	(list 'label_string 		'mp_symalign_str)
	(list 'attribute_string 	'mp_symalign_attr_str)
	(list 'option_editor 		"Modeling/mo_symalign_options.o.scm"
								'SymAlign)
)

(ui-function "mp_object_tools_detach"   
	(list 'select 				'mp_objtools 'MP_DETACH)
	(list 'command				"Detach")
	(list 'label_string 		'mp_detach_str)
	(list 'attribute_string 	'mp_detach_attr_str)
	(list 'option_editor 		"Modeling/mo_detach_options.o.scm"
								'detach.options)
)

(ui-function "mp_object_tools_undo"     
	(list 'select 				'mp_objtools 'MP_UNATTACH)
	(list 'active   			(ui-eq "mo_attach_undo_ok" #t))
	(list 'command				"UndoAttach")
	(list 'label_string 		'mp_undo_str)
	(list 'attribute_string 	'mp_undo_attr_str)
	(list 'set_popup_function 	#f)
)

(ui-function "mp_object_tools_attach"   
	(list 'select 				'mp_objtools 'MP_ATTACH)
	(list 'command				"Attach")
	(list 'label_string 		'mp_attach_str)
	(list 'attribute_string 	'mp_attach_attr_str)
	(list 'option_editor 		"Modeling/mo_attach_options.o.scm"
								'attach.options)
)

(ui-function "mp_object_tools_copy"     
	(list 'select 				'mp_objtools 'MP_COPY)
	(list 'command				'mo_copy_function
								"ModelCopyGroupOn" "ModelCopyGroupOff")
	(list 'label_string 		'mp_dup_obj_str)
	(list 'attribute_string 	'mp_dup_obj_attr_str)
	(list 'option_editor 		"Modeling/mo_copy_options.o.scm"
								'copy.options)
)

;; Projective texture primitives
(ui-function "mp_object_projplanar" 
	(list 'command				"PlanarProjection")
	(list 'label_string 		'mp_projplanar_str)
	(list 'attribute_string 	'mp_projplanar_attr_str)
	(list 'option_editor 		"Modeling/mo_projplanar_options.o.scm"
								'projtxt_planar.options)
)
(ui-function "mp_object_projconcentric" 
	(list 'command				"ConcentricProjection")
	(list 'label_string 		'mp_projconcentric_str)
	(list 'attribute_string 	'mp_projconcentric_attr_str)
	(list 'option_editor 		"Modeling/mo_projconc_options.o.scm"
								'projtxt_conc.options)
)
(ui-function "mp_object_projtriplanar" 
	(list 'command				"TriplanarProjection")
	(list 'label_string 		'mp_projtriplanar_str)
	(list 'attribute_string 	'mp_projtriplanar_attr_str)
	(list 'option_editor 		"Modeling/mo_projtri_options.o.scm"
								'projtxt_tri.options)
)
(ui-function "mp_object_projspherical" 
	(list 'command				"SphericalProjection")
	(list 'label_string 		'mp_projspherical_str)
	(list 'attribute_string 	'mp_projspherical_attr_str)
	(list 'option_editor 		"Modeling/mo_projsph_options.o.scm"
								'projtxt_sph.options)
)
(ui-function "mp_object_projball" 
	(list 'command				"BallProjection")
	(list 'label_string 		'mp_projball_str)
	(list 'attribute_string 	'mp_projball_attr_str)
	(list 'option_editor 		"Modeling/mo_projball_options.o.scm"
								'projtxt_ball.options)
)
(ui-function "mp_object_projcylindrical" 
	(list 'command				"CylindricalProjection")
	(list 'label_string 		'mp_projcylindrical_str)
	(list 'attribute_string 	'mp_projcylindrical_attr_str)
	(list 'option_editor 		"Modeling/mo_projcyl_options.o.scm"
								'projtxt_cyl.options)
)
(ui-function "mp_object_projcubic" 
	(list 'command				"CubicProjection")
	(list 'label_string 		'mp_projcubic_str)
	(list 'attribute_string 	'mp_projcubic_attr_str)
	(list 'option_editor 		"Modeling/mo_projcub_options.o.scm"
								'projtxt_cub.options)
)
(ui-function "mp_object_projcamera" 
	(list 'command				"CameraProjection")
	(list 'label_string 		'mp_projcamera_str)
	(list 'attribute_string 	'mp_projcamera_attr_str)
	(list 'option_editor 		"Modeling/mo_projcamera_options.o.scm"
								'projtxt_camera.options)
)

(ui-function "mp_object_placeprojtxt"
	(list 'command			"PlaceProjection")
	(list 'label_string		'mp_placeprojtxt_str)
	(list 'attribute_string	'mp_placeprojtxt_attr_str)
)

(ui-function "mp_object_tools_cube" 
	(list 'command				"Cube")
	(list 'label_string 		'mp_cube_str)
	(list 'attribute_string 	'mp_cube_attr_str)
	(list 'option_editor 		"Modeling/mo_cube_options.o.scm"
								'cube.options)
)

(ui-function "mp_object_tools_sphere" 
	(list 'command				"Sphere")
	(list 'label_string 		'mp_sphere_str)
	(list 'attribute_string 	'mp_sphere_attr_str)
	(list 'option_editor 		"Modeling/mo_sphere_options.o.scm"
								'sphere.options)
)

(ui-function "mp_object_tools_torus" 
	(list 'command				"Torus")
	(list 'label_string 		'mp_torus_str)
	(list 'attribute_string 	'mp_torus_attr_str)
	(list 'option_editor 		"Modeling/mo_torus_options.o.scm"
								'torus.options)
)

(ui-function "mp_object_tools_circle" 
	(list 'command				"Circle")
	(list 'label_string 		'mp_circle_str)
	(list 'attribute_string 	'mp_circle_attr_str)
	(list 'option_editor 		"Modeling/mo_circle_options.o.scm"
								'circle.options)
)

(ui-function "mp_object_tools_jack"
	(list 'command 				"Jack")
	(list 'label_string 		'mp_jack_str)
	(list 'attribute_string		'mp_jack_attr_str)
)

(ui-function "mp_object_tools_cylinder" 
	(list 'command				"Cylinder")
	(list 'label_string 		'mp_cylinder_str)
	(list 'attribute_string 	'mp_cylinder_attr_str)
	(list 'option_editor 		"Modeling/mo_cylinder_options.o.scm"
								'cylinder.options)
)

(ui-function "mp_object_tools_cone" 
	(list 'command				"Cone")
	(list 'label_string 		'mp_cone_str)
	(list 'attribute_string 	'mp_cone_attr_str)
	(list 'option_editor 		"Modeling/mo_cone_options.o.scm"
								'cone.options)
)

(ui-function "mp_object_tools_plane" 
	(list 'command				"Plane")
	(list 'label_string 		'mp_plane_str)
	(list 'attribute_string 	'mp_plane_attr_str)
	(list 'option_editor 		"Modeling/mo_plane_options.o.scm"
								'plane.options)
)

(ui-function "mp_sel_handle_create"
	(list 'command              "SelHandleCreate")
	(list  'label_string         'mp_sel_handle_create_str)
	(list  'attribute_string     'mp_sel_handle_create_attr_str)
)

(ui-function "mp_query_geom"
    (list 'command              "QueryGeometry")
    (list 'label_string         'mp_query_geom_str)
    (list 'attribute_string     'mp_query_geom_attr_str)
)

(ui-function "mp_defSpace"
    (list 'command              "GlobalDeform" )
    (list 'label_string         'mp_defSpace_geom_str )
    (list 'attribute_string     'mp_defSpace_geom_attr_str)
    (list 'option_function      "GlobalDeform_info")
    (list 'symbols  'defctrl.fromPnt
                    'defctrl.toPnt
					'defctrl.delta
					'defctrl.extents
					'defctrl.rotation
					'defctrl.fillBox
    	)
)

(ui-function "mp_object_tools_objecteditor"   
	(list 'select 				'mp_objtools	'MP_OBJECTEDITOR)
	(list 'command				"ObjectEditor")
	(list 'label_string 		'mp_objecteditor_str)
	(list 'attribute_string 	'mp_objecteditor_attr_str)
	(list 'option_editor 		"Modeling/mo_objecteditor_options.o.scm"
								'objecteditor.options)
)
