;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Object Display Menu

(ui-string "mp_expsbd_str"              "expand SBD")
(ui-string "mp_expsbd_attr_str"         "xsbd")
(ui-string "mp_compsbd_str"             "compress SBD")
(ui-string "mp_compsbd_attr_str"        "csbd")
(ui-string "mp_patchpre_str"            "Patch Precision")
(ui-string "mp_patchpre_attr_str"       "ptprec")
(ui-string "mp_hullpre_str"             "Hull Precision")
(ui-string "mp_hullpre_attr_str"        "hulprc")
(ui-string "mp_curvepre_str"            "Draw Precision")
(ui-string "mp_curvepre_attr_str"       "dprec")
(ui-string "mp_linestl_str"             "Bone Style")
(ui-string "mp_linestl_attr_str"        "style")
(ui-string "mp_symbology_str"           "Draw Style")
(ui-string "mp_symbology_attr_str"      "dstyl") 
(ui-string "mp_bound_str"               "Bounding Box") 
(ui-string "mp_bound_attr_str"          "bbx") 
(ui-string "mp_wire_str"                "quick wire") 
(ui-string "mp_wire_attr_str"           "qk wire")

(ui-string "mp_shadeopt_str"            "Hardware Shade")
(ui-string "mp_shadeopt_attr_str"       "hwshd")
(ui-string "mp_no_shade_str"               "No Shade")
(ui-string "mp_no_shade_attr_str"          "No Shade")
(ui-string "mp_hiddenline_str"          "Hidden Line")
(ui-string "mp_hiddenline_attr_str"     "hidline")

(ui-string "mp_template_str"            "template")
(ui-string "mp_template_attr_str"       "tmpl")
(ui-string "mp_invisible_str"           "invisible")
(ui-string "mp_invisible_attr_str"      "invis")
(ui-string "mp_visible_str"             "visible")
(ui-string "mp_visible_attr_str"        "vis")
(ui-string "mp_control_str"             "control")
(ui-string "mp_control_attr_str"        "cntrl")

(ui-string "mp_objdisplay_hideunselected_str"        "Hide Unselected")
(ui-string "mp_objdisplay_hideunselected_attr_str"        "hdun")

(ui-string "mp_objdisplay_toggleVisibility_str"			"Toggle Visibility")
(ui-string "mp_objdisplay_toggleVisibility_attr_str"	"tglvis")

(ui-function "mp_objdisplay_expandsbd"  
	(list 'select        		'mp_objdisplay 'MP_EXPANDSBD)
	(list 'command				"ExpandSbd")
	(list 'label_string        	'mp_expsbd_str)
	(list 'attribute_string   	'mp_expsbd_attr_str)
)

(ui-function "mp_objdisplay_comprssbd"  
	(list 'select        		'mp_objdisplay 'MP_COMPRESSBD)
	(list 'command				"CompressSbd")
	(list 'label_string        	'mp_compsbd_str)
	(list 'attribute_string   	'mp_compsbd_attr_str)
)

(ui-function "mp_objdisplay_patchpre"   
	(list 'select        		'mp_objdisplay 'MP_PATCHPRECISION)
	(list 'command				"PatchPrecision")
	(list 'label_string        	'mp_patchpre_str)
	(list 'attribute_string   	'mp_patchpre_attr_str)
)

(ui-function "mp_objdisplay_hullpre"   
	(list 'select        		'mp_objdisplay 'MP_HULLPRECISION)
	(list 'command				"HullPrecision")
	(list 'label_string        	'mp_hullpre_str)
	(list 'attribute_string   	'mp_hullpre_attr_str)
	(list 'option_editor		"Modeling/mo_hullprecision_options.o.scm"
								'hullprecision.options) 
)

(ui-function "mp_objdisplay_curvepre"
             (list 'command				"DrawPrecision")
             (list 'label_string        	'mp_curvepre_str)
             (list 'attribute_string   	'mp_curvepre_attr_str)
             (list 'option_editor       "Modeling/mo_drawprecision_options.o.scm" 'drawPrecision.options))


(ui-function "mp_objdisplay_symbology"    
	(list 'select        		'mp_objdisplay 'MP_SURFSTYLE)
	(list 'command				"DrawStyle")
	(list 'attribute_string    	'mp_symbology_attr_str)
	(list 'label_string        	'mp_symbology_str)
	(list 'option_function     	"DrawStyleOptions")

	(list 'symbols        	'mo_surfstyle_boundary
							'mo_surfstyle_interior
							'mo_surfstyle_vhull
							'mo_surface_cv_icon
							'mo_curve_cv_icon
							'mo_curve_ep_icon
							'mo_scandata_lines
							'mo_scandata_icon
							'mo_visual_curve_line_width
							'mo_curve_line_width
							'mo_surfstyle_hull_width
							'mo_curve_hull_width
							'mo_scandata_showlines
							'mo_scandata_linestyle
							'mo_blendpoint_icon_style
							'mo_symmetry_linestyle
                            'mo_subdiv_hull_width
                            'mo_subdiv_creased_hull_width
                            'mo_subdiv_boundary_hull_width
                            'mo_subdiv_cv_icon
                            'mo_subdiv_ls_boundary
                            'mo_subdiv_ls_interior
	)
)

(ui-function "mp_objdisplay_linestl"    
	(list 'select        		'mp_objdisplay 'MP_SYMBOLOGY)
	(list 'command				"LineStyle")
	(list 'label_string        	'mp_linestl_str)
	(list 'attribute_string   	'mp_linestl_attr_str)
	(list 'option_editor 		"Modeling/mo_linestyle_options.o.scm"
								'linestl.options)
)

(ui-function "mp_objdisplay_tglbound"   
	(list 'select        		'mp_objdisplay 'MP_TOGLBBOX)
	(list 'command				"TglBoundingBox")
	(list 'label_string        	'mp_bound_str)
	(list 'attribute_string   	'mp_bound_attr_str)
)

;; No Shade
(ui-function "mp_display_no_shade"         
	(list 'select        	'mp_display 'MP_NO_SHADE)
	(list 'command			"testFunc")
	(list 'label_string     'mp_no_shade_str)
	(list 'attribute_string 'mp_no_shade_attr_str)

)

;; Object Shade Options
(ui-function "mp_display_shade_options"         
	(list 'select        		'mp_display 'MP_TOGGLESHADEOPTIONS)
	(list 'command				"TglShade")
	(list 'label_string        	'mp_shadeopt_str)
	(list 'attribute_string   	'mp_shadeopt_attr_str)
    (list 'option_function      "ToggleShadeOptions")
	(list 'symbols
		  'mo_tglshade_use_fileSyms
		  'mo_tgl_shade_options
		  'mo_shade_geom_all
		  'mo_shade_preset
		  'mo_shade_force_shader

		  'mo_tglshade_tess_flavor
		  'mo_tglshade_tess_preset
		  'ir_tglshade_tol
		  'mo_tglshade_tess_limit_edge_length
		  'mo_tglshade_tess_max_edge_length
		  'mo_tglshade_display_tesselation

		  'mo_tglshade_texture_res
          'mo_tglshade_clearcoat
          'mo_tglshade_show_background
          'mo_tglshade_reflect_background

		  'mo_tglshade_enable_gp
		  'mo_tglshade_enable_lt

		  'mo_shade_self_shadows
          'mo_tglshade_lighting
		  'mo_tglshade_shaderglow
		  'mo_tglshade_shaderglow_quality

		  'mo_tglshade_optimizeshaderglow
		  'mo_tglshade_optimizegroundplanereflection
		  'mo_use_optimize_selfshadows_on_tumble

		  'mo_shade_auto_update
	)
)


;; Toggle HiddenLine
(ui-function "mp_display_hiddenLine"         
	(list 'select        		'mp_display 'MP_HIDDENLINE)
	(list 'command				"TglHiddenLine")
	(list 'label_string        	'mp_hiddenline_str)
	(list 'attribute_string   	'mp_hiddenline_attr_str)
    (list 'option_function      "TglHiddenLine_optionFunc")
	(list 'symbols 	"mo_hiddenLine_all_windows"
                    "mo_hiddenLine_tess_type"
                    "mo_hiddenLine_use_existing"
                    "mo_hiddenLine_tolerance"
                    "mo_hiddenLine_limit_edge_length"
                    "mo_hiddenLine_max_edge_length"
                    "mo_hiddenLine_no_silhouettes_on_tumble"
	)
)

(ui-function "mp_objdisplay_tgltemplate" 
	(list 'select        		'mp_objdisplay 'MP_TOGLTEMP)
	(list 'command				"TglTemplate")
	(list 'label_string        	'mp_template_str)
	(list 'attribute_string   	'mp_template_attr_str)
)

(ui-function "mp_objdisplay_invisible"  
	(list 'select        		'mp_objdisplay 'MP_INVISIBLE)
	(list 'command				"Invisible")
	(list 'label_string        	'mp_invisible_str)
	(list 'attribute_string   	'mp_invisible_attr_str)
)

(ui-function "mp_objdisplay_hideunselected"  
	(list 'command				"HideUnselected")
	(list 'label_string        	'mp_objdisplay_hideunselected_str)
	(list 'attribute_string   	'mp_objdisplay_hideunselected_attr_str)
	(list 'option_editor 		"Modeling/mo_hideunselected_options.o.scm"
								'hideunselected.options)
)

(ui-function "mp_objdisplay_visible"    
	(list 'select        		'mp_objdisplay 'MP_VISIBLE)
	(list 'command				'mp_visible_command "VisiblePick" "VisibleAll")
	(list 'label_string        	'mp_visible_str)
	(list 'attribute_string   	'mp_visible_attr_str)
	(list 'option_editor 		"Modeling/mo_visible_options.o.scm"
								'visible.options)
)

(ui-function "mp_display_control"       
	(list 'select        		'mp_display 'MP_TOGGLECONTROL)
	(list 'command				"DisplayControl")
	(list 'label_string        	'mp_control_str)
	(list 'attribute_string   	'mp_control_attr_str)
	(list 'option_function     	"OpenDisplayControl")
	(list	'symbols
		'mo_disp_object

		'mo_disp_cv 
		'mo_disp_key_point	
		'mo_disp_blend_point	
		'mo_disp_edit
		'mo_disp_hull 
		'mo_disp_iso
		'mo_disp_iso_u
		'mo_disp_iso_v
		'mo_disp_precision

		'mo_disp_active_cv 
		'mo_disp_active_edit
		'mo_disp_active_key_point	
		'mo_disp_active_blend_point	
		'mo_disp_active_hull 
		'mo_disp_active_iso
		'mo_disp_active_iso_u
		'mo_disp_active_iso_v
		'mo_disp_active_precision

		'mo_disp_crv_cv
		'mo_disp_crv_edit
		'mo_disp_crv_key_point
		'mo_disp_crv_blend_point
		'mo_disp_crv_hull

		'mo_disp_scan_cv
        'mo_disp_scan_hull

		'mo_disp_srf_cv
		'mo_disp_srf_hull	
		'mo_disp_srf_iso
		'mo_disp_srf_iso_u
		'mo_disp_srf_iso_v
		'mo_disp_srf_precision
		
		'mo_disp_crv_blend_cv
		'mo_disp_crv_blend_edit
		'mo_disp_crv_blend_hull

		'mo_disp_crv_keypoint_cv
		'mo_disp_crv_keypoint_edit
		'mo_disp_crv_keypoint_hull

		'mo_disp_subdiv_cv
		'mo_disp_subdiv_hull
		'mo_disp_subdiv_iso
		'mo_disp_subdiv_iso_u
		'mo_disp_subdiv_iso_v
		'mo_disp_subdiv_precision
	)
)

(ui-function "mp_objdisplay_toggleVisibility"
	(list 'command				"ToggleVisibility")
	(list 'label_string        	'mp_objdisplay_toggleVisibility_str)
	(list 'attribute_string   	'mp_objdisplay_toggleVisibility_attr_str)
	(list 'option_editor 		"Modeling/mo_toggleVisibility_options.o.scm"
								'toggleVisibility.options)
	(list 'symbols
			"mo_toggleVisibility_cameras"
			"mo_toggleVisibility_lights"
			"mo_toggleVisibility_textures"
			"mo_toggleVisibility_construction"
	)
)
