;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; NurbsToMesh Option Box
;;;

(ui-string "nurbsToMesh.name"                 "NURBS to Mesh Options")

(ui-string "mo_nurbsToMesh_tess_type"         "Tessellator")
(ui-string "mo_nurbsToMesh_tess_fast"         "Fast")
(ui-string "mo_nurbsToMesh_tess_accurate"     "Accurate")

(ui-string "mo_nurbsToMesh_tolerance"         "Tolerance")

(ui-string "mo_nurbsToMesh_use_existing"      "Use existing tessellation")
(ui-string "mo_nurbsToMesh_tessellate_shells" "Tessellate shells")

(ui-string "mo_nurbsToMesh_limit_edge_length" "Limit edge length")
(ui-string "mo_nurbsToMesh_max_edge_length"   "Max edge length")

(ui-string "mo_nurbsToMesh_merge_vertices"      "Merge Type")
(ui-string "mo_nurbsToMesh_merge_vertices.yes"  "Modeling")
(ui-string "mo_nurbsToMesh_merge_vertices.no"   "Visualize")

(ui-editor "nurbsToMesh.options"               
	
	(list 'title 'nurbsToMesh.name)

	(list 'symbols 	"mo_nurbsToMesh_tess_type"
                    "mo_nurbsToMesh_use_existing"
                    "mo_nurbsToMesh_tolerance"
                    "mo_nurbsToMesh_limit_edge_length"
                    "mo_nurbsToMesh_max_edge_length"
                    "mo_nurbsToMesh_merge_vertices"
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)
    
    (ui-tick-widget "mo_nurbsToMesh_use_existing"
        (list 'rebuild #t))

    (ui-blank-widget)

	(ui-radio-widget "mo_nurbsToMesh_tess_type" 
        (list 'enabled (ui-eq "mo_nurbsToMesh_use_existing" #f))
        (list 'rebuild #t)
		(ui-choice "mo_nurbsToMesh_tess_fast"       'MO_TGLSHADE_ARUBA_FAST_TESSELATOR)
		(ui-choice "mo_nurbsToMesh_tess_accurate"   'MO_TGLSHADE_ARUBA_TESSELATOR)
	)
    
    (ui-blank-widget)
    
    (ui-double-widget "mo_nurbsToMesh_tolerance"
        (list 'enabled (ui-eq "mo_nurbsToMesh_use_existing" #f))
        (list 'precision "%8.5")
        (list 'range 0.0001 1.0)
        (list 'slider_range 0.01 1.0)
    )
    
    (ui-blank-widget)                                      
    
    (ui-tick-widget "mo_nurbsToMesh_limit_edge_length"
        (list 'rebuild #t)
        (list 'enabled (ui-and (ui-eq "mo_nurbsToMesh_use_existing" #f)
                               (ui-or
                                (ui-eq "mo_nurbsToMesh_tess_type"
                                      'MO_TGLSHADE_AG_TESSELATOR)
                                (ui-eq "mo_nurbsToMesh_tess_type"
                                      'MO_TGLSHADE_ARUBA_TESSELATOR)))))
                                

    (ui-double-widget "mo_nurbsToMesh_max_edge_length"
        (list 'enabled (ui-and (ui-eq "mo_nurbsToMesh_use_existing" #f)
                               (ui-eq "mo_nurbsToMesh_limit_edge_length" #t)
                               (ui-or
                                (ui-eq "mo_nurbsToMesh_tess_type"
                                       'MO_TGLSHADE_AG_TESSELATOR)
                                (ui-eq "mo_nurbsToMesh_tess_type"
                                      'MO_TGLSHADE_ARUBA_TESSELATOR))))

        (list 'range 0.01 100.0)
        (list 'slider_range 0.1 10.0))

    (ui-blank-widget
        (list 'enabled (ui-eq "mo_nurbsToMesh_use_existing" #f)))

    (ui-separator-widget
        (list 'enabled (ui-eq "mo_nurbsToMesh_use_existing" #f)))

    (ui-tick-widget "mo_nurbsToMesh_tessellate_shells"
        (list 'rebuild #t)
        (list 'enabled (ui-eq "mo_nurbsToMesh_use_existing" #f)))
    
    (ui-radio-widget "mo_nurbsToMesh_merge_vertices"
        (list 'enabled (ui-and (ui-eq "mo_nurbsToMesh_use_existing" #f)
                               (ui-eq "mo_nurbsToMesh_tessellate_shells" #t)))
        (ui-choice "mo_nurbsToMesh_merge_vertices.yes" #t)
        (ui-choice "mo_nurbsToMesh_merge_vertices.no" #f))
)
