;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; New Curve Options Box
;;;

(ui-string "newcrv.sketch.name"         "New Sketch Curve Options")
(ui-string "mo_geom_degree"             "Curve Degree")
(ui-string "mo_sketch_knot_spacing"     "Knot Spacing")
(ui-string "mo_sketch_tolerance"        "Tolerance")
(ui-string "mo_sketch_max_spans"        "Maximum Spans")

(ui-string "newcrv.degree.one"          "1")
(ui-string "newcrv.degree.two"          "2")
(ui-string "newcrv.degree.three"        "3")
(ui-string "newcrv.degree.five"         "5")
(ui-string "newcrv.degree.seven"        "7")
(ui-string "newcrv.spacing.chord"       "Chord")
(ui-string "newcrv.spacing.uniform"     "Uniform")

(ui-string "mo_newcrv_sketch_pivot"     "Pivot Position")
(ui-string "newcrv.pivot.origin"     "Origin")
(ui-string "newcrv.pivot.firstcv"    "First CV")
(ui-string "newcrv.pivot.lastcv"     "Last CV")
(ui-string "newcrv.pivot.crvcenter"  "Curve center")
(ui-string "newcrv.pivot.bboxcenter" "Bounding box center")

(ui-editor "newcrv.sketch.options"             

	(list 'title 'newcrv.sketch.name)

	(list 'symbols 	'mo_geom_degree      'mo_sketch_knot_spacing
	                'mo_sketch_tolerance 'mo_sketch_max_spans
   					'mo_newcrv_sketch_pivot
)
	
	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_geom_degree"   
		(list 'columns 4)
		(ui-choice "newcrv.degree.one" 'MO_ONE)
		(ui-choice "newcrv.degree.two" 'MO_TWO)
		(ui-choice "newcrv.degree.three" 'MO_THREE)
		(ui-choice "newcrv.degree.five" 'MO_FIVE)
		(ui-choice "newcrv.degree.seven" 'MO_SEVEN)
	)
	
	(ui-double-widget "mo_sketch_tolerance"
		(list 'range 0.001 10.0)
		(list 'precision "%f8.4")
	)
	
	(ui-integer-widget "mo_sketch_max_spans"
		(list 'slider_range 1 20)
		(list 'range 1 9999)
	)

	(ui-separator-widget)

	(ui-radio-widget "mo_newcrv_sketch_pivot"   
		(list 'columns 2)

		(ui-choice "newcrv.pivot.origin"		'MO_CRV_PIVOT_ORIGIN)
		(ui-choice "newcrv.pivot.crvcenter"		'MO_CRV_PIVOT_CRV_CENTER)
		(ui-choice "newcrv.pivot.firstcv"		'MO_CRV_PIVOT_FIRST_CV)
		(ui-choice "newcrv.pivot.bboxcenter"	'MO_CRV_PIVOT_BBOX_CENTER)
		(ui-choice "newcrv.pivot.lastcv"		'MO_CRV_PIVOT_LAST_CV)
	)
)
