;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;  
;  
;  
;  
;
	  
;;; Mass Prop. Options
;;;

(ui-string "mass.name"                  "Mass Properties Options")
(ui-string "mo_mp_volume"                  "Volume")
(ui-string "mo_mp_surf_area"               "Surface Area")	
(ui-string "mo_mp_centroid"                "Centroid")
(ui-string "mo_mp_1st_moment"              "First Moment")
(ui-string "mo_mp_2nd_moment"              "Second Moment")

(ui-string "mass.type.solid"            "Solid")
(ui-string "mass.type.shellint"         "Shell Interior")

(ui-string "mo_mp_centroid_point"           "Create Centroid Point")

(ui-string "mo_mp_volume_thickness"        "Thickness")
(ui-string "mo_mp_volume_tolerance"        "Tolerance")	
(ui-string "mo_mp_volume_type"					"Type")
(ui-string "mo_mp_moment_axis"			"Moment Axis")

(ui-string "mass.axis.x"                "X")
(ui-string "mass.axis.y"                "Y")
(ui-string "mass.axis.z"                "Z")

(ui-editor "mass14.options"               
	
	(list 'title 'mass.name)

	(list 'symbols 	'mo_mp_volume			'mo_mp_surf_area
					'mo_mp_centroid			'mo_mp_volume_tolerance
					'mo_mp_volume_thickness	'mo_mp_volume_type
					'mo_mp_1st_moment		'mo_mp_2nd_moment
					'mo_mp_moment_axis		'mo_mp_centroid_point
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go )

	(ui-tick-left-widget "mo_mp_surf_area" )
	
	(ui-tick-right-widget "mo_mp_volume"    )
	
	(ui-tick-left-widget "mo_mp_centroid"  )
	
;	temporarily disabling first and second moments
;	see comment in MassPropertiesEditor.cpp: MassPropMenu::selectHandler(..)
	
;	(ui-tick-right-widget "mo_mp_1st_moment"
;		(list	'rebuild)
;	)
;	
;	(ui-tick-left-widget "mo_mp_2nd_moment"  
;		(list	'rebuild)
;	)

	(ui-separator-widget)

;	(ui-radio-widget "mo_mp_moment_axis"  
;		(list 'enabled
;			  (ui-or  (ui-eq "mo_mp_1st_moment" #t)
;					  (ui-eq "mo_mp_2nd_moment" #t)
;			  )
;		)
;		(list 'columns 3)
;		(ui-choice "mass.axis.x"        'MO_VOLUME_AXIS_X)
;		(ui-choice "mass.axis.y"        'MO_VOLUME_AXIS_Y)
;		(ui-choice "mass.axis.z"        'MO_VOLUME_AXIS_Z)
;	)
	
	(ui-radio-widget "mo_mp_volume_type"   
		(list 'rebuild)
		(ui-choice "mass.type.solid"    'MO_SOLID)
		(ui-choice "mass.type.shellint" 'MO_SHELL_INT)
	)

	(ui-tick-left-widget "mo_mp_centroid_point"  )

	(ui-separator-widget)
	
	(ui-double-widget "mo_mp_volume_tolerance" 
		(list 'precision "%f8.5")
		(list 'range 0.00001 1.0)
	)

	(ui-distance-widget "mo_mp_volume_thickness" 
        (list 'enabled (ui-eq "mo_mp_volume_type" 'MO_SHELL_INT))
		(list 'precision "%f15.6")
		(list 'range 0.0 1000.0)
	)
	
)
