;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;  
;  
;  
;  
;
	  
;;; Mass Prop. Options
;;;

(ui-string "mass.name"                  "Mass Property Options")
(ui-string "mo_volume"                  "Volume")
(ui-string "mo_surf_area"               "Surface Area")
(ui-string "mo_centroid"                "Centroid")
(ui-string "mo_moment"                  "Inertia")
(ui-string "mo_1st_moment"              "1st Moment")
(ui-string "mo_2nd_moment"              "2nd Moment")
(ui-string "mo_volume_type"             "Type")
(ui-string "mo_volume_boundary"         "Bounded")
(ui-string "mo_volume_axis"             "Axis")
(ui-string "mo_volume_min_bound"        "Min")
(ui-string "mo_volume_max_bound"        "Max")
(ui-string "mo_volume_thickness"        "Thickness")
(ui-string "mo_volume_precision"        "Precision")
(ui-string "mo_volume_tolerance"        "Tolerance")	

(ui-string "mass.type.solid"            "Solid")
(ui-string "mass.type.shellint"         "Shell Int")
(ui-string "mass.type.shellext"         "Shell Ext")
(ui-string "mass.axis.x"                "X")
(ui-string "mass.axis.y"                "Y")
(ui-string "mass.axis.z"                "Z")

(ui-editor "mass.options"               
	
	(list 'title 'mass.name)

	(list 'symbols 	'mo_volume				'mo_surf_area
					'mo_centroid			'mo_moment
					'mo_1st_moment			'mo_2nd_moment
					'mo_volume_type			'mo_volume_boundary
					'mo_volume_axis			'mo_volume_min_bound
					'mo_volume_max_bound	'mo_volume_thickness
					'mo_volume_precision    'mo_volume_tolerance
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go )


	(ui-tick-left-widget "mo_volume"    )

	(ui-tick-right-widget "mo_surf_area" )

	(ui-tick-left-widget "mo_centroid"  )

	(ui-tick-right-widget "mo_moment"   )

	(ui-tick-left-widget "mo_1st_moment" )

	(ui-tick-right-widget "mo_2nd_moment" )

	(ui-separator-widget)

	(ui-radio-widget "mo_volume_type"   
		(list 'rebuild)
		(ui-choice "mass.type.solid"    'MO_SOLID)
		(ui-choice "mass.type.shellint" 'MO_SHELL_INT)
		(ui-choice "mass.type.shellext" 'MO_SHELL_EXT)
	)

	(ui-tick-widget "mo_volume_boundary" 
		(list 'rebuild)
	)

	(ui-separator-widget)

	(ui-radio-widget "mo_volume_axis"   
		(list 'columns 3)
		(list 'enabled (ui-eq "mo_volume_boundary" #t))
		(ui-choice "mass.axis.x"        'MO_VOLUME_AXIS_X)
		(ui-choice "mass.axis.y"        'MO_VOLUME_AXIS_Y)
		(ui-choice "mass.axis.z"        'MO_VOLUME_AXIS_Z)
	)

	(ui-distance-widget "mo_volume_min_bound" 
		(list 'enabled (ui-eq "mo_volume_boundary" #t))
		(list 'precision "%f15.6")
		(list 'range -10000.0 10000.0)
	)

	(ui-distance-widget "mo_volume_max_bound" 
		(list 'enabled (ui-eq "mo_volume_boundary" #t))
		(list 'precision "%f15.6")
		(list 'range -10000.0 10000.0)
	)

    (ui-separator-widget
        (list 'enabled (ui-eq "mo_volume_boundary" #t))
    )

	(ui-distance-widget "mo_volume_thickness" 
        (list 'enabled
			  (ui-or  (ui-eq "mo_volume_type" 'MO_SHELL_INT)
					  (ui-eq "mo_volume_type" 'MO_SHELL_EXT)
			  )
		)
		(list 'precision "%f15.6")
		(list 'range 0.0 1000.0)
	)

	(ui-integer-widget "mo_volume_precision" 
		(list 'enabled (ui-ne "mo_volume_type" 'MO_SOLID))
		(list 'range 1 10000)
	)

	(ui-double-widget "mo_volume_tolerance" 
		(list 'enabled (ui-eq "mo_volume_type" 'MO_SOLID))
		(list 'precision "%f8.5")
		(list 'range 0.00001 1.0)
	)

)
