
;;; Make Picture Options
;;;

(ui-string "imagelayer.name"                 "Export Image Layer Options")

(ui-string "mo_imagelayer_file_type"         "File Type")

(ui-string "imagelayer.filetype.jpeg"        "jpeg")
(ui-string "imagelayer.filetype.tiff"        "tiff")
(if (ui-symbol-true	"using_nt_os")
 ( begin
	(ui-string "imagelayer.filetype.bmp24"       "bmp(24bits)")
	(ui-string "imagelayer.filetype.bmp"         "bmp(32bits)")
 )
)	

(ui-string "mo_imagelayer_limit_size"        "Limit Image Size")
(ui-string "mo_imagelayer_max_x"             "Horizontal Size")
(ui-string "mo_imagelayer_max_y"             "Vertical Size")
(ui-string "mo_imagelayer_q_factor"			 " ")
(ui-string "mo_imagelayer_q_level"			 "Quality Level")

(ui-string "imagelayer.max"					 "MAXIMUM")
(ui-string "imagelayer.high"				 "HIGH")
(ui-string "imagelayer.med"					 "MEDIUM")
(ui-string "imagelayer.low"					 "LOW")

(ui-editor "imagelayer.options"              

	(list 'title 'imagelayer.name)

	(list 'symbols 	'mo_imagelayer_file_type 
                    'mo_imagelayer_limit_size
                    'mo_imagelayer_max_x
                    'mo_imagelayer_max_y 
                    'mo_imagelayer_q_factor 
                    'mo_imagelayer_q_level )

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_imagelayer_file_type"   
		(list 'rebuild #t)
		(ui-choice "imagelayer.filetype.jpeg"     'MO_FILETYPE_JPEG)
		(ui-choice "imagelayer.filetype.tiff"     'MO_FILETYPE_TIFF)
		(if (ui-symbol-true	"using_nt_os")
		 ( begin
			(ui-choice "imagelayer.filetype.bmp24"    'MO_FILETYPE_BMP24)
			(ui-choice "imagelayer.filetype.bmp"      'MO_FILETYPE_BMP)
		 )
	   )	
	)

    (ui-tick-widget			"mo_imagelayer_limit_size"
        (list 'rebuild #t)
    )
    
    (ui-integer-widget      "mo_imagelayer_max_x"
		(list 'enabled 
                (ui-eq "mo_imagelayer_limit_size" #t)
		)

		(list 'range 8)
		(list 'slider_range 32 4096)
	)

    (ui-integer-widget      "mo_imagelayer_max_y"
		(list 'enabled 
                (ui-eq "mo_imagelayer_limit_size" #t)
		)

		(list 'range 8)
		(list 'slider_range 32 4096)
	)
	
	(ui-popup-widget "mo_imagelayer_q_level"
		(list 'rebuild #t)
		(list 'enabled
				(ui-eq "mo_imagelayer_file_type" 'MO_FILETYPE_JPEG)
		)		      
		(ui-choice "imagelayer.max"    'MO_Q_MAX
			(list 'assign (ui-eq "mo_imagelayer_q_level" 'MO_Q_MAX)
					'mo_imagelayer_q_factor 100)
		)
		(ui-choice "imagelayer.high"    'MO_Q_HIGH
			(list 'assign (ui-eq "mo_imagelayer_q_level" 'MO_Q_HIGH)
					'mo_imagelayer_q_factor 90)
		)
		(ui-choice "imagelayer.med"    'MO_Q_MED 
			(list 'assign (ui-eq "mo_imagelayer_q_level" 'MO_Q_MED)
					'mo_imagelayer_q_factor 75)
		)
		(ui-choice "imagelayer.low"    'MO_Q_LOW 
			(list 'assign (ui-eq "mo_imagelayer_q_level" 'MO_Q_LOW)
					'mo_imagelayer_q_factor 60)
		)	
	)
	(ui-integer-widget      "mo_imagelayer_q_factor"
		(list 'rebuild #t)
		(list 'enabled
				(ui-eq "mo_imagelayer_file_type" 'MO_FILETYPE_JPEG)
		)
		(list 'assign (ui-eq 'mo_imagelayer_q_factor 100) 
				'mo_imagelayer_q_level 'MO_Q_MAX)
		(list 'assign (ui-lt 'mo_imagelayer_q_factor 100) 
				'mo_imagelayer_q_level 'MO_Q_HIGH)
		(list 'assign (ui-lt 'mo_imagelayer_q_factor 90) 
				'mo_imagelayer_q_level 'MO_Q_MED)
		(list 'assign (ui-lt 'mo_imagelayer_q_factor 60) 
				'mo_imagelayer_q_level 'MO_Q_LOW)
		(list 'range 1 100)
	)

)
