;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Import Image Plane Options
;;;

(ui-string "image.name"                 "Import Image Plane Options")

(ui-string "mo_image_mode"              "Display Mode")
(ui-string "mo_image_depth_type"        "Depth Type")
(ui-string "mo_image_depth"             "Depth")
(ui-string "mo_image_crop"              "Crop to Window")
(ui-string "mo_image_dim"               "Dim Image")
(ui-string "mo_image_rgb_offset"        "RGB Offset")
(ui-string "mo_image_rgb_mult"          "RGB Mult")

(ui-string "image.mode.rgb"             "RGB")
(ui-string "image.mode.box"             "Box")
(ui-string "image.type.off"             "Off")
(ui-string "image.type.priority"        "Priority")

(ui-string "mo_image_size"				"Size")
(ui-string "mo_image_horizontal"		"Horizontal")
(ui-string "mo_image_vertical"			"Vertical")

(ui-string "image.size.fit"				"Fit Window")
(ui-string "image.size.specified"		"Specified")

(ui-string "mo_image_aspect_ratio"		"Aspect Ratio")
(ui-string "image.aspect.fixed"			"Fixed")
(ui-string "image.aspect.free"			"Free")


(ui-editor "image.options"              

	(list 'title 'image.name)

	(list 'symbols 	'mo_image_mode		'mo_image_depth
					'mo_image_depth_type	'mo_image_crop
					'mo_image_dim 'mo_image_rgb_mult 'mo_image_rgb_offset
					'mo_image_size 'mo_image_horizontal
					'mo_image_vertical 'mo_image_aspect_ratio
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_image_size"
		(list 'rebuild #t)
		(ui-choice "image.size.fit"				'MO_IMAGE_SIZE_FIT)
		(ui-choice "image.size.specified"		'MO_IMAGE_SIZE_SPECIFIED)
	)

;; See SEE_THIS in vw_utility.cpp for an explanation.
;	(ui-radio-widget "mo_image_aspect_ratio"
;		(list 'rebuild #t)
;		(ui-choice "image.aspect.fixed"	'MO_IMAGE_ASPECT_FIXED)
;		(ui-choice "image.aspect.free"	'MO_IMAGE_ASPECT_FREE)
;		(list 'enabled (ui-eq 'mo_image_size 'MO_IMAGE_SIZE_SPECIFIED))
;	)
		
	(ui-distance-widget		'mo_image_horizontal
		(list 'enabled (ui-eq 'mo_image_size 'MO_IMAGE_SIZE_SPECIFIED))
		(list 'precision "%f7.4")
	)

;; See SEE_THIS in vw_utility.cpp for an explanation.
;	(ui-distance-widget		'mo_image_vertical
;		(list 'enabled
;			(ui-and
;				(ui-eq 'mo_image_size 'MO_IMAGE_SIZE_SPECIFIED)
;				(ui-eq 'mo_image_aspect_ratio 'MO_IMAGE_ASPECT_FREE)
;			)
;		)
;		(list 'range 0.001 100.0)
;	)

	(ui-blank-widget)

	(ui-separator-widget)

	(ui-radio-widget "mo_image_mode"    
		(ui-choice "image.mode.rgb"     'MO_MODE_RGB)
		(ui-choice "image.mode.box"     'MO_MODE_OUTLINE)
	)

	(ui-separator-widget)

	(ui-radio-widget "mo_image_depth_type" 
		(list 'rebuild #t)
		(ui-choice "image.type.off"     'MO_DEPTH_OFF)
		(ui-choice "image.type.priority" 'MO_DEPTH_SORT)
	)

	(ui-double-widget "mo_image_depth"  
		(list 'enabled (ui-eq "mo_image_depth_type" 'MO_DEPTH_SORT))
		(list 'precision "%f7.2")
	)

	(ui-separator-widget)

	(ui-tick-widget "mo_image_crop")

	(ui-tick-widget "mo_image_dim"
		(list 'rebuild #t)
	)

	(ui-double-widget "mo_image_rgb_offset"
		(list 'enabled (ui-eq "mo_image_dim" #t))
		(list 'range 0.0 1.0)
	)
	(ui-double-widget "mo_image_rgb_mult"
		(list 'enabled (ui-eq "mo_image_dim" #t))
		(list 'range 0.0 1.0)
	)

)

