;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Cubic Fit Options Box
;;;

(ui-string "fit.name"                   "Fit B-Spline Options")
(ui-string "mo_fit_type"                "Fit Type")
(ui-string "mo_end_condition"           "End Tangents")
(ui-string "mo_fit_knot_spacing"        "Knot Spacing")
(ui-string "mo_chord_h_ratio"           "Chord Ht. Ratio")
(ui-string "mo_val_chord_h_ratio"       "Ratio Value")
(ui-string "mo_fit_tol"                 "Tolerance")
(ui-string "mo_fit_start_utan_x"        "Start U Tangent")
(ui-string "mo_fit_end_utan_x"          "End U Tangent")
(ui-string "mo_fit_start_vtan_x"        "Start V Tangent")
(ui-string "mo_fit_end_vtan_x"          "End V Tangent")

(ui-string "fit.type.fit"               "Fit")
(ui-string "fit.type.interp"            "Interpolate")
(ui-string "fit.tangents.circle"        "Circle")
(ui-string "fit.tangents.cubic"         "Cubic")
(ui-string "fit.tangents.specify"       "Specify")
(ui-string "fit.spacing.uniform"        "Uniform")
(ui-string "fit.spacing.chord"          "Chord")

(ui-editor "fit.options"                

	(list 'title 'fit.name)

	(list 'symbols 	'mo_fit_type			'mo_end_condition
					'mo_fit_knot_spacing	'mo_chord_h_ratio
					'mo_val_chord_h_ratio	'mo_fit_tol
					'mo_fit_start_utan_x	'mo_fit_start_utan_y
					'mo_fit_start_utan_z	'mo_fit_end_utan_x
					'mo_fit_end_utan_y		'mo_fit_end_utan_z
					'mo_fit_start_vtan_x	'mo_fit_start_vtan_y
					'mo_fit_start_vtan_z	'mo_fit_end_vtan_x
					'mo_fit_end_vtan_y		'mo_fit_end_vtan_z
					'chord_option
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go )

	(ui-radio-widget "mo_fit_type"      
		(ui-choice "fit.type.fit"       'MO_CUBIC_FIT)
		(ui-choice "fit.type.interp"    'MO_CUBIC_INTERP)
	)

	(ui-separator-widget)

	(ui-radio-widget "mo_end_condition" 
		(list 'rebuild #t)
		(ui-choice "fit.tangents.circle" 'MO_END_CIRCLE)
		(ui-choice "fit.tangents.cubic" 'MO_END_CUBIC)
		(ui-choice "fit.tangents.specify" 'MO_END_SPECIFY)
	)

	(ui-separator-widget)

	(ui-radio-widget "mo_fit_knot_spacing" 
		(ui-choice "fit.spacing.uniform" 'MO_UNIFORM)
		(ui-choice "fit.spacing.chord"  'MO_CHORD_LENGTH
			(list 'available (ui-eq "chord_option" #t))
		)
	)

	(ui-boolean-widget "mo_chord_h_ratio" 
		(list 'rebuild #t)
	)

	(ui-separator-widget)

	(ui-double-widget "mo_val_chord_h_ratio" 
		(list 'enabled (ui-eq "mo_chord_h_ratio" #t))
		(list 'precision "%f8.3")
		(list 'range 0.0 99999.999)
	)

	(ui-distance-widget "mo_fit_tol"    
		(list 'precision "%f8.3")
		(list 'range 0.0 99999.999)
	)

	(ui-wdltriple-linear-widget 
		'mo_fit_start_utan_x 'mo_fit_start_utan_y 'mo_fit_start_utan_z
		(list 'enabled (ui-eq "mo_end_condition" 'MO_END_SPECIFY))
		(list 'precision "%f8.4")
	)
	
	(ui-wdltriple-linear-widget 
		'mo_fit_end_utan_x 'mo_fit_end_utan_y 'mo_fit_end_utan_z
		(list 'enabled (ui-eq "mo_end_condition" 'MO_END_SPECIFY))
		(list 'precision "%f8.4")
	)
	
	(ui-wdltriple-linear-widget 
		'mo_fit_start_vtan_x 'mo_fit_start_vtan_y 'mo_fit_start_vtan_z
		(list 'enabled (ui-eq "mo_end_condition" 'MO_END_SPECIFY))
		(list 'precision "%f8.4")
	)
	
	(ui-wdltriple-linear-widget 
		'mo_fit_end_vtan_x 'mo_fit_end_vtan_y 'mo_fit_end_vtan_z
		(list 'enabled (ui-eq "mo_end_condition" 'MO_END_SPECIFY))
		(list 'precision "%f8.4")
	)	

)
