;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Fillet Options Box

(ui-string "fillet.name"                "Fillet Options")
(ui-string "mo_ff_constrn"              "Construction")
(ui-string "mo_ff_type"                 "Freeform Type")
(ui-string "mo_ff_radius"               "Radius")
(ui-string "mo_ff_knee_ratio"           "Knee Ratio")
(ui-string "mo_ff_lead_radius"          "Lead Radius")
(ui-string "mo_ff_blend"                "Blend Control")
(ui-string "mo_ff_continuity"           "Tangency achieved")
(ui-string "mo_ff_trim"                 "Trim Curves")
(ui-string "mo_ff_history"              "Create History")
(ui-string "mo_ff_calculate"            "Calculate")


(ui-string "fillet.continuity.approx"   "Approx")
(ui-string "fillet.continuity.to_tol"   "Accurate")
(ui-string "fillet.construct.circ"      "Circular")
(ui-string "fillet.construct.free"      "Freeform")
(ui-string "fillet.construct.lead"      "Circular + Lead")
(ui-string "fillet.type.tangent"        "Tangent")
(ui-string "fillet.type.blend"          "Blend")

(ui-string "fillet.calc.lead"           "Lead Radius")
(ui-string "fillet.calc.ratio"          "Knee Ratio")

(ui-editor "fillet.options"             
	
	(list 'title 'fillet.name)

	(list 'symbols 	'mo_ff_constrn		'mo_ff_type
					'mo_ff_radius		'mo_ff_blend
					'mo_ff_trim			'mo_ff_history
					'ff_fillet_option   'mo_ff_continuity
					'mo_ff_knee_ratio	'mo_ff_lead_radius
					'mo_ff_calculate
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go )

	(ui-radio-widget "mo_ff_constrn"    
		(list 'rebuild)
		(ui-choice "fillet.construct.circ" 'MO_FF_CONSTRN_CIRC)
		(ui-choice "fillet.construct.free" 'MO_FF_CONSTRN_FF
			(list 'available	(ui-eq "ff_fillet_option" #t))
		)
        (ui-choice "fillet.construct.lead" 'MO_FF_CONSTRN_LEAD)
	)

	(ui-radio-widget "mo_ff_continuity" 
		(ui-choice "fillet.continuity.approx" #f)
		(ui-choice "fillet.continuity.to_tol" #t)
	)

	(ui-separator-widget)

	(ui-distance-widget "mo_ff_radius"  
        (list 'enabled
				(ui-or
					(ui-eq "mo_ff_constrn" 'MO_FF_CONSTRN_CIRC)
					(ui-eq "mo_ff_constrn" 'MO_FF_CONSTRN_LEAD)
				)
		)
		(list 'assign (ui-eq 'mo_ff_calculate 'MO_FF_CALC_KNEE_RATIO)
				'mo_ff_knee_ratio
						(ui-div 'mo_ff_radius 'mo_ff_lead_radius)
		)
		(list 'assign (ui-eq 'mo_ff_calculate 'MO_FF_CALC_LEAD_RADIUS)
				'mo_ff_lead_radius
						(ui-div 'mo_ff_radius 'mo_ff_knee_ratio)
		)
		(list 'precision "%f8.4")
		(list 'range 0.0001 10000)
	)	

    (ui-radio-widget "mo_ff_calculate"
        (list 'enabled (ui-eq "mo_ff_constrn" 'MO_FF_CONSTRN_LEAD))
        (ui-choice "fillet.calc.lead" 'MO_FF_CALC_LEAD_RADIUS)
        (ui-choice "fillet.calc.ratio"  'MO_FF_CALC_KNEE_RATIO)
    )

    (ui-distance-widget "mo_ff_lead_radius"
        (list 'enabled (ui-eq "mo_ff_constrn" 'MO_FF_CONSTRN_LEAD))
		(list 'assign 'mo_ff_calculate 'MO_FF_CALC_KNEE_RATIO)
		(list 'assign 'mo_ff_knee_ratio
				(ui-div 'mo_ff_radius 'mo_ff_lead_radius)
		)
        (list 'precision "%f8.4 l")
        (list 'slider_range 0.5 2)
        (list 'range 0.0001 10000 )
    )

    (ui-double-widget "mo_ff_knee_ratio"
        (list 'enabled (ui-eq "mo_ff_constrn" 'MO_FF_CONSTRN_LEAD))
		(list 'assign 'mo_ff_calculate 'MO_FF_CALC_LEAD_RADIUS)
		(list 'assign 'mo_ff_lead_radius
				(ui-div 'mo_ff_radius 'mo_ff_knee_ratio)
		)
        (list 'precision "%f8.4 l")
        (list 'slider_range 0.5 2)
        (list 'range 0.001 1000 )
    )

	(ui-radio-widget "mo_ff_type"       
        (list 'enabled (ui-or (ui-eq "mo_ff_constrn" 'MO_FF_CONSTRN_FF)
							  (ui-eq "mo_ff_blend" #t)))
		(ui-choice "fillet.type.tangent" 'MO_FF_TYPE_TANGENT)
		(ui-choice "fillet.type.blend"  'MO_FF_TYPE_BLEND)
	)

	(ui-blank-widget '(half) )

    (ui-separator-widget)

	(ui-tick-left-widget "mo_ff_blend"  
		(list 'rebuild))

	(ui-tick-right-widget "mo_ff_trim"  )

	(ui-boolean-widget "mo_ff_history"  )
)
