;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Extend Option Box

(ui-string "extend.name"                "Extend Object Options")
(ui-string "mo_extend_type"             "Extend Type")
(ui-string "mo_extend_merge"            "Merge")
(ui-string "mo_extend_length"           "Distance")
(ui-string "mo_extend_percent"          "Percentage")
(ui-string "mo_extend_chain"            "Chain Select")
(ui-string "mo_extend_method"           "Measurement")
(ui-string "mo_extend_continuity"       "Inter Continuity Check")

(ui-string "extend.type.linear"         "Linear")
(ui-string "extend.type.extrap"         "Extrapolate")
(ui-string "extend.type.edge"           "Along Edge")

(ui-string "extend.method.distance"     "Distance")
(ui-string "extend.method.percent"      "Percentage")

(ui-editor "extend.options"

	(list 'title 'extend.name)

	(list 'symbols 	'mo_extend_type		'mo_extend_merge
					'mo_extend_chain	'mo_extend_method
					'mo_extend_length	'mo_extend_percent
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_extend_type"   
		(list 'rebuild)
		(ui-choice "extend.type.linear" 'MO_EXTEND_TYPE_LINEAR)
		(ui-choice "extend.type.extrap" 'MO_EXTEND_TYPE_CUBIC)
		(ui-choice "extend.type.edge"	'MO_EXTEND_TYPE_EDGE)
	)

	(ui-separator-widget)

	(ui-tick-widget "mo_extend_merge"
		(list 'rebuild)
		(list 'enabled (ui-ne "mo_extend_type" 'MO_EXTEND_TYPE_EDGE))
	)
	(ui-tick-widget "mo_extend_chain")
	(ui-tick-widget "mo_extend_continuity"
		(list 'enabled (ui-eq "mo_extend_merge" #f))
	)

	(ui-radio-widget "mo_extend_method"
		(list 'rebuild)
		(ui-choice "extend.method.distance" 1)
		(ui-choice "extend.method.percent" 2)
	)

	(ui-distance-widget "mo_extend_length"
		(list 'enabled (ui-eq "mo_extend_method" 1))
		(list 'precision "%f9.3")
		(list 'range -500000.0 500000.0)
	)

	(ui-double-widget "mo_extend_percent"
		(list 'enabled (ui-eq "mo_extend_method" 2))
		(list 'precision "%f7.2")
		(list 'range -99.99 10000)
	)
)
