;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Dolly Options
;;;

(ui-string "dolly.name"                 "Viewing Options")
(ui-string "mo_eyex"                    "Eye")
(ui-string "mo_viewx"                   "View")
(ui-string "mo_upx"                     "Up")
(ui-string "mo_zoom"                    "Zoom")
(ui-string "mo_scaling"                 "Scaling")

(ui-string "dolly.scaling.prop"         "Proportional")
(ui-string "dolly.scaling.nonprop"      "Non Proportional")
(ui-string "mo_dolly.auto.zoom"         "Auto Dolly")

(ui-editor "dolly.options"              

	(list 'title 'dolly.name)

; Don't include symbols that are initialized by InitViewsOptions
; Otherwise, they get overwritten by the local to global copy, which is
; done following the bounceback to the current continuous function,
; after the InitViewsOptions function is called.
; The symbols initialized by InitViewsOptions are: 
; 'mo_eyex			'mo_eyey		'mo_eyez
; 'mo_viewx			'mo_viewy		'mo_viewz
; 'mo_upx			'mo_upy			'mo_upz
; 'mo_zoom

	(list 'symbols 	
		  'mo_scaling
		  'mo_dolly.auto.zoom
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

;;  InitViewsOptions will stuff the camera values of the current win
;;  into the option box

    (list 'init_option_function "InitViewsOptions")

	(list 'reset_option_function "ResetViewsOptions")

    (list 'go_option_function "GoViewsOptions")


	(ui-wdltriple-linear-widget "mo_eyex" 'mo_eyey    'mo_eyez
		(list 'precision "%f8.4")
	)

	(ui-wdltriple-linear-widget "mo_viewx" 'mo_viewy   'mo_viewz
		(list 'precision "%f8.4")
	)

	(ui-wdltriple-linear-widget "mo_upx" 'mo_upy     'mo_upz
		(list 'precision "%f8.4")
	)

	(ui-double-widget "mo_zoom"         
		(list 'range 0.0034 179.0)
		(list 'precision "%f8.4")
	)

	(ui-radio-widget "mo_scaling"       
        (list 'enabled
            (ui-eq 'mo_scaling `MO_NON_PROPORTIONAL)
        )
		(ui-choice "dolly.scaling.prop" 'MO_PROPORTIONAL)
		(ui-choice "dolly.scaling.nonprop" 'MO_NON_PROPORTIONAL)
	)

	(ui-tick-widget "mo_dolly.auto.zoom")
)
