;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1998, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Draft Properties Displayable Options
;;; 

(ui-string "disp_draftprop.name"           "Draft Properties Options")

(ui-string "mo_disp_draftprop_dirvec"      "Specify Pull Direction as")
(ui-string "disp_draftprop.type.rotations" "Rotations")
(ui-string "disp_draftprop.type.dirvec"    "Vector")

(ui-string "mo_disp_draftprop_usampsperspan"  "Samples per span (U)")
(ui-string "mo_disp_draftprop_vsampsperspan"  "Samples per span (V)")
(ui-string "mo_disp_draftprop_ucutlength"  "Undercut Display Length")  
(ui-string "mo_diagnosticshade_draft_angle_pos" "Draft Angle")
(ui-string "mo_diagnosticshade_draft_angle_pos_tol" "Tolerance")

(ui-string "mo_disp_draftprop_parting_line" "Show Parting Line")
(ui-string "mo_disp_draftprop_tesselation" "...Visual")

(ui-string "mo_diagnosticshade_draft_rotation"       "Rotation")
(ui-string "mo_diagnosticshade_draft_vector"         "Vector")

(ui-editor "disp_draftprop.options"             

	(list 'title 'disp_draftprop.name)

	(list 'symbols 	'mo_diagnosticshade_draft_rotation 
		            'mo_diagnosticshade_draft_vector
					'mo_diagnosticshade_draft_angle_pos 'mo_diagnosticshade_draft_angle_pos_tol
					'mo_disp_draftprop_usampsperspan 'mo_disp_draftprop_vsampsperspan
					'mo_disp_draftprop_ucutlength
					'mo_disp_draftprop_dirvec
					'mo_disp_draftprop_parting_line
					'mo_disp_draftprop_tesselation
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_disp_draftprop_dirvec"    
		(ui-choice "disp_draftprop.type.rotations"   0)
		(ui-choice "disp_draftprop.type.dirvec"      1)
		(list 'rebuild)
	)

	(ui-wdltriple-widget "mo_diagnosticshade_draft_vector" 
        (list 'precision "%f8.4")
        (list 'enabled (ui-eq "mo_disp_draftprop_dirvec" 1))
    )

	(ui-wdltriple-angular-widget  "mo_diagnosticshade_draft_rotation" 
        (list 'precision "%f6.2")
        (list 'enabled (ui-eq "mo_disp_draftprop_dirvec" 0))
    )

	(ui-separator-widget)

	(ui-angle-widget "mo_diagnosticshade_draft_angle_pos" 
        (list 'range 0.0 90.0)
    )

	(ui-angle-widget "mo_diagnosticshade_draft_angle_pos_tol"
        (list 'range 0.0 90.0)
    )

	(ui-separator-widget)

	(ui-integer-widget "mo_disp_draftprop_usampsperspan"
        (list 'slider_range 1 10)
    )

	(ui-integer-widget "mo_disp_draftprop_vsampsperspan"
        (list 'slider_range 1 10)
    )

	(ui-distance-widget "mo_disp_draftprop_ucutlength")

	(ui-separator-widget)

	(ui-tick-left-widget "mo_disp_draftprop_parting_line")
	(ui-tick-right-widget "mo_disp_draftprop_tesselation")

)

