;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1998, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Curve Curvature Displayable Options

;; we will use the same scheme variables as the old
;; curve curvature evaluator.  plus a couple of new ones.

(ui-string "disp_crvcrv.name"           "Curve Curvature Options")
(ui-string "mo_crvcurva_auto_scale"     "Auto Scale")
(ui-string "mo_plotscale"               "Scale Value")
(ui-string "mo_plotvalue"               "Plot Value")
(ui-string "mo_maxcrvlength"            "Cutoff Value")
(ui-string "mo_crvdenval"               "Samples")
(ui-string "mo_crvdisplay"              "Display")
(ui-string "mo_crvinflection"           "Inflection Points")
(ui-string "mo_crvtorsion"              "Torsion")
(ui-string "mo_surfrelative"            "Surface Relative")
(ui-string "mo_enableplot"				"Enable Comb Cutoff")

(ui-string "disp_crvcrv.value.crv"      "Curvature")
(ui-string "disp_crvcrv.value.rad"      "Radius")
(ui-string "disp_crvcrv.value.unorm"    "Unit Normal")
(ui-string "disp_crvcrv.type.span"      "Per Span")
(ui-string "disp_crvcrv.type.curve"     "Per Curve")
(ui-string "disp_crvcrv.displ.comb"     "Comb")
(ui-string "disp_crvcrv.displ.outline"  "Outline")
(ui-string "disp_crvcrv.displ.both"     "Comb + Outline")
(ui-string "disp_crvcrv.displ.neither"  "None")
(ui-string "mo_crvcurva_enable_radius_threshold" "Show Radius Limit")
(ui-string "mo_crvcurva_min_radius_threshold" "Min. Radius Limit")
(ui-string "mo_crvcurva_max_radius_threshold" "Max. Radius Limit")
(ui-string "mo_crvminmax"           	"Min Max Radius")



(ui-editor "disp_crvcrv.options"

	(list 'title 'disp_crvcrv.name)

	(list 'symbols 	'mo_plotvalue
			'mo_surfrelative
			'mo_crvcurva_auto_scale
			'mo_plotscale
			'mo_enableplot
			'mo_maxcrvlength
			'mo_crvdenval
			'mo_crvdisplay
			'mo_crvinflection
			'mo_crvtorsion
			'mo_crvcurva_enable_radius_threshold
			'mo_crvcurva_min_radius_threshold
			'mo_crvcurva_max_radius_threshold
			'mo_crvminmax
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(list 'go_option_function "MoCurvaSetDefaults")
	(list 'save_option_function "MoCurvaSetDefaults")

	(ui-radio-widget "mo_plotvalue"
		(ui-choice "disp_crvcrv.value.crv"   'MO_PLOTVAL_CRV)
		(ui-choice "disp_crvcrv.value.rad"   'MO_PLOTVAL_RAD)
		(ui-choice "disp_crvcrv.value.unorm" 'MO_PLOTVAL_UNORM)
	)

	(ui-tick-widget "mo_surfrelative")

	(ui-tick-widget "mo_crvcurva_auto_scale"
		(list 'rebuild #t)
	)
	
	(ui-double-widget "mo_plotscale" 
		(list 'enabled (ui-eq "mo_crvcurva_auto_scale" #f))
		(list 'range -1000.0 1000.0)
        (list 'slider_range -100.0 100.0)
	)

	(ui-integer-widget "mo_crvdenval"   
		(list 'range 0 1000)
	)
	
	(ui-separator-widget)

	(ui-radio-widget "mo_crvdisplay"    
		(ui-choice "disp_crvcrv.displ.comb"  'MO_CRVDISPLAY_COMB)
		(ui-choice "disp_crvcrv.displ.both"  'MO_CRVDISPLAY_COMBLINE)
		(ui-choice "disp_crvcrv.displ.outline" 'MO_CRVDISPLAY_OUTLINE)
	)

	(ui-tick-left-widget "mo_crvtorsion")

	(ui-tick-right-widget "mo_crvinflection")
	
	(ui-tick-left-widget "mo_crvcurva_enable_radius_threshold"
		(list 'rebuild )
	)

	(ui-tick-right-widget "mo_crvminmax")

	(ui-distance-widget "mo_crvcurva_min_radius_threshold" 
		(list 'enabled (ui-eq "mo_crvcurva_enable_radius_threshold" #t))		
		(list 'precision "%f9.4")
		(list 'range 0 10000.0)
	)

	(ui-distance-widget "mo_crvcurva_max_radius_threshold" 
		(list 'enabled (ui-eq "mo_crvcurva_enable_radius_threshold" #t))
		(list 'precision "%f9.4")
		(list 'range 0 10000.0)
	)

	(ui-tick-widget "mo_enableplot"
		(list 'rebuild #t)
	)
	(ui-distance-widget "mo_maxcrvlength" 
		(list 'enabled (ui-eq "mo_enableplot" #t))
		(list 'precision "%f9.4")
		(list 'range 0 10000.0)
	)


)

