;;********************************************************************
;; (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
;; this code,  you  are  agreeing  to the terms and conditions of the
;; License  Agreement  included  in  the documentation for this code.
;; AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
;; CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
;; IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
;; DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
;; DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
;;
;; Use, duplication,  or disclosure by the U.S. Government is subject
;; to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
;; Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
;; (Rights  in Technical Data and Computer Software),  as applicable.
;;******************************************************************/
 

;;; DispMapToMesh Option Box
;;;

(ui-string "dispMapToMesh.name"                 "Displacement Map To Mesh Options")

(ui-string "mo_dispMapToMesh_tolerance"         "Mesh Tolerance (cm)")
(ui-string "mo_dispMapToMesh_dispdetail"        "Displacement Detail")
(ui-string "mo_dispMapToMesh_use_existing"      "Use values from Render Globals")


(ui-editor "dispMapToMesh.options"               
	
	(list 'title 'dispMapToMesh.name)

	(list 'symbols 	"mo_dispMapToMesh_dispdetail"
                    "mo_dispMapToMesh_tolerance"
                    "mo_dispMapToMesh_use_existing"
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)
	
	(ui-tick-widget "mo_dispMapToMesh_use_existing"
		(list 'rebuild #t))

    (ui-double-widget "mo_dispMapToMesh_tolerance"
		(list 'enabled (ui-eq "mo_dispMapToMesh_use_existing" #f))
        (list 'precision "%8.5")
        (list 'range 0.001 0.10)
    )
        
	(ui-integer-widget "mo_dispMapToMesh_dispdetail"
		(list 'enabled (ui-eq "mo_dispMapToMesh_use_existing" #f))
		(list 'slider-range 10 256)
        (list 'range 10 512)
    )

    
)
