;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
;  this code,  you  are  agreeing  to the terms and conditions of the
;  License  Agreement  included  in  the documentation for this code.
;  AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
;  CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
;  IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
;  DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
;  DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
;
;  Use, duplication,  or disclosure by the U.S. Government is subject
;  to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
;  Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
;  (Rights  in Technical Data and Computer Software),  as applicable.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(ui-string "mo_arc3Point_degree"        "Degree")
(ui-string "mo_arc3Point_spans"         "Spans")

(ui-editor "arc3Point.options"
    (list 'title "Arc (3 Point) Options")

    (list 'symbols
        'mo_arc3Point_degree
        'mo_arc3Point_spans
    )

    (list 'buttons 'Reset 'Save 'Exit 'Go)

    (ui-integer-widget "mo_arc3Point_degree"
        (list 'range 2 7)
        (list 'assign (ui-and (ui-eq 'mo_arc3Point_degree 2) (ui-eq 'mo_arc3Point_spans 1))
                      'mo_arc3Point_spans 2)

        ; Can't do ui-gt and ui-add at the same time, so calculate the value of the add
        ; into a temporary and then use that for the ui-gt
        (list 'assign 'mo_arc3Point_temp (ui-add 'mo_arc3Point_degree 'mo_arc3Point_spans))
        (list 'assign (ui-gt 'mo_arc3Point_temp 16)
                      'mo_arc3Point_spans (ui-sub 16 'mo_arc3Point_degree))
    )

    (ui-integer-widget "mo_arc3Point_spans"
        (list 'enabled (ui-eq "mo_allow_rat_curves_surfaces" #f))
        (list 'range 1 14)

        (list 'assign (ui-and (ui-eq 'mo_arc3Point_spans 1) (ui-eq 'mo_arc3Point_degree 2))
                      'mo_arc3Point_degree 3)

        ; Can't do ui-gt and ui-add at the same time, so calculate the value of the add
        ; into a temporary and then use that for the ui-gt
        (list 'assign 'mo_arc3Point_temp (ui-add 'mo_arc3Point_degree 'mo_arc3Point_spans))
        (list 'assign (ui-gt 'mo_arc3Point_temp 16)
                      'mo_arc3Point_degree (ui-sub 16 'mo_arc3Point_spans))
    )
)


(ui-string "mo_arc2Point_degree"        "Degree")
(ui-string "mo_arc2Point_spans"         "Spans")

(ui-editor "arc2Point.options"
    (list 'title "Arc (2 Point) Options")

    (list 'symbols
        'mo_arc2Point_degree
        'mo_arc2Point_spans
    )

    (list 'buttons 'Reset 'Save 'Exit 'Go)

    (ui-integer-widget "mo_arc2Point_degree"
        (list 'range 2 7)
        (list 'assign (ui-and (ui-eq 'mo_arc2Point_degree 2) (ui-eq 'mo_arc2Point_spans 1))
                      'mo_arc2Point_spans 2)

        ; Can't do ui-gt and ui-add at the same time, so calculate the value of the add
        ; into a temporary and then use that for the ui-gt
        (list 'assign 'mo_arc2Point_temp (ui-add 'mo_arc2Point_degree 'mo_arc2Point_spans))
        (list 'assign (ui-gt 'mo_arc2Point_temp 16)
                      'mo_arc2Point_spans (ui-sub 16 'mo_arc2Point_degree))
    )

    (ui-integer-widget "mo_arc2Point_spans"
        (list 'enabled (ui-eq "mo_allow_rat_curves_surfaces" #f))
        (list 'range 1 14)

        (list 'assign (ui-and (ui-eq 'mo_arc2Point_spans 1) (ui-eq 'mo_arc2Point_degree 2))
                      'mo_arc2Point_degree 3)

        ; Can't do ui-gt and ui-add at the same time, so calculate the value of the add
        ; into a temporary and then use that for the ui-gt
        (list 'assign 'mo_arc2Point_temp (ui-add 'mo_arc2Point_degree 'mo_arc2Point_spans))
        (list 'assign (ui-gt 'mo_arc2Point_temp 16)
                      'mo_arc2Point_degree (ui-sub 16 'mo_arc2Point_spans))
    )
)

(ui-string "mo_arcConcentric_degree"        "Degree")
(ui-string "mo_arcConcentric_spans"         "Spans")

(ui-editor "arcConcentric.options"
    (list 'title "Concentric Arc Options")

    (list 'symbols
        'mo_arcConcentric_degree
        'mo_arcConcentric_spans
    )

    (list 'buttons 'Reset 'Save 'Exit 'Go)

    (ui-integer-widget "mo_arcConcentric_degree"
        (list 'range 2 7)
        (list 'assign (ui-and (ui-eq 'mo_arcConcentric_degree 2) (ui-eq 'mo_arcConcentric_spans 1))
                      'mo_arcConcentric_spans 2)

        ; Can't do ui-gt and ui-add at the same time, so calculate the value of the add
        ; into a temporary and then use that for the ui-gt
        (list 'assign 'mo_arcConcentric_temp (ui-add 'mo_arcConcentric_degree 'mo_arcConcentric_spans))
        (list 'assign (ui-gt 'mo_arcConcentric_temp 16)
                      'mo_arcConcentric_spans (ui-sub 16 'mo_arcConcentric_degree))
    )

    (ui-integer-widget "mo_arcConcentric_spans"
        (list 'enabled (ui-eq "mo_allow_rat_curves_surfaces" #f))
        (list 'range 1  14)

        (list 'assign (ui-and (ui-eq 'mo_arcConcentric_spans 1) (ui-eq 'mo_arcConcentric_degree 2))
                      'mo_arcConcentric_degree 3)

        ; Can't do ui-gt and ui-add at the same time, so calculate the value of the add
        ; into a temporary and then use that for the ui-gt
        (list 'assign 'mo_arcConcentric_temp (ui-add 'mo_arcConcentric_degree 'mo_arcConcentric_spans))
        (list 'assign (ui-gt 'mo_arcConcentric_temp 16)
                      'mo_arcConcentric_degree (ui-sub 16 'mo_arcConcentric_spans))
    )
)

(ui-string "mo_arcTangent_degree"        "Degree")
(ui-string "mo_arcTangent_spans"         "Spans")

(ui-editor "arcTangent.options"
    (list 'title "Arc Tangent To Curve Options")

    (list 'symbols
        'mo_arcTangent_degree
        'mo_arcTangent_spans
    )

    (list 'buttons 'Reset 'Save 'Exit 'Go)

    (ui-integer-widget "mo_arcTangent_degree"
        (list 'range 2 7)
        (list 'assign (ui-and (ui-eq 'mo_arcTangent_degree 2) (ui-eq 'mo_arcTangent_spans 1))
                      'mo_arcTangent_spans 2)

        ; Can't do ui-gt and ui-add at the same time, so calculate the value of the add
        ; into a temporary and then use that for the ui-gt
        (list 'assign 'mo_arcTangent_temp (ui-add 'mo_arcTangent_degree 'mo_arcTangent_spans))
        (list 'assign (ui-gt 'mo_arcTangent_temp 16)
                      'mo_arcTangent_spans (ui-sub 16 'mo_arcTangent_degree))
    )

    (ui-integer-widget "mo_arcTangent_spans"
        (list 'enabled (ui-eq "mo_allow_rat_curves_surfaces" #f))
        (list 'range 1 14)

        (list 'assign (ui-and (ui-eq 'mo_arcTangent_spans 1) (ui-eq 'mo_arcTangent_degree 2))
                      'mo_arcTangent_degree 3)

        ; Can't do ui-gt and ui-add at the same time, so calculate the value of the add
        ; into a temporary and then use that for the ui-gt
        (list 'assign 'mo_arcTangent_temp (ui-add 'mo_arcTangent_degree 'mo_arcTangent_spans))
        (list 'assign (ui-gt 'mo_arcTangent_temp 16)
                      'mo_arcTangent_degree (ui-sub 16 'mo_arcTangent_spans))
    )
)
