;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Duplicate Objects Option Box
;;;
(ui-string "copy.name"                  "Duplicate Object Options")
(ui-string "mo_cpgroup"                 "Group")
(ui-string "mo_copy_geom_type"          "Geometry Type")
(ui-string "mo_copy_geom_mode"          "Distance on geometry")
(ui-string "mo_copy_geom_distance"      "Arc Length Distance")
(ui-string "mo_copy_geom_vectoru"       "Direction on geometry")

(ui-string "mo_cpynumber"               "Number")
(ui-string "ao_copy_animation"			"Copy Animation")
(ui-string "ao_copy_params"             "Parameters")
(ui-string "ao_copy_hierarchy"          "Hierarchy")
(ui-string "ao_cpobjoffset"             "Time Offset")

(ui-string "mo_xlatex"                  "Translation")
(ui-string "mo_rotatex"                 "Rotation")
(ui-string "mo_scalex"                  "Scaling")
(ui-string "copy.type.copy"             "Copy")
(ui-string "copy.type.instance"         "Instance")
(ui-string "copy.params.all"         	"All")
(ui-string "copy.params.global"      	"Global")
(ui-string "copy.params.local"       	"Local")
(ui-string "copy.hier.none"          	"None")
(ui-string "copy.hier.above"         	"Above")
(ui-string "copy.hier.below"         	"Below")
(ui-string "copy.hier.both"          	"Both")
(ui-string "mo_copy_geom_dir"			"Direction")
(ui-string "copy.geom.uposdir"			"Positive U")
(ui-string "copy.geom.unegdir"			"Negative U")
(ui-string "copy.geom.vposdir"			"Positive V")
(ui-string "copy.geom.vnegdir"			"Negative V")
(ui-string "copy.geom.autodir"			"Automatic")

(ui-string "copy.mode.fraction"			"Equal Spacing")
(ui-string "copy.mode.distance"			"Fixed Arc Length")
(ui-string "mo_copy_xyz_or_uv_space"	"Transform in")
(ui-string "copy.xyz"					"XYZ space")
(ui-string "copy.uv"					"Geometry space")

(ui-string "mo_copy_geom_vectoru"		"U direction")
(ui-string "mo_copy_geom_vectorv"		"V direction")

(ui-editor "copy.options"               

	(list 'title 'copy.name)

	(list 'symbols 	'mo_xlatex		'mo_xlatey			'mo_xlatez
					'mo_rotatex		'mo_rotatey			'mo_rotatez
					'mo_scalex		'mo_scaley			'mo_scalez
					'mo_cpgroup		'mo_copy_geom_type	'mo_cpynumber
					'ao_copy_animation	'ao_copy_params	'ao_copy_hierarchy
					'ao_cpobjoffset
					'mo_copy_function
					'mo_copy_geom_mode
					'mo_copy_geom_vectoru
					'mo_copy_geom_vectorv
					'mo_copy_geom_distance
					'mo_copy_xyz_or_uv_space
					'mo_copy_geom_dir
					'mo_copy_geom_positive
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)


	(ui-integer-widget "mo_cpynumber"   
		(list 'range 1 10000)
		(list 'slider_range 1 50)
	)


	(ui-radio-widget "mo_copy_xyz_or_uv_space" 
		(list 'rebuild #t)
		(ui-choice "copy.xyz"     'MO_COPY_XYZ_SPACE)
		(ui-choice "copy.uv"	  'MO_COPY_UV_SPACE
			(list 'assign 'mo_cpgroup #t)
			(list 'assign 'mo_copy_geom_type 'MO_AS_COPY)		
			(list 'assign 'mo_copy_function "ModelCopyGroupOn")
		)
	)
	
	(ui-separator-widget)

	(ui-wdltriple-linear-widget "mo_xlatex" 'mo_xlatey 		'mo_xlatez
		(list 'enabled (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_XYZ_SPACE))
		(list 'precision "%f8.4")

	)

	(ui-wdltriple-angular-widget "mo_rotatex" 'mo_rotatey		'mo_rotatez
		(list 'precision "%f8.4")
		(list 'enabled (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_XYZ_SPACE))
	)

	(ui-wdltriple-widget "mo_scalex"    'mo_scaley		'mo_scalez
		(list 'precision "%f8.4")
		(list 'enabled (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_XYZ_SPACE))
	)

	(ui-tick-widget "mo_cpgroup"        
		(list 'rebuild #t)

		(list 'assign (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_UV_SPACE) 
			  'mo_cpgroup #t)

		(list 'assign (ui-eq "mo_cpgroup" #f) 'mo_copy_geom_type 'MO_AS_COPY)

	;	If group is on, use ModelCopyGroupOn UI function momentary function
		(list 'assign (ui-eq "mo_cpgroup" #t) 
								'mo_copy_function "ModelCopyGroupOn")

	;	If group is off, use ModelCopyGroupOff UI function
		(list 'assign (ui-eq "mo_cpgroup" #f) 
								'mo_copy_function "ModelCopyGroupOff")
		(list 'assign
			(ui-or	(ui-eq "ao_copy_hierarchy" 'AO_HIER_ABOVE)
					(ui-eq "ao_copy_hierarchy" 'AO_HIER_BOTH)
					(ui-eq "ao_copy_hierarchy" 'AO_HIER_BELOW))
											'ao_copy_hierarchy 'AO_HIER_NONE)

		(list 'enabled (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_XYZ_SPACE))
	)


	(ui-radio-widget "mo_copy_geom_type" 
		(list 'rebuild #t)
		(list 'enabled (ui-and (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_XYZ_SPACE)
							   (ui-eq "mo_cpgroup" #t) )
			  )
		(ui-choice "copy.type.copy"     'MO_AS_COPY)
		(ui-choice "copy.type.instance" 'MO_AS_INSTANCE
			(list 'assign 'mo_cpgroup		#t)
			(list 'assign 'mo_copy_function "ModelCopyGroupOn")
			(list 'assign 'ao_copy_hierarchy 'AO_HIER_NONE)
		)
	)


	(ui-tick-widget "ao_copy_animation"
		(list 'rebuild #t)
		(list 'enabled 
				(ui-and (ui-eq "animation_module" #t)
						(ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_XYZ_SPACE)
				)
		)

	)

	(ui-radio-widget "mo_copy_geom_mode"
			(list 'rebuild #t)
			(list 'enabled (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_UV_SPACE))
			(ui-choice "copy.mode.fraction"     'MO_COPY_GEOM_MODE_FRACTIONAL)
			(ui-choice "copy.mode.distance"		'MO_COPY_GEOM_MODE_DISTANCE )
	)


;	(ui-double-widget "mo_copy_geom_vectoru" 
;					  (list 'enabled (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_UV_SPACE))
;					  (list 'precision "%f5.2")
;					  (list 'range -1.0 +1.0)
;					  (list 'slider_range -1.0 +1.0)
;					  )

;	(ui-double-widget "mo_copy_geom_vectorv"  
;					  (list 'enabled (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_UV_SPACE))
;					  (list 'precision "%f5.2")
;					  (list 'range -1.0 +1.0)
;					  (list 'slider_range -1.0 +1.0))
	(ui-distance-widget "mo_copy_geom_distance"  
		(list 'enabled (ui-and 
						(ui-eq "mo_copy_geom_mode" 'MO_COPY_GEOM_MODE_DISTANCE)
						(ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_UV_SPACE)
						))
		(list 'precision "%f5.4")
		(list 'range 0.00001)		
	)	

	(ui-radio-widget "mo_copy_geom_dir"
		(list 'enabled (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_UV_SPACE))
		(ui-choice "copy.geom.uposdir"  'MO_COPY_GEOM_MODE_UPOS_DIR)
		(ui-choice "copy.geom.unegdir"  'MO_COPY_GEOM_MODE_UNEG_DIR)
		(ui-choice "copy.geom.vposdir"  'MO_COPY_GEOM_MODE_VPOS_DIR)
		(ui-choice "copy.geom.vnegdir"  'MO_COPY_GEOM_MODE_VNEG_DIR)
		(ui-choice "copy.geom.autodir"	'MO_COPY_GEOM_MODE_AUTO_DIR)
	)

	(ui-group-widget
		(list 'title "Animation Parameters")
		(list 'enabled (ui-and (ui-eq "ao_copy_animation" #t)
							   (ui-eq "mo_copy_xyz_or_uv_space" 'MO_COPY_XYZ_SPACE)
							   )
			  )
	)

	(ui-radio-widget "ao_copy_params"   
		(list 'columns 3)
		(ui-choice "copy.params.all" 'AO_COPY_ALL)
		(ui-choice "copy.params.global" 'AO_COPY_GLOBAL_PARAM_CTRL)
		(ui-choice "copy.params.local" 'AO_COPY_LOCAL_PARAM_CTRL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_copy_hierarchy" 
		(list 'rebuild #t)
		(ui-choice "copy.hier.none"  'AO_HIER_NONE)

	;	If user wants to copy animation below, then don't allow them to use
	;	Group option, otherwise you're overwriting animation below with
	;	what's already below.
		(ui-choice "copy.hier.below" 'AO_HIER_BELOW
			(list 'assign 'mo_copy_geom_type	'MO_AS_COPY)
			(list 'assign 'mo_cpgroup			#f)
			(list 'assign 'mo_copy_function	"ModelCopyGroupOff")
		)

	;	If user wants to copy animation above, then don't allow them to use
	;	Group option, otherwise you're overwriting animation above with
	;	what's already above.
		(ui-choice "copy.hier.above" 'AO_HIER_ABOVE
			(list 'assign 'mo_copy_geom_type	'MO_AS_COPY)
			(list 'assign 'mo_cpgroup			#f)
			(list 'assign 'mo_copy_function	"ModelCopyGroupOff")
		)

		(ui-choice "copy.hier.both"  'AO_HIER_BOTH
			(list 'assign 'mo_copy_geom_type	'MO_AS_COPY)
			(list 'assign 'mo_cpgroup			#f)
			(list 'assign 'mo_copy_function	"ModelCopyGroupOff")
		)
	)

	(ui-separator-widget)

	(ui-double-widget "ao_cpobjoffset"  
		(list 'precision "%f5.2")
	)

)
