;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; ConvertReference Option Box
;;;

(ui-string "mo_convertRef.name"              "Translate Reference Options")

(ui-string "mo_convertRef_use_ref_dir"       "Use reference directory")
(ui-string "mo_convertRef_dir"               "Output Directory")
(ui-string "mo_reference_output_dir"         "Output Directory")

(ui-string "mo_convertRef_tess_type"         "Surface Tessellator")
(ui-string "mo_convertRef_tess_fast"         "Fast")
(ui-string "mo_convertRef_tess_accurate"     "Accurate")

(ui-string "mo_convertRef_tol"               "Surface Tolerance")

(ui-string "mo_convertRef_crv_tol"           "Curve Tolerance")

(ui-editor "mo_convertRef.options"               
	
	(list 'title 'mo_convertRef.name)

	(list 'symbols 	"mo_convertRef_use_ref_dir"
                    "mo_convertRef_dir"
                    "mo_convertRef_tess_type"
                    "mo_convertRef_tol"
                    "mo_convertRef_crv_tol"
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

    (ui-tick-widget "mo_convertRef_use_ref_dir"
                    (list 'rebuild #t))
    
    (ui-string-widget "mo_convertRef_dir"
                      (list 'enabled (ui-eq "mo_convertRef_use_ref_dir" #f))
                      (list 'function			"Bitmap_Directory_browser" )
                      (list 'functionlabel    "Browse..." )
                      )

    (ui-string-widget "mo_reference_output_dir"
                      (list 'enabled (ui-eq "mo_convertRef_use_ref_dir" #t))
                      (list 'disabled (ui-eq "mo_convertRef_use_ref_dir" #t))
                      )


    (ui-blank-widget)

    (ui-separator-widget)
    
    (ui-distance-widget "mo_convertRef_crv_tol"
        (list 'precision "%8.5")
        (list 'range 0.0001 0.1)
        (list 'slider_range 0.0001 0.1)
    )
    
    (ui-blank-widget)

	(ui-radio-widget "mo_convertRef_tess_type" 
		(ui-choice "mo_convertRef_tess_fast"       'MO_TGLSHADE_ARUBA_FAST_TESSELATOR)
		(ui-choice "mo_convertRef_tess_accurate"   'MO_TGLSHADE_ARUBA_TESSELATOR)
	)
    
    (ui-distance-widget "mo_convertRef_tol"
        (list 'precision "%8.5")
        (list 'range 0.0001 1.0)
        (list 'slider_range 0.01 1.0)
    )
)
