;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Quick Wire Options
;;;

(ui-string "contour.name"               "Contour Options")
(ui-string "mo_contour_type"            "Contour Type")
(ui-string "mo_contour_all"             "Scope")
(ui-string "contour.kind.uvpatch"    "uv-patch")
(ui-string "contour.kind.uvsurface"  "uv-surface")
(ui-string "contour.kind.uvcubic"    "uv-cubic")
(ui-string "contour.kind.section"    "section")

(ui-string "contour.scope.all"          "All")
(ui-string "contour.scope.active"       "Active")

(ui-string "mo_uvpatch_precision" "Patch Precision")

(ui-string "mo_uvsurface_precision" "Surface Precision")

(ui-string "mo_uvcubic_u"               "U contours     ")
(ui-string "mo_uvcubic_uspacing"       "U precision")
(ui-string "mo_uvcubic_uoffset"         "U offset %")
(ui-string "mo_uvcubic_v"               "V contours     ")
(ui-string "mo_uvcubic_vspacing"       "V precision")
(ui-string "mo_uvcubic_voffset"         "V offset %")


(ui-string "mo_section_x"               "X contours     ")
(ui-string "mo_section_xspacing"       "X spacing")
(ui-string "mo_section_xoffset"         "X offset %")
(ui-string "mo_section_y"               "Y contours     ")
(ui-string "mo_section_yspacing"       "Y spacing")
(ui-string "mo_section_yoffset"         "Y offset %")
(ui-string "mo_section_z"               "Z contours     ")
(ui-string "mo_section_zspacing"       "Z spacing")
(ui-string "mo_section_zoffset"         "Z offset %")
(ui-string "mo_section_colors"          "Colors")

(ui-string "section.x.on" "On")
(ui-string "section.x.off" "Off")
(ui-string "section.y.on" "On")
(ui-string "section.y.off" "Off")
(ui-string "section.z.on" "On")
(ui-string "section.z.off" "Off")
(ui-string "section.c.yes" "Yes")
(ui-string "section.c.no" "No")

(ui-editor "contour.options"            

	(list 'title 'contour.name)

	(list 'symbols 'mo_contour_all	      'mo_contour_quality)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "mo_contour_type"
			 (list "rebuild")
			 (list 'columns 2)
			 (ui-choice "contour.kind.uvpatch"  'MO_CONTOUR_UVPATCH)
			 (ui-choice "contour.kind.uvsurface" 'MO_CONTOUR_UVSURFACE)
			 (ui-choice "contour.kind.uvcubic"  'MO_CONTOUR_UVCUBIC)
			 (ui-choice "contour.kind.section" 'MO_CONTOUR_SECTION)
	)
	

	(ui-radio-widget "mo_contour_all"    
			 (ui-choice "contour.scope.all"  #t)
			 (ui-choice "contour.scope.active" #f)
	)

	(ui-separator-widget)

	(ui-double-widget "mo_uvpatch_precision" 
 			 (list 'enabled 
				(ui-eq "mo_contour_type" 'MO_CONTOUR_UVPATCH)
			       )
			 (list "rebuild")
		(list 'precision "%f6.0")
		(list 'range 0 62.0)
	)

	(ui-double-widget "mo_uvsurface_precision" 
 			 (list 'enabled 
				(ui-eq "mo_contour_type" 'MO_CONTOUR_UVSURFACE)
			       )
			 (list "rebuild")
		(list 'precision "%f6.0")
		(list 'range 0 62.0)
	)

	(ui-double-widget "mo_uvcubic_uspacing" 
 			 (list 'enabled 
				(ui-eq "mo_contour_type" 'MO_CONTOUR_UVCUBIC)
			       )
			 (list "rebuild")
		(list 'precision "%f6.0")
		(list 'range 0 100.0)
	)

;	(ui-double-widget "mo_uvcubic_uoffset" 
; 			 (list 'enabled 
;				(ui-eq "mo_contour_type" 'MO_CONTOUR_UVCUBIC)
;			       )
;			 (list "rebuild")
;		(list 'precision "%f6.2")
;		(list 'range 0 100.0)
;	)

	(ui-separator-widget
	 (list 'enabled 
	       (ui-eq "mo_contour_type" 'MO_CONTOUR_UVCUBIC)
	       )
	 (list "rebuild")
	 )

	(ui-double-widget "mo_uvcubic_vspacing" 
 			 (list 'enabled 
				(ui-eq "mo_contour_type" 'MO_CONTOUR_UVCUBIC)
			       )
			 (list "rebuild")
		(list 'precision "%f6.0")
		(list 'range 0 100.0)
	)

;	(ui-double-widget "mo_uvcubic_voffset" 
; 			 (list 'enabled 
;				(ui-eq "mo_contour_type" 'MO_CONTOUR_UVCUBIC)
;			       )
;			 (list "rebuild")
;		(list 'precision "%f6.2")
;		(list 'range 0 100.0)
;	)

	(ui-radio-widget "mo_section_colors"    
 			 (list 'enabled 
			       (ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
			       )
			 (list "rebuild")
			 (ui-choice "section.c.yes"  #t)
			 (ui-choice "section.c.no" #f)
	)

	(ui-separator-widget
	 (list 'enabled 
	       (ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
	       )
	 (list "rebuild")
	 )

	(ui-radio-widget "mo_section_x"    
 			 (list 'enabled 
			       (ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
			       )
			 (list "rebuild")
		(ui-choice "section.x.on"  #t)
		(ui-choice "section.x.off" #f)
	)
	(ui-double-widget "mo_section_xspacing" 
 			 (list 'enabled 
			       (ui-and
				(ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
				(ui-eq "mo_section_x" #t)
				)
			       )
			 (list "rebuild")
		(list 'precision "%f6.2")
		(list 'range 0 10.0)
	)

	(ui-double-widget "mo_section_xoffset" 
 			 (list 'enabled 
			       (ui-and
				(ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
				(ui-eq "mo_section_x" #t)
				)
			       )
			 (list "rebuild")
		(list 'precision "%f6.2")
		(list 'range 0 100.0)
	)

	(ui-separator-widget
	 (list 'enabled 
	       (ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
	       )
	 (list "rebuild")
	 )

	(ui-radio-widget "mo_section_y"    
 			 (list 'enabled 
			       (ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
			       )
			 (list "rebuild")
		(ui-choice "section.y.on"  #t)
		(ui-choice "section.y.off" #f)
	)
	(ui-double-widget "mo_section_yspacing" 
 			 (list 'enabled 
			       (ui-and
				(ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
				(ui-eq "mo_section_y" #t)
				)
			       )
			 (list "rebuild")
		(list 'precision "%f6.2")
		(list 'range 0 10.0)
	)
	(ui-double-widget "mo_section_yoffset" 
 			 (list 'enabled 
			       (ui-and
				(ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
				(ui-eq "mo_section_y" #t)
				)
			       )
			 (list "rebuild")
		(list 'precision "%f6.2")
		(list 'range 0 100.0)
	)


	(ui-separator-widget
	 (list 'enabled 
	       (ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
	       )
	 (list "rebuild")
	 )

	(ui-radio-widget "mo_section_z"    
 			 (list 'enabled 
			       (ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
			       )
			 (list "rebuild")
		(ui-choice "section.z.on"  #t)
		(ui-choice "section.z.off" #f)
	)
	(ui-double-widget "mo_section_zspacing" 
 			 (list 'enabled 
			       (ui-and
				(ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
				(ui-eq "mo_section_z" #t)
				)
			       )
			 (list "rebuild")
		(list 'precision "%f6.2")
		(list 'range 0 10.0)
	)
	(ui-double-widget "mo_section_zoffset" 
 			 (list 'enabled 
			       (ui-and
				(ui-eq "mo_contour_type" 'MO_CONTOUR_SECTION)
				(ui-eq "mo_section_z" #t)
				)
			       )
			 (list "rebuild")
		(list 'precision "%f6.2")
		(list 'range 0 100.0)
	)


)
