;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; CloudToMesh Option Box
;;;

(ui-string "cloudToMesh.name"                 "Cloud To Mesh Options")
(ui-string "mo_cloudToMesh_estimate_switch"    "Estimate Tolerances")
(ui-string "mo_cloudToMesh_vertex_tolerance"   "Vertex Tolerance")
(ui-string "mo_cloudToMesh_grouping_tolerance" "Grouping Tolerance")
(ui-string "mo_cloudToMesh_unify_normals"      "Unify Normals")
(ui-string "mo_cloudToMesh_limit_edge_length"  "Limit edge length")
(ui-string "mo_cloudToMesh_max_edge_length"    "Max edge length")
(ui-string "mo_cloudToMesh_max_hole_edges"     "Max hole edges")

(ui-editor "cloudToMesh.options"               
	
	(list 'title 'cloudToMesh.name)

	(list 'symbols 	"mo_cloudToMesh_estimate_switch"
	                "mo_cloudToMesh_vertex_tolerance"
                    "mo_cloudToMesh_grouping_tolerance"
                    "mo_cloudToMesh_unify_normals"
                    "mo_cloudToMesh_limit_edge_length"
                    "mo_cloudToMesh_max_edge_length"
                    "mo_cloudToMesh_max_hole_edges"
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)
	
    (ui-distance-widget "mo_cloudToMesh_vertex_tolerance"
        (list 'enabled (ui-eval "awCloudToMeshEstimate") )
        (list 'precision "%8.5")
        (list 'range 0.0 1000.0)
    )
        
    (ui-blank-widget)
                                
    (ui-distance-widget "mo_cloudToMesh_grouping_tolerance"
        (list 'precision "%8.5")
        (list 'range 0.0 1000.0)
    )
    
    (ui-blank-widget)
                                
    (ui-tick-widget "mo_cloudToMesh_estimate_switch"
	    (list 'assign 'mo_cloudToMesh_estimate_switch #f)
	    (list 'assign 'mo_cloudToMesh_estimate #t)
	    (list 'rebuild #t)
	)
    
    (ui-blank-widget)
                                
    (ui-separator-widget)
    
    (ui-tick-widget "mo_cloudToMesh_unify_normals")

    (ui-blank-widget)
                                
    (ui-tick-widget "mo_cloudToMesh_limit_edge_length"
        (list 'rebuild #t)
    )

    (ui-distance-widget "mo_cloudToMesh_max_edge_length"
        (list 'enabled (ui-eq "mo_cloudToMesh_limit_edge_length" #t))
        (list 'range 0.01 100.0)
     )

    (ui-blank-widget)

    (ui-integer-widget "mo_cloudToMesh_max_hole_edges"
        (list 'range 1 100 )
    )
    
)
